/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.entity;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.NMSVersion;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.objects.properties.PropertyParser;
import org.bukkit.entity.Entity;
import org.bukkit.entity.PigZombie;
import org.bukkit.entity.Vindicator;
import org.bukkit.entity.Wolf;

public class EntityAngry
implements Property {
    public static final String[] handledMechs = new String[]{"angry"};
    EntityTag entity;

    public static boolean describes(ObjectTag object) {
        if (!(object instanceof EntityTag)) {
            return false;
        }
        Entity entity = ((EntityTag)object).getBukkitEntity();
        return entity instanceof Wolf || entity instanceof PigZombie || NMSHandler.getVersion().isAtLeast(NMSVersion.v1_18) && entity instanceof Vindicator;
    }

    public static EntityAngry getFrom(ObjectTag entity) {
        if (!EntityAngry.describes(entity)) {
            return null;
        }
        return new EntityAngry((EntityTag)entity);
    }

    private EntityAngry(EntityTag entity) {
        this.entity = entity;
    }

    @Override
    public String getPropertyString() {
        if (this.isWolf()) {
            return this.getWolf().isAngry() ? "true" : null;
        }
        if (this.isPigZombie()) {
            return this.getPigZombie().isAngry() ? "true" : null;
        }
        if (this.isVindicator()) {
            return this.getVindicator().isJohnny() ? "true" : null;
        }
        return null;
    }

    @Override
    public String getPropertyId() {
        return "angry";
    }

    public static void registerTags() {
        PropertyParser.registerTag(ElementTag.class, "angry", (attribute, entity) -> {
            if (entity.isWolf()) {
                return new ElementTag(entity.getWolf().isAngry());
            }
            if (entity.isPigZombie()) {
                return new ElementTag(entity.getPigZombie().isAngry());
            }
            if (entity.isVindicator()) {
                return new ElementTag(entity.getVindicator().isJohnny());
            }
            return null;
        }, new String[0]);
    }

    public boolean isWolf() {
        return this.entity.getBukkitEntity() instanceof Wolf;
    }

    public boolean isPigZombie() {
        return this.entity.getBukkitEntity() instanceof PigZombie;
    }

    public boolean isVindicator() {
        return NMSHandler.getVersion().isAtLeast(NMSVersion.v1_18) && this.entity.getBukkitEntity() instanceof Vindicator;
    }

    public Wolf getWolf() {
        return (Wolf)this.entity.getBukkitEntity();
    }

    public PigZombie getPigZombie() {
        return (PigZombie)this.entity.getBukkitEntity();
    }

    public Vindicator getVindicator() {
        return (Vindicator)this.entity.getBukkitEntity();
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("angry") && mechanism.requireBoolean()) {
            if (this.isWolf()) {
                this.getWolf().setAngry(mechanism.getValue().asBoolean());
            } else if (this.isPigZombie()) {
                this.getPigZombie().setAngry(mechanism.getValue().asBoolean());
            } else if (this.isVindicator()) {
                this.getVindicator().setJohnny(mechanism.getValue().asBoolean());
            }
        }
    }
}

