/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.scripts;

import com.denizenscript.denizencore.DenizenCore;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsRuntimeException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.core.ScriptTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.scripts.commands.BracedCommand;
import com.denizenscript.denizencore.scripts.commands.CommandRegistry;
import com.denizenscript.denizencore.scripts.commands.Holdable;
import com.denizenscript.denizencore.scripts.containers.ScriptContainer;
import com.denizenscript.denizencore.scripts.queues.ScriptQueue;
import com.denizenscript.denizencore.tags.ParseableTag;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.tags.TagManager;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.Deprecations;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ScriptEntry
implements Cloneable,
Debuggable,
Iterable<Argument> {
    public ScriptEntryData entryData;
    public ScriptQueue queue = null;
    public ScriptEntryInternal internal;
    public TagContext context;
    public Boolean shouldDebugBool = null;
    private Map<String, Object> objects = new HashMap<String, Object>(8);
    public static final Argument NULL_ARGUMENT = new Argument("null_trick", "null_trick");
    public static final InternalArgument NULL_INTERNAL_ARGUMENT = new InternalArgument();
    private ScriptEntry owner = null;
    private Object data;
    public boolean forceInstant = false;
    public boolean isFinished = false;

    public ArgumentIterator iterator() {
        this.internal.argumentIterator.index = 0;
        this.internal.argumentIterator.entry = this;
        return this.internal.argumentIterator;
    }

    public final Argument argAtIndex(InternalArgument[] argSet, int index) {
        InternalArgument internalArg = argSet[index];
        Argument arg = internalArg.aHArg;
        arg.scriptEntry = this;
        if (internalArg.shouldProcess) {
            TagManager.fillArgumentObjects(internalArg, arg, this.context);
            if (internalArg.hadColon && arg.prefix == null && arg.object instanceof ElementTag && ((ElementTag)arg.object).isRawInput) {
                arg.fillStr(arg.object.toString());
                if (arg.prefix != null && !this.internal.actualCommand.allowedDynamicPrefixes) {
                    arg.prefixWasDynamic = true;
                }
            }
            arg.canBeElement = arg.object instanceof ElementTag;
        }
        return arg;
    }

    public final boolean argAsBoolean(String argName) {
        if (this.internal.raw_input_args.contains(argName)) {
            return true;
        }
        Integer index = this.internal.argPrefixMap.get(argName);
        if (index == null) {
            return false;
        }
        Argument arg = this.argAtIndex(this.internal.all_arguments, index);
        return arg.asElement().asBoolean();
    }

    public final <T extends ObjectTag> List<T> argForPrefixList(String prefix, Class<T> clazz, boolean throwError) {
        Argument arg = this.argForPrefix(prefix);
        if (arg == null) {
            return null;
        }
        if (arg.matchesArgumentList(clazz)) {
            return arg.asType(ListTag.class).filter(clazz, this);
        }
        if (throwError) {
            throw new InvalidArgumentsRuntimeException("Invalid input to '" + prefix + "': '" + arg.getValue() + "': not a valid " + clazz.getName());
        }
        return null;
    }

    public <T extends ObjectTag> T requiredArgForPrefix(String prefix, Class<T> clazz) {
        T result = this.argForPrefix(prefix, clazz, true);
        if (result == null) {
            throw new InvalidArgumentsRuntimeException("Must specify input to '" + prefix + "' argument. Did you forget an argument? Check meta docs!");
        }
        return result;
    }

    public final <T extends ObjectTag> T argForPrefix(String prefix, Class<T> clazz, boolean throwError) {
        Argument arg = this.argForPrefix(prefix);
        if (arg == null) {
            return null;
        }
        if (arg.matchesArgumentType(clazz)) {
            return arg.asType(clazz);
        }
        if (throwError) {
            throw new InvalidArgumentsRuntimeException("Invalid input to '" + prefix + "': '" + arg.getValue() + "': not a valid " + clazz.getName());
        }
        return null;
    }

    public final Argument argForPrefix(String prefix) {
        Integer index = this.internal.argPrefixMap.get(prefix);
        if (index == null) {
            return null;
        }
        return this.argAtIndex(this.internal.all_arguments, index);
    }

    public ElementTag requiredArgForPrefixAsElement(String prefix) {
        ElementTag result = this.argForPrefixAsElement(prefix, null);
        if (result == null) {
            throw new InvalidArgumentsRuntimeException("Must specify input to '" + prefix + "' argument. Did you forget an argument? Check meta docs!");
        }
        return result;
    }

    public final ElementTag argForPrefixAsElement(String prefix, String defaultValue) {
        ElementTag result;
        Argument arg = this.argForPrefix(prefix);
        if (arg == null) {
            if (defaultValue == null) {
                return null;
            }
            result = new ElementTag(defaultValue);
        } else {
            result = arg.asElement();
        }
        result.setPrefix(prefix);
        return result;
    }

    public List<BracedCommand.BracedData> getBracedSet() {
        return this.internal.bracedSet;
    }

    public TagContext getContext() {
        return this.context;
    }

    public void updateContext() {
        this.context = DenizenCore.implementation.getTagContext(this);
    }

    public void setBracedSet(List<BracedCommand.BracedData> set) {
        this.internal.bracedSet = set;
    }

    public ScriptEntry clone() {
        try {
            ScriptEntry se = (ScriptEntry)super.clone();
            se.objects = new HashMap<String, Object>(8);
            se.entryData = this.entryData.clone();
            se.entryData.scriptEntry = se;
            se.updateContext();
            return se;
        }
        catch (CloneNotSupportedException ex) {
            throw new RuntimeException(ex);
        }
    }

    public List<Object> getInsideList() {
        if (this.internal.yamlSubcontent instanceof List) {
            return (List)this.internal.yamlSubcontent;
        }
        return null;
    }

    public ScriptEntry(String command, String[] arguments, ScriptContainer script) {
        this(command, arguments, script, null, 0);
    }

    public void crunchInto(InternalArgument argVal, String arg, TagContext refContext) {
        argVal.value = TagManager.parseTextToTag(arg, refContext);
        if (argVal.value.hasTag) {
            this.internal.hasTags = true;
        }
        argVal.aHArg = new Argument(argVal.prefix == null ? null : argVal.prefix.aHArg.getRawValue(), arg);
        if (argVal.value.rawObject != null) {
            argVal.aHArg.object = argVal.value.rawObject;
            argVal.aHArg.unsetValue();
        }
    }

    public ScriptEntry(String command, String[] arguments, ScriptContainer script, Object insides, int lineNum) {
        if (command == null) {
            throw new RuntimeException("Command name cannot be null!");
        }
        this.internal = new ScriptEntryInternal();
        this.internal.lineNumber = lineNum;
        this.entryData = DenizenCore.implementation.getEmptyScriptEntryData();
        this.internal.command = command.toUpperCase();
        this.internal.yamlSubcontent = insides;
        this.internal.argPrefixMap = new HashMap();
        if (script != null) {
            this.internal.script = script.getAsScriptArg();
        }
        this.updateContext();
        if (command.length() > 0) {
            if (command.charAt(0) == '^') {
                this.internal.instant = true;
                this.internal.command = command.substring(1);
            } else if (command.charAt(0) == '~') {
                this.internal.command = command.substring(1);
                this.internal.actualCommand = DenizenCore.commandRegistry.get(this.internal.command);
                if (this.internal.actualCommand instanceof Holdable) {
                    this.internal.waitfor = true;
                } else if (this.internal.actualCommand != null) {
                    Debug.echoError(this, "The command '" + this.internal.command + "' cannot be waited for!");
                }
            }
            this.internal.actualCommand = DenizenCore.commandRegistry.get(this.internal.command);
            if (this.internal.actualCommand != null && this.internal.actualCommand.forceHold) {
                this.internal.waitfor = true;
            }
            if (this.internal.actualCommand == null && !AbstractCommand.noErrorCommandNames.contains(CoreUtilities.toLowerCase(this.internal.command))) {
                Debug.echoError(this, "Unknown command '" + this.internal.command + "'.");
            }
        } else {
            this.internal.actualCommand = null;
        }
        boolean hasBraces = false;
        if (arguments != null) {
            this.internal.pre_tagged_args = new ArrayList<String>(arguments.length);
            this.internal.preprocArgs = new ArrayList<Argument>(arguments.length);
            int nested_depth = 0;
            for (String arg : arguments) {
                Argument argObj;
                if (arg.lastIndexOf(37) > arg.indexOf(37)) {
                    Deprecations.ancientDefs.warn(this);
                }
                if (arg.lastIndexOf(62) > arg.indexOf(60) && arg.contains("<^")) {
                    Deprecations.instantTags.warn(this);
                }
                if (arg.equals("{")) {
                    if (!hasBraces) {
                        if (this.getScript() != null) {
                            Deprecations.oldBraceSyntax.warn(this);
                        }
                        hasBraces = true;
                    }
                    ++nested_depth;
                    this.internal.pre_tagged_args.add(arg);
                    continue;
                }
                if (arg.equals("}")) {
                    --nested_depth;
                    this.internal.pre_tagged_args.add(arg);
                    continue;
                }
                if (nested_depth > 0) {
                    this.internal.pre_tagged_args.add(arg);
                    continue;
                }
                String parg = arg;
                String after = null;
                if (parg.endsWith("{")) {
                    after = "{";
                    parg = parg.substring(0, parg.length() - 1);
                    Debug.echoError(this, "Command '" + command + "' in script '" + (script == null ? "(None)" : script.getName()) + "' has typo: brace written without space... like 'arg{' when it should be 'arg {'.");
                }
                if ((argObj = new Argument(arg)).hasPrefix()) {
                    if (argObj.matchesPrefix("save") || argObj.matchesPrefix("if") || DenizenCore.implementation.needsHandleArgPrefix(argObj.prefix)) {
                        this.internal.preprocArgs.add(argObj);
                    } else {
                        this.internal.pre_tagged_args.add(arg);
                    }
                } else {
                    this.internal.pre_tagged_args.add(parg);
                }
                if (after == null) continue;
                this.internal.pre_tagged_args.add(after);
                if (!after.equals("{")) continue;
                ++nested_depth;
                this.internal.pre_tagged_args.add(arg);
            }
            nested_depth = 0;
            TagContext refContext = DenizenCore.implementation.getTagContext(this);
            ArrayList<InternalArgument> allArgs = new ArrayList<InternalArgument>(this.internal.pre_tagged_args.size());
            this.internal.raw_input_args = new HashSet();
            for (int i = 0; i < this.internal.pre_tagged_args.size(); ++i) {
                String altPrefix;
                int first_not_prefix;
                InternalArgument brace;
                String arg;
                arg = this.internal.pre_tagged_args.get(i);
                if (arg.equals("{")) {
                    brace = new InternalArgument();
                    brace.fullOriginalRawValue = "{";
                    brace.aHArg = new Argument("", "{");
                    allArgs.add(brace);
                    ++nested_depth;
                    continue;
                }
                if (arg.equals("}")) {
                    brace = new InternalArgument();
                    brace.fullOriginalRawValue = "}";
                    brace.aHArg = new Argument("", "}");
                    allArgs.add(brace);
                    --nested_depth;
                    continue;
                }
                allArgs.add(NULL_INTERNAL_ARGUMENT);
                if (nested_depth > 0) continue;
                InternalArgument argVal = new InternalArgument();
                argVal.fullOriginalRawValue = arg;
                allArgs.set(i, argVal);
                int first_colon = arg.indexOf(58);
                argVal.hadColon = first_colon > 0;
                int n = first_not_prefix = this.internal.actualCommand != null && this.internal.actualCommand.anyPrefixSymbolAllowed ? arg.length() : Argument.prefixCharsAllowed.indexOfFirstNonMatch(arg);
                if (first_colon > 0 && first_not_prefix >= first_colon) {
                    argVal.prefix = new InternalArgument();
                    argVal.prefix.fullOriginalRawValue = arg.substring(0, first_colon);
                    this.crunchInto(argVal.prefix, argVal.prefix.fullOriginalRawValue, refContext);
                    arg = arg.substring(first_colon + 1);
                }
                this.crunchInto(argVal, arg, refContext);
                if ((argVal.value.hasTag || argVal.prefix != null) && (this.internal.actualCommand == null || this.internal.actualCommand.shouldPreParse())) {
                    argVal.shouldProcess = true;
                }
                if (argVal.value.rawObject != null) {
                    this.internal.raw_input_args.add(CoreUtilities.toLowerCase(argVal.value.rawObject.toString()));
                }
                if (argVal.prefix == null || argVal.prefix.value.rawObject == null) continue;
                String prefix = CoreUtilities.toLowerCase(argVal.prefix.value.rawObject.toString());
                if (this.internal.actualCommand != null && (altPrefix = this.internal.actualCommand.prefixRemapper.get(prefix)) != null) {
                    prefix = altPrefix;
                }
                this.internal.argPrefixMap.put(prefix, i);
            }
            this.internal.all_arguments = allArgs.toArray(new InternalArgument[0]);
            ArrayList<InternalArgument> argsToUse = new ArrayList<InternalArgument>(this.internal.all_arguments.length);
            for (InternalArgument arg : this.internal.all_arguments) {
                if (!this.shouldUseArg(arg)) continue;
                argsToUse.add(arg);
            }
            this.internal.arguments_to_use = argsToUse.toArray(new InternalArgument[0]);
        } else {
            this.internal.preprocArgs = new ArrayList<Argument>();
            this.internal.pre_tagged_args = new ArrayList<String>();
            this.internal.all_arguments = new InternalArgument[0];
            this.internal.arguments_to_use = new InternalArgument[0];
            this.internal.raw_input_args = new HashSet();
        }
        if (this.internal.actualCommand != null) {
            int argCount = this.getOriginalArguments().size();
            if (argCount < this.internal.actualCommand.minimumArguments || !hasBraces && argCount > this.internal.actualCommand.maximumArguments) {
                this.internal.brokenArgs = true;
                this.internal.actualCommand = CommandRegistry.debugInvalidCommand;
            }
            if (this.internal.actualCommand instanceof BracedCommand) {
                BracedCommand.getBracedCommands(this);
            }
        } else {
            this.internal.actualCommand = CommandRegistry.debugInvalidCommand;
        }
        this.internal.argumentIterator = new ArgumentIterator(this);
    }

    public boolean shouldUseArg(InternalArgument arg) {
        if (this.internal.actualCommand == null) {
            return true;
        }
        if (arg.value == null) {
            return true;
        }
        if (arg.prefix != null) {
            return arg.prefix.value.rawObject == null || !this.internal.actualCommand.prefixesHandled.contains(CoreUtilities.toLowerCase(arg.prefix.value.rawObject.toString()));
        }
        if (arg.value.rawObject == null) {
            return true;
        }
        return !this.internal.actualCommand.rawValuesHandled.contains(CoreUtilities.toLowerCase(arg.value.rawObject.toString()));
    }

    public ScriptEntry addObject(String key, Object object) {
        if (object == null) {
            return this;
        }
        if (object instanceof ObjectTag) {
            ((ObjectTag)object).setPrefix(key);
        }
        this.objects.put(key, object);
        return this;
    }

    public ScriptEntry defaultObject(String key, Object ... objects) throws InvalidArgumentsException {
        if (!this.objects.containsKey(key)) {
            for (Object obj : objects) {
                if (obj == null) continue;
                this.addObject(key, obj);
                break;
            }
        }
        return this;
    }

    public List<String> getOriginalArguments() {
        return this.internal.pre_tagged_args;
    }

    public String getCommandName() {
        return this.internal.command;
    }

    public AbstractCommand getCommand() {
        return this.internal.actualCommand;
    }

    public void setOwner(ScriptEntry owner) {
        this.owner = owner;
    }

    public ScriptEntry getOwner() {
        return this.owner;
    }

    public Object getData() {
        return this.data;
    }

    public void setData(Object result) {
        this.data = result;
    }

    public void copyFrom(ScriptEntry entry) {
        this.entryData = entry.entryData.clone();
        this.setSendingQueue(entry.getResidingQueue());
        this.updateContext();
    }

    public Map<String, Object> getObjects() {
        return this.objects;
    }

    public Object getObject(String key) {
        try {
            return this.objects.get(key);
        }
        catch (Exception ex) {
            if (Debug.verbose) {
                Debug.echoError(ex);
            }
            return null;
        }
    }

    public <T> T getObjectTag(String key) {
        try {
            Object gotten = this.objects.get(key);
            if (gotten == null) {
                return null;
            }
            if (gotten instanceof Enum) {
                return (T)new ElementTag(((Enum)gotten).name());
            }
            return (T)gotten;
        }
        catch (Exception ex) {
            if (Debug.verbose) {
                Debug.echoError(ex);
            }
            return null;
        }
    }

    public ElementTag getElement(String key) {
        try {
            Object gotten = this.objects.get(key);
            if (gotten == null) {
                return null;
            }
            return (ElementTag)gotten;
        }
        catch (Exception ex) {
            if (Debug.verbose) {
                Debug.echoError(ex);
            }
            return null;
        }
    }

    public boolean hasObject(String key) {
        return this.objects.containsKey(key);
    }

    public ScriptTag getScript() {
        return this.internal.script;
    }

    public ScriptEntry setScript(String scriptName) {
        this.internal.script = ScriptTag.valueOf(scriptName, CoreUtilities.basicContext);
        return this;
    }

    public ScriptQueue getResidingQueue() {
        return this.queue;
    }

    public void setSendingQueue(ScriptQueue scriptQueue) {
        this.queue = scriptQueue;
    }

    public boolean isInstant() {
        return this.internal.instant || this.forceInstant;
    }

    public ScriptEntry setInstant(boolean instant) {
        this.forceInstant = instant;
        return this;
    }

    public boolean shouldWaitFor() {
        return this.internal.waitfor && !this.isFinished;
    }

    public ScriptEntry setFinished(boolean finished) {
        this.isFinished = finished;
        return this;
    }

    public boolean dbCallShouldDebug() {
        return DenizenCore.implementation.shouldDebug(this);
    }

    @Override
    public boolean shouldDebug() {
        if (this.shouldDebugBool != null) {
            return this.shouldDebugBool;
        }
        if (this.internal.script == null || this.internal.script.getContainer() == null) {
            this.shouldDebugBool = true;
            return true;
        }
        this.shouldDebugBool = this.internal.script.getContainer().shouldDebug();
        return this.shouldDebugBool;
    }

    private static String stringifyArg(String arg) {
        if (CoreUtilities.contains(arg = arg.replace("\"", "<&dq>"), ' ')) {
            return '\"' + arg + '\"';
        }
        return arg;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (String str : this.getOriginalArguments()) {
            sb.append(" ").append(ScriptEntry.stringifyArg(str));
        }
        for (Argument arg : this.internal.preprocArgs) {
            sb.append(" ").append(ScriptEntry.stringifyArg(arg.toString()));
        }
        return this.internal.command + sb.toString();
    }

    static {
        ScriptEntry.NULL_INTERNAL_ARGUMENT.aHArg = NULL_ARGUMENT;
        ScriptEntry.NULL_INTERNAL_ARGUMENT.value = TagManager.DEFAULT_PARSEABLE_EMPTY;
        ScriptEntry.NULL_INTERNAL_ARGUMENT.fullOriginalRawValue = "";
    }

    public static class ScriptEntryInternal {
        public String command = null;
        public AbstractCommand actualCommand = null;
        public List<String> pre_tagged_args = null;
        public List<BracedCommand.BracedData> bracedSet = null;
        public InternalArgument[] all_arguments = null;
        public InternalArgument[] arguments_to_use = null;
        public HashSet<String> raw_input_args = null;
        public ScriptTag script = null;
        public Object yamlSubcontent = null;
        public boolean instant = false;
        public boolean waitfor = false;
        public boolean hasTags = false;
        public List<Argument> preprocArgs = null;
        public Object specialProcessedData = null;
        public String originalLine = null;
        public int lineNumber;
        public boolean brokenArgs = false;
        public HashMap<String, Integer> argPrefixMap = null;
        public ArgumentIterator argumentIterator = null;
    }

    public static class ArgumentIterator
    implements Iterator<Argument> {
        public ScriptEntry entry;
        public int index = 0;

        public ArgumentIterator(ScriptEntry entry) {
            this.entry = entry;
        }

        @Override
        public boolean hasNext() {
            return this.index < this.entry.internal.arguments_to_use.length;
        }

        @Override
        public Argument next() {
            return this.entry.argAtIndex(this.entry.internal.arguments_to_use, this.index++);
        }
    }

    public static class InternalArgument {
        public InternalArgument prefix = null;
        public ParseableTag value = null;
        public Argument aHArg = null;
        public boolean shouldProcess = false;
        public boolean hadColon = false;
        public String fullOriginalRawValue = null;
    }
}

