/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.v1_17;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.abstracts.BiomeNMS;
import com.denizenscript.denizen.nms.abstracts.BlockLight;
import com.denizenscript.denizen.nms.abstracts.ProfileEditor;
import com.denizenscript.denizen.nms.abstracts.Sidebar;
import com.denizenscript.denizen.nms.util.PlayerProfile;
import com.denizenscript.denizen.nms.util.jnbt.CompoundTag;
import com.denizenscript.denizen.nms.util.jnbt.Tag;
import com.denizenscript.denizen.nms.v1_17.helpers.AdvancementHelperImpl;
import com.denizenscript.denizen.nms.v1_17.helpers.AnimationHelperImpl;
import com.denizenscript.denizen.nms.v1_17.helpers.BlockHelperImpl;
import com.denizenscript.denizen.nms.v1_17.helpers.ChunkHelperImpl;
import com.denizenscript.denizen.nms.v1_17.helpers.CustomEntityHelperImpl;
import com.denizenscript.denizen.nms.v1_17.helpers.EnchantmentHelperImpl;
import com.denizenscript.denizen.nms.v1_17.helpers.EntityHelperImpl;
import com.denizenscript.denizen.nms.v1_17.helpers.FishingHelperImpl;
import com.denizenscript.denizen.nms.v1_17.helpers.ItemHelperImpl;
import com.denizenscript.denizen.nms.v1_17.helpers.PacketHelperImpl;
import com.denizenscript.denizen.nms.v1_17.helpers.ParticleHelperImpl;
import com.denizenscript.denizen.nms.v1_17.helpers.PlayerHelperImpl;
import com.denizenscript.denizen.nms.v1_17.helpers.SoundHelperImpl;
import com.denizenscript.denizen.nms.v1_17.helpers.WorldHelperImpl;
import com.denizenscript.denizen.nms.v1_17.impl.BiomeNMSImpl;
import com.denizenscript.denizen.nms.v1_17.impl.ProfileEditorImpl;
import com.denizenscript.denizen.nms.v1_17.impl.SidebarImpl;
import com.denizenscript.denizen.nms.v1_17.impl.blocks.BlockLightImpl;
import com.denizenscript.denizen.nms.v1_17.impl.jnbt.CompoundTagImpl;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.utilities.FormattedTextHelper;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.ReflectionHelper;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.google.common.collect.Iterables;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.hover.content.Content;
import net.md_5.bungee.api.chat.hover.content.Entity;
import net.md_5.bungee.api.chat.hover.content.Item;
import net.md_5.bungee.api.chat.hover.content.Text;
import net.md_5.bungee.chat.ComponentSerializer;
import net.minecraft.core.IRegistry;
import net.minecraft.nbt.MojangsonParser;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.IInventory;
import net.minecraft.world.INamableTileEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.biome.BiomeBase;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_17_R1.CraftServer;
import org.bukkit.craftbukkit.v1_17_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_17_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_17_R1.inventory.CraftInventory;
import org.bukkit.craftbukkit.v1_17_R1.inventory.CraftInventoryCustom;
import org.bukkit.craftbukkit.v1_17_R1.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_17_R1.persistence.CraftPersistentDataContainer;
import org.bukkit.craftbukkit.v1_17_R1.util.CraftChatMessage;
import org.bukkit.craftbukkit.v1_17_R1.util.CraftMagicNumbers;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.persistence.PersistentDataContainer;
import org.spigotmc.AsyncCatcher;

public class Handler
extends NMSHandler {
    private final ProfileEditor profileEditor = new ProfileEditorImpl();
    private boolean wasAsyncCatcherEnabled;
    public static final Class MINECRAFT_INVENTORY;
    public static final Field INVENTORY_TITLE;
    public static final Field ENTITY_BUKKITYENTITY;

    public Handler() {
        advancementHelper = new AdvancementHelperImpl();
        animationHelper = new AnimationHelperImpl();
        blockHelper = new BlockHelperImpl();
        chunkHelper = new ChunkHelperImpl();
        customEntityHelper = new CustomEntityHelperImpl();
        entityHelper = new EntityHelperImpl();
        fishingHelper = new FishingHelperImpl();
        itemHelper = new ItemHelperImpl();
        soundHelper = new SoundHelperImpl();
        packetHelper = new PacketHelperImpl();
        particleHelper = new ParticleHelperImpl();
        playerHelper = new PlayerHelperImpl();
        worldHelper = new WorldHelperImpl();
        enchantmentHelper = new EnchantmentHelperImpl();
    }

    @Override
    public void disableAsyncCatcher() {
        this.wasAsyncCatcherEnabled = AsyncCatcher.enabled;
        AsyncCatcher.enabled = false;
    }

    @Override
    public void undisableAsyncCatcher() {
        AsyncCatcher.enabled = this.wasAsyncCatcherEnabled;
    }

    @Override
    public boolean isCorrectMappingsCode() {
        return ((CraftMagicNumbers)CraftMagicNumbers.INSTANCE).getMappingsVersion().equals("f0e3dfc7390de285a4693518dd5bd126");
    }

    @Override
    public double[] getRecentTps() {
        return ((CraftServer)Bukkit.getServer()).getServer().recentTps;
    }

    @Override
    public CompoundTag createCompoundTag(Map<String, Tag> value) {
        return new CompoundTagImpl(value);
    }

    @Override
    public Sidebar createSidebar(Player player) {
        return new SidebarImpl(player);
    }

    @Override
    public BlockLight createBlockLight(Location location, int lightLevel, long ticks) {
        return BlockLightImpl.createLight(location, lightLevel, ticks);
    }

    @Override
    public PlayerProfile fillPlayerProfile(PlayerProfile playerProfile) {
        block12: {
            try {
                if (playerProfile != null) {
                    GameProfile gameProfile = new GameProfile(playerProfile.getUniqueId(), playerProfile.getName());
                    gameProfile.getProperties().get((Object)"textures").clear();
                    if (playerProfile.getTextureSignature() != null) {
                        gameProfile.getProperties().put((Object)"textures", (Object)new Property("textures", playerProfile.getTexture(), playerProfile.getTextureSignature()));
                    } else {
                        gameProfile.getProperties().put((Object)"textures", (Object)new Property("textures", playerProfile.getTexture()));
                    }
                    DedicatedServer minecraftServer = ((CraftServer)Bukkit.getServer()).getServer();
                    GameProfile gameProfile1 = null;
                    if (gameProfile.getId() != null) {
                        gameProfile1 = minecraftServer.getUserCache().getProfile(gameProfile.getId()).orElse(null);
                    }
                    if (gameProfile1 == null && gameProfile.getName() != null) {
                        gameProfile1 = minecraftServer.getUserCache().getProfile(gameProfile.getName()).orElse(null);
                    }
                    if (gameProfile1 == null) {
                        gameProfile1 = gameProfile;
                    }
                    if (playerProfile.hasTexture()) {
                        gameProfile1.getProperties().get((Object)"textures").clear();
                        if (playerProfile.getTextureSignature() != null) {
                            gameProfile1.getProperties().put((Object)"textures", (Object)new Property("textures", playerProfile.getTexture(), playerProfile.getTextureSignature()));
                        } else {
                            gameProfile1.getProperties().put((Object)"textures", (Object)new Property("textures", playerProfile.getTexture()));
                        }
                    }
                    if (Iterables.getFirst((Iterable)gameProfile1.getProperties().get((Object)"textures"), null) == null) {
                        gameProfile1 = minecraftServer.getMinecraftSessionService().fillProfileProperties(gameProfile1, true);
                    }
                    Property property = (Property)Iterables.getFirst((Iterable)gameProfile1.getProperties().get((Object)"textures"), null);
                    return new PlayerProfile(gameProfile1.getName(), gameProfile1.getId(), property != null ? property.getValue() : null, property != null ? property.getSignature() : null);
                }
            }
            catch (Exception e2) {
                if (!Debug.verbose) break block12;
                Debug.echoError(e2);
            }
        }
        return null;
    }

    @Override
    public int getPort() {
        return ((CraftServer)Bukkit.getServer()).getServer().getPort();
    }

    @Override
    public String getTitle(Inventory inventory) {
        IInventory nms = ((CraftInventory)inventory).getInventory();
        if (nms instanceof INamableTileEntity) {
            return CraftChatMessage.fromComponent((IChatBaseComponent)((INamableTileEntity)nms).getScoreboardDisplayName());
        }
        if (MINECRAFT_INVENTORY.isInstance(nms)) {
            try {
                return (String)INVENTORY_TITLE.get(nms);
            }
            catch (IllegalAccessException e2) {
                Debug.echoError(e2);
            }
        }
        return "Chest";
    }

    @Override
    public PlayerProfile getPlayerProfile(Player player) {
        GameProfile gameProfile = ((CraftPlayer)player).getProfile();
        Property property = (Property)Iterables.getFirst((Iterable)gameProfile.getProperties().get((Object)"textures"), null);
        return new PlayerProfile(gameProfile.getName(), gameProfile.getId(), property != null ? property.getValue() : null, property != null ? property.getSignature() : null);
    }

    @Override
    public ProfileEditor getProfileEditor() {
        return this.profileEditor;
    }

    @Override
    public List<BiomeNMS> getBiomes(World world) {
        WorldServer level = ((CraftWorld)world).getHandle();
        ArrayList<BiomeNMS> output = new ArrayList<BiomeNMS>();
        for (Map.Entry pair : level.t().d(IRegistry.aO).d()) {
            output.add(new BiomeNMSImpl(level, ((ResourceKey)pair.getKey()).a().toString()));
        }
        return output;
    }

    @Override
    public BiomeNMS getBiomeNMS(World world, String name) {
        BiomeNMSImpl impl = new BiomeNMSImpl(((CraftWorld)world).getHandle(), name);
        if (impl.biomeBase == null) {
            return null;
        }
        return impl;
    }

    @Override
    public BiomeNMS getBiomeAt(Block block) {
        WorldServer level = ((CraftWorld)block.getWorld()).getHandle();
        BiomeBase biome = level.getBiome(block.getX() >> 2, block.getY() >> 2, block.getZ() >> 2);
        MinecraftKey key = level.t().d(IRegistry.aO).getKey((Object)biome);
        String keyText = key.getNamespace().equals("minecraft") ? key.getKey() : key.toString();
        return new BiomeNMSImpl(level, keyText);
    }

    @Override
    public String stringForHover(HoverEvent hover) {
        if (hover.getContents().isEmpty()) {
            return "";
        }
        Content contentObject = (Content)hover.getContents().get(0);
        if (contentObject instanceof Text) {
            Object value = ((Text)contentObject).getValue();
            if (value instanceof BaseComponent[]) {
                return FormattedTextHelper.stringify((BaseComponent[])value, ChatColor.WHITE);
            }
            return value.toString();
        }
        if (contentObject instanceof Item) {
            Item item = (Item)contentObject;
            try {
                NBTTagCompound tag = new NBTTagCompound();
                tag.setString("id", item.getId());
                tag.setByte("Count", (byte)item.getCount());
                if (item.getTag() != null && item.getTag().getNbt() != null) {
                    tag.set("tag", (NBTBase)MojangsonParser.parse((String)item.getTag().getNbt()));
                }
                ItemStack itemStack = ItemStack.a((NBTTagCompound)tag);
                return new ItemTag(CraftItemStack.asBukkitCopy((ItemStack)itemStack)).identify();
            }
            catch (Throwable ex) {
                Debug.echoError(ex);
                return null;
            }
        }
        if (contentObject instanceof Entity) {
            Entity entity = (Entity)contentObject;
            return "e@" + entity.getId();
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public ArrayList<String> containerListFlags(PersistentDataContainer container, String prefix) {
        prefix = "denizen:" + prefix;
        ArrayList<String> output = new ArrayList<String>();
        for (String key : ((CraftPersistentDataContainer)container).getRaw().keySet()) {
            if (!key.startsWith(prefix)) continue;
            output.add(key.substring(prefix.length()));
        }
        return output;
    }

    @Override
    public boolean containerHas(PersistentDataContainer container, String key) {
        return ((CraftPersistentDataContainer)container).getRaw().containsKey(key);
    }

    @Override
    public String containerGetString(PersistentDataContainer container, String key) {
        NBTBase base = (NBTBase)((CraftPersistentDataContainer)container).getRaw().get(key);
        if (base instanceof NBTTagString) {
            return base.asString();
        }
        if (base instanceof NBTTagByteArray) {
            return new String(((NBTTagByteArray)base).getBytes(), StandardCharsets.UTF_8);
        }
        return null;
    }

    public static BaseComponent[] componentToSpigot(IChatBaseComponent nms) {
        String json = IChatBaseComponent.ChatSerializer.a((IChatBaseComponent)nms);
        return ComponentSerializer.parse((String)json);
    }

    public static IChatMutableComponent componentToNMS(BaseComponent[] spigot) {
        String json = ComponentSerializer.toString((BaseComponent[])spigot);
        return IChatBaseComponent.ChatSerializer.a((String)json);
    }

    static {
        ENTITY_BUKKITYENTITY = ReflectionHelper.getFields(net.minecraft.world.entity.Entity.class).get("bukkitEntity");
        Class<?> minecraftInv = null;
        Field title = null;
        try {
            for (Class<?> clzz : CraftInventoryCustom.class.getDeclaredClasses()) {
                if (!CoreUtilities.toLowerCase(clzz.getName()).contains("minecraftinventory")) continue;
                minecraftInv = clzz;
                title = clzz.getDeclaredField("title");
                title.setAccessible(true);
                break;
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        MINECRAFT_INVENTORY = minecraftInv;
        INVENTORY_TITLE = title;
    }
}

