/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.utilities.debugging;

import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.containers.ScriptContainer;
import com.denizenscript.denizencore.scripts.queues.ScriptQueue;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.utilities.debugging.Debug;

public class Warning {
    public String message;

    public Warning(String message) {
        this.message = message;
    }

    public boolean testShouldWarn() {
        return true;
    }

    public void warn(TagContext context) {
        this.warn(context == null ? null : context.entry);
    }

    public void warn(ScriptEntry entry) {
        if (!this.testShouldWarn()) {
            return;
        }
        Debug.echoError(entry, this.message);
    }

    public void warn() {
        this.warn((ScriptQueue)null);
    }

    public void warn(ScriptQueue queue) {
        this.warn(queue == null ? null : queue.getLastEntryExecuted());
    }

    public void warn(ScriptContainer script) {
        if (!this.testShouldWarn()) {
            return;
        }
        Debug.echoError("[In Script: " + script.getName() + "] " + this.message);
    }
}

