/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.shaded.redis.clients.jedis.util;

import com.denizenscript.shaded.redis.clients.jedis.exceptions.JedisDataException;
import com.denizenscript.shaded.redis.clients.jedis.exceptions.JedisException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;

public final class SafeEncoder {
    private SafeEncoder() {
        throw new InstantiationError("Must not instantiate this class");
    }

    public static byte[][] encodeMany(String ... strs) {
        byte[][] many = new byte[strs.length][];
        for (int i = 0; i < strs.length; ++i) {
            many[i] = SafeEncoder.encode(strs[i]);
        }
        return many;
    }

    public static byte[] encode(String str) {
        try {
            if (str == null) {
                throw new JedisDataException("value sent to redis cannot be null");
            }
            return str.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new JedisException(e);
        }
    }

    public static String encode(byte[] data) {
        try {
            return new String(data, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new JedisException(e);
        }
    }

    public static Object encodeObject(Object dataToEncode) {
        if (dataToEncode instanceof byte[]) {
            return SafeEncoder.encode((byte[])dataToEncode);
        }
        if (dataToEncode instanceof List) {
            List arrayToDecode = (List)dataToEncode;
            ArrayList<Object> returnValueArray = new ArrayList<Object>(arrayToDecode.size());
            for (Object arrayEntry : arrayToDecode) {
                returnValueArray.add(SafeEncoder.encodeObject(arrayEntry));
            }
            return returnValueArray;
        }
        return dataToEncode;
    }
}

