/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.player;

import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizen.utilities.depends.Depends;
import com.denizenscript.denizen.utilities.packets.NetworkInterceptHelper;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import com.denizenscript.denizencore.utilities.debugging.SlowWarning;
import com.denizenscript.denizencore.utilities.debugging.Warning;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.UUID;
import net.citizensnpcs.api.CitizensAPI;
import org.bukkit.entity.Entity;

public class GlowCommand
extends AbstractCommand {
    public static HashMap<Integer, HashSet<UUID>> glowViewers = new HashMap();
    public static Warning GLOW_UNSTABLE_WARN = new SlowWarning("The 'glow' command is unstable, glitchy, and experimental. It is subject to a rewrite in the near future. It is recommended that you avoid it for the time being.");

    public GlowCommand() {
        this.setName("glow");
        this.setSyntax("glow [<entity>|...] (<should glow>)");
        this.setRequiredArguments(1, 2);
        this.isProcedural = false;
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry) {
            if (!scriptEntry.hasObject("entities") && arg.matchesArgumentList(EntityTag.class)) {
                scriptEntry.addObject("entities", arg.asType(ListTag.class).filter(EntityTag.class, scriptEntry));
                continue;
            }
            if (!scriptEntry.hasObject("glowing") && arg.matchesBoolean()) {
                scriptEntry.addObject("glowing", arg.asElement());
                continue;
            }
            arg.reportUnhandled();
        }
        scriptEntry.defaultObject("glowing", new ElementTag("true"));
        if (!Utilities.entryHasPlayer(scriptEntry)) {
            throw new InvalidArgumentsException("Must have a valid player link!");
        }
        if (!scriptEntry.hasObject("entities")) {
            throw new InvalidArgumentsException("Must specify entities to make glow!");
        }
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        GLOW_UNSTABLE_WARN.warn(scriptEntry);
        NetworkInterceptHelper.enable();
        ArrayList entities = (ArrayList)scriptEntry.getObject("entities");
        ElementTag glowing = scriptEntry.getElement("glowing");
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report((Debuggable)scriptEntry, this.getName(), GlowCommand.db("entities", entities), glowing);
        }
        boolean shouldGlow = glowing.asBoolean();
        UUID puuid = Utilities.getEntryPlayer(scriptEntry).getUUID();
        for (EntityTag ent : entities) {
            HashSet players;
            if (Depends.citizens != null && CitizensAPI.getNPCRegistry().isNPC((Entity)ent.getLivingEntity())) {
                CitizensAPI.getNPCRegistry().getNPC((Entity)ent.getLivingEntity()).data().setPersistent("glowing", (Object)shouldGlow);
            }
            if (shouldGlow) {
                players = glowViewers.computeIfAbsent(ent.getLivingEntity().getEntityId(), k -> new HashSet());
                players.add(puuid);
            } else {
                players = glowViewers.get(ent.getLivingEntity().getEntityId());
                if (players != null) {
                    players.remove(puuid);
                    boolean bl = shouldGlow = !players.isEmpty();
                    if (!shouldGlow) {
                        glowViewers.remove(ent.getLivingEntity().getEntityId());
                    }
                }
            }
            ent.getLivingEntity().setGlowing(shouldGlow);
        }
    }
}

