/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.containers.core;

import com.denizenscript.denizen.Denizen;
import com.denizenscript.denizen.events.world.TimeChangeScriptEvent;
import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.objects.WorldTag;
import com.denizenscript.denizen.utilities.ScoreboardHelper;
import com.denizenscript.denizen.utilities.Settings;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizen.utilities.flags.DataPersistenceFlagTracker;
import com.denizenscript.denizencore.utilities.CoreConfiguration;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Chunk;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerLoginEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.world.ChunkLoadEvent;
import org.bukkit.persistence.PersistentDataHolder;
import org.bukkit.plugin.Plugin;
import org.bukkit.scoreboard.Scoreboard;

public class BukkitWorldScriptHelper
implements Listener {
    private final Map<String, Integer> current_time = new HashMap<String, Integer>();

    public BukkitWorldScriptHelper() {
        Denizen.getInstance().getServer().getPluginManager().registerEvents((Listener)this, (Plugin)Denizen.getInstance());
    }

    public void serverStartEvent() {
        long ticks = Settings.worldScriptTimeEventFrequency().getTicks();
        Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)Denizen.getInstance(), this::timeEvent, ticks, ticks);
    }

    public void timeEvent() {
        for (World world : Bukkit.getWorlds()) {
            int hour = (int)(world.getTime() / 1000L);
            if ((hour += 6) >= 24) {
                hour -= 24;
            }
            if (this.current_time.containsKey(world.getName()) && this.current_time.get(world.getName()) == hour) continue;
            this.current_time.put(world.getName(), hour);
            TimeChangeScriptEvent.instance.hour = hour;
            TimeChangeScriptEvent.instance.world = new WorldTag(world);
            TimeChangeScriptEvent.instance.fire();
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerJoins(PlayerJoinEvent event) {
        Scoreboard score;
        if (EntityTag.isNPC((Entity)event.getPlayer())) {
            return;
        }
        String board = ScoreboardHelper.viewerMap.get(event.getPlayer().getUniqueId());
        if (board != null && (score = ScoreboardHelper.getScoreboard(board)) != null) {
            event.getPlayer().setScoreboard(score);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerChat(AsyncPlayerChatEvent event) {
        String message = ChatColor.DARK_GREEN + "CHAT: " + event.getPlayer().getName() + ": " + event.getMessage();
        Bukkit.getScheduler().runTaskLater((Plugin)Denizen.getInstance(), () -> {
            if (Debug.record) {
                Debug.log(message);
            }
        }, 1L);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void playerLogin(PlayerLoginEvent event) {
        if (EntityTag.isNPC((Entity)event.getPlayer())) {
            return;
        }
        PlayerTag.notePlayer((OfflinePlayer)event.getPlayer());
    }

    @EventHandler
    public void playerQuit(PlayerQuitEvent event) {
        NMSHandler.getPacketHelper().removeNoCollideTeam(event.getPlayer(), null);
    }

    @EventHandler
    public void chunkLoadEvent(ChunkLoadEvent event) {
        if (CoreConfiguration.skipAllFlagCleanings) {
            return;
        }
        new DataPersistenceFlagTracker((PersistentDataHolder)event.getChunk()).doTotalClean();
    }

    public static void cleanAllWorldChunkFlags() {
        for (World world : Bukkit.getWorlds()) {
            for (Chunk chunk : world.getLoadedChunks()) {
                new DataPersistenceFlagTracker((PersistentDataHolder)chunk).doTotalClean();
            }
        }
    }
}

