/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.utilities.flags;

import com.denizenscript.denizen.Denizen;
import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.utilities.DataPersistenceHelper;
import com.denizenscript.denizencore.flags.MapTagBasedFlagTracker;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.MapTag;
import com.denizenscript.denizencore.utilities.AsciiMatcher;
import com.denizenscript.denizencore.utilities.CoreConfiguration;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import java.util.Collection;
import org.bukkit.NamespacedKey;
import org.bukkit.persistence.PersistentDataHolder;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class DataPersistenceFlagTracker
extends MapTagBasedFlagTracker {
    public PersistentDataHolder holder;
    public String keyPrefix = "flag_";
    public static AsciiMatcher allowedKeyText = new AsciiMatcher("abcdefghijklmnopqrstuvwxyz0123456789_/.-");
    public static NamespacedKey expireNeededKey = new NamespacedKey((Plugin)Denizen.getInstance(), "expire_flag_check_needed");

    public DataPersistenceFlagTracker(PersistentDataHolder holder) {
        this.holder = holder;
    }

    public DataPersistenceFlagTracker(PersistentDataHolder holder, String keyPrefix) {
        this.holder = holder;
        this.keyPrefix = keyPrefix;
    }

    public static String cleanKeyName(String input) {
        return allowedKeyText.trimToMatches(CoreUtilities.toLowerCase(input));
    }

    @Override
    public MapTag getRootMap(String key) {
        return (MapTag)DataPersistenceHelper.getDenizenKey(this.holder, this.keyPrefix + DataPersistenceFlagTracker.cleanKeyName(key));
    }

    @Override
    public void setRootMap(String key, MapTag map) {
        if (map == null) {
            DataPersistenceHelper.removeDenizenKey(this.holder, this.keyPrefix + DataPersistenceFlagTracker.cleanKeyName(key));
            return;
        }
        if (map.map.containsKey(expirationString) || map.map.get(valueString) instanceof MapTag) {
            this.holder.getPersistentDataContainer().set(expireNeededKey, PersistentDataType.STRING, (Object)"true");
        }
        DataPersistenceHelper.setDenizenKey(this.holder, this.keyPrefix + DataPersistenceFlagTracker.cleanKeyName(key), map);
    }

    @Override
    public Collection<String> listAllFlags() {
        return NMSHandler.instance.containerListFlags(this.holder.getPersistentDataContainer(), this.keyPrefix);
    }

    public void doTotalClean() {
        if (CoreConfiguration.skipAllFlagCleanings) {
            return;
        }
        if (!this.holder.getPersistentDataContainer().has(expireNeededKey, PersistentDataType.STRING)) {
            return;
        }
        boolean containsAnyToCheck = false;
        for (NamespacedKey key : this.holder.getPersistentDataContainer().getKeys()) {
            ObjectTag map;
            if (!key.getNamespace().equals("denizen") || !key.getKey().startsWith("flag_") || !((map = DataPersistenceHelper.getDenizenKey(this.holder, key.getKey())) instanceof MapTag)) continue;
            if (DataPersistenceFlagTracker.isExpired(((MapTag)map).map.get(expirationString))) {
                this.holder.getPersistentDataContainer().remove(key);
                containsAnyToCheck = true;
                continue;
            }
            ObjectTag subValue = ((MapTag)map).map.get(valueString);
            if (!(subValue instanceof MapTag)) continue;
            if (this.doClean((MapTag)subValue)) {
                this.holder.getPersistentDataContainer().set(key, (PersistentDataType)DataPersistenceHelper.PERSISTER_TYPE, (Object)map);
            }
            containsAnyToCheck = true;
        }
        if (!containsAnyToCheck) {
            this.holder.getPersistentDataContainer().remove(expireNeededKey);
        }
    }
}

