/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.player;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.entity.Player;

public class BlockCrackCommand
extends AbstractCommand {
    private static Map<Location, Map<UUID, IntHolder>> progressTracker = new HashMap<Location, Map<UUID, IntHolder>>();
    private static int lastBase;

    public BlockCrackCommand() {
        this.setName("blockcrack");
        this.setSyntax("blockcrack [<location>] [progress:<#>] (stack) (players:<player>|...)");
        this.setRequiredArguments(2, 4);
        this.isProcedural = false;
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry) {
            if (arg.matchesPrefix("players") && arg.matchesArgumentList(PlayerTag.class)) {
                scriptEntry.addObject("players", arg.asType(ListTag.class).filter(PlayerTag.class, scriptEntry));
                continue;
            }
            if (arg.matchesPrefix("progress") && arg.matchesInteger()) {
                scriptEntry.addObject("progress", arg.asElement());
                continue;
            }
            if (arg.matchesArgumentType(LocationTag.class)) {
                scriptEntry.addObject("location", arg.asType(LocationTag.class));
                continue;
            }
            if (arg.matches("stack")) {
                scriptEntry.addObject("stack", new ElementTag(true));
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("progress")) {
            throw new InvalidArgumentsException("Must specify crack animation progress!");
        }
        if (!scriptEntry.hasObject("location")) {
            throw new InvalidArgumentsException("Must specify a valid location!");
        }
        scriptEntry.defaultObject("players", Collections.singletonList(Utilities.getEntryPlayer(scriptEntry))).defaultObject("stack", new ElementTag(false));
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        Location loc;
        List players = (List)scriptEntry.getObject("players");
        ElementTag progress = scriptEntry.getElement("progress");
        LocationTag location = (LocationTag)scriptEntry.getObjectTag("location");
        ElementTag stack = scriptEntry.getElement("stack");
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report((Debuggable)scriptEntry, this.getName(), BlockCrackCommand.db("players", players), progress, location, stack);
        }
        if (!progressTracker.containsKey(loc = location.getBlock().getLocation())) {
            progressTracker.put(loc, new HashMap());
            lastBase += 10;
        }
        Map<UUID, IntHolder> uuidInt = progressTracker.get(loc);
        boolean stackVal = stack.asBoolean();
        for (PlayerTag player : players) {
            int n;
            if (!player.isOnline()) {
                Debug.echoError("Players must be online!");
                continue;
            }
            Player playerEnt = player.getPlayerEntity();
            UUID uuid = playerEnt.getUniqueId();
            if (!uuidInt.containsKey(uuid)) {
                IntHolder newIntHolder = new IntHolder();
                newIntHolder.theInt = lastBase;
                newIntHolder.base = lastBase;
                uuidInt.put(uuid, newIntHolder);
            }
            IntHolder intHolder = uuidInt.get(uuid);
            if (!stackVal && intHolder.theInt > intHolder.base) {
                for (int i = intHolder.base; i <= intHolder.theInt; ++i) {
                    NMSHandler.packetHelper.showBlockCrack(playerEnt, i, loc, -1);
                }
                intHolder.theInt = intHolder.base;
            } else if (stackVal && intHolder.theInt - intHolder.base > 10) continue;
            if (stackVal) {
                int n2 = intHolder.theInt;
                n = n2;
                intHolder.theInt = n2 + 1;
            } else {
                n = intHolder.theInt;
            }
            int id = n;
            NMSHandler.packetHelper.showBlockCrack(player.getPlayerEntity(), id, loc, progress.asInt() - 1);
        }
    }

    private static class IntHolder {
        public int theInt;
        public int base;

        private IntHolder() {
        }
    }
}

