/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.world;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.WorldTag;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import org.bukkit.Location;
import org.bukkit.block.BlockState;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.world.PortalCreateEvent;

public class PortalCreateScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static PortalCreateScriptEvent instance;
    public ElementTag reason;
    public PortalCreateEvent event;

    public PortalCreateScriptEvent() {
        instance = this;
        this.registerCouldMatcher("portal created (because <'reason'>)");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        if (path.eventArgLowerAt(2).equals("because") && !PortalCreateScriptEvent.runGenericCheck(path.eventArgLowerAt(3), this.reason.asString())) {
            return false;
        }
        if (!this.runInCheck(path, ((BlockState)this.event.getBlocks().get(0)).getLocation())) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public String getName() {
        return "PortalCreate";
    }

    @Override
    public ObjectTag getContext(String name) {
        if (name.equals("entity") && this.event.getEntity() != null) {
            return new EntityTag(this.event.getEntity());
        }
        if (name.equals("world")) {
            return new WorldTag(this.event.getWorld());
        }
        if (name.equals("reason")) {
            return this.reason;
        }
        if (name.equals("blocks")) {
            ListTag blocks = new ListTag();
            for (Location location : NMSHandler.blockHelper.getBlocksList(this.event)) {
                blocks.addObject(new LocationTag(location));
            }
            return blocks;
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onPortalCreate(PortalCreateEvent event) {
        this.reason = new ElementTag(event.getReason().name());
        this.event = event;
        this.fire((Event)event);
    }
}

