/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.utilities;

import com.denizenscript.denizencore.utilities.AsciiMatcher;

public class TextWidthHelper {
    public static int[] characterWidthMap = new int[128];
    public static AsciiMatcher formatCharCodeMatcher;

    public static void setWidth(int width, String chars) {
        for (char c : chars.toCharArray()) {
            TextWidthHelper.characterWidthMap[c] = width;
        }
    }

    public static int getWidth(char c) {
        return c > '\u007f' ? 6 : characterWidthMap[c];
    }

    public static int getWidth(String str) {
        return TextWidthHelper.getWidth(false, str);
    }

    public static int getWidth(boolean wasBold, String str) {
        int maxWidth = 0;
        int total = 0;
        boolean bold = wasBold;
        char[] rawChars = str.toCharArray();
        for (int i = 0; i < rawChars.length; ++i) {
            char c = rawChars[i];
            if (c == '\u00a7' && i + 1 < rawChars.length) {
                char c2 = rawChars[i + 1];
                if (c2 == '[') {
                    while (i < rawChars.length && rawChars[i] != ']') {
                        ++i;
                    }
                    continue;
                }
                if (c2 == 'l' || c2 == 'L') {
                    bold = true;
                } else if (!formatCharCodeMatcher.isMatch(c2)) {
                    bold = false;
                }
                ++i;
                continue;
            }
            total += TextWidthHelper.getWidth(c) + (bold ? 2 : 0);
            if (c != '\n') continue;
            if (total > maxWidth) {
                maxWidth = total;
            }
            total = 0;
        }
        return Math.max(total, maxWidth);
    }

    public static boolean isBold(boolean wasBold, String str) {
        boolean bold = wasBold;
        char[] rawChars = str.toCharArray();
        for (int i = 0; i < rawChars.length; ++i) {
            char c = rawChars[i];
            if (c != '\u00a7' || i + 1 >= rawChars.length) continue;
            char c2 = rawChars[i + 1];
            if (c2 == 'l' || c2 == 'L') {
                bold = true;
                continue;
            }
            if (formatCharCodeMatcher.isMatch(c2)) continue;
            bold = false;
        }
        return bold;
    }

    public static String splitLines(String str, int width) {
        if (width < 8) {
            return str;
        }
        StringBuilder output = new StringBuilder(str.length() * 2);
        int lineStart = 0;
        boolean bold = false;
        block0: for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c == '\u00a7') {
                ++i;
                continue;
            }
            if (c == '\n') {
                String lastLine = str.substring(lineStart, i + 1);
                bold = TextWidthHelper.isBold(bold, lastLine);
                output.append(lastLine);
                lineStart = i + 1;
                continue;
            }
            if (TextWidthHelper.getWidth(bold, str.substring(lineStart, i)) <= width) continue;
            for (int x = i - 1; x > lineStart; --x) {
                char xc = str.charAt(x);
                if (xc != ' ') continue;
                String lastLine = str.substring(lineStart, x);
                bold = TextWidthHelper.isBold(bold, lastLine);
                output.append(lastLine).append("\n");
                lineStart = x + 1;
                i = x;
                continue block0;
            }
            String lastLine = str.substring(lineStart, i);
            bold = TextWidthHelper.isBold(bold, lastLine);
            output.append(lastLine).append("\n");
            lineStart = i;
        }
        output.append(str, lineStart, str.length());
        return output.toString();
    }

    static {
        for (int i = 0; i < 128; ++i) {
            TextWidthHelper.characterWidthMap[i] = 6;
        }
        TextWidthHelper.setWidth(2, "!,.:;|i`");
        TextWidthHelper.setWidth(3, "'l");
        TextWidthHelper.setWidth(4, " []tI");
        TextWidthHelper.setWidth(5, "\"()*<>fk{}");
        TextWidthHelper.setWidth(7, "@~");
        formatCharCodeMatcher = new AsciiMatcher("klmnoKLMNO");
    }
}

