/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.utilities.command;

import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.MaterialTag;
import com.denizenscript.denizen.scripts.containers.core.EntityScriptHelper;
import com.denizenscript.denizen.scripts.containers.core.ItemScriptHelper;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.properties.PropertyParser;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.entity.EntityType;

public class TabCompleteHelper {
    public static void tabCompleteItems(AbstractCommand.TabCompletionsBuilder tab) {
        int bracket = tab.arg.indexOf(91);
        if (bracket == -1) {
            for (Material material : Material.values()) {
                if (!material.isItem()) continue;
                tab.add(material.name());
            }
            tab.add(ItemScriptHelper.item_scripts.keySet());
            return;
        }
        String material = tab.arg.substring(0, bracket);
        ItemTag item = ItemTag.valueOf(material, CoreUtilities.noDebugContext);
        TabCompleteHelper.tabCompletePropertiesFor(tab, bracket, item);
    }

    public static void tabCompleteBlockMaterials(AbstractCommand.TabCompletionsBuilder tab) {
        int bracket = tab.arg.indexOf(91);
        if (bracket == -1) {
            for (Material material : Material.values()) {
                if (!material.isBlock()) continue;
                tab.add(material.name());
            }
            return;
        }
        String material = tab.arg.substring(0, bracket);
        MaterialTag mat = MaterialTag.valueOf(material, CoreUtilities.noDebugContext);
        TabCompleteHelper.tabCompletePropertiesFor(tab, bracket, mat);
    }

    public static void tabCompleteEntityTypes(AbstractCommand.TabCompletionsBuilder tab) {
        int bracket = tab.arg.indexOf(91);
        if (bracket == -1) {
            tab.add((Enum<?>[])EntityType.values());
            tab.add(EntityScriptHelper.scripts.keySet());
            return;
        }
        String type = tab.arg.substring(0, bracket);
        EntityTag entity = EntityTag.valueOf(type, CoreUtilities.noDebugContext);
        if (entity == null || entity.isUnique()) {
            return;
        }
        TabCompleteHelper.tabCompletePropertiesFor(tab, bracket, entity);
    }

    public static void tabCompletePropertiesFor(AbstractCommand.TabCompletionsBuilder tab, int bracket, ObjectTag object) {
        String propertyPart;
        if (object == null) {
            return;
        }
        int lastSemicolon = tab.arg.lastIndexOf(59);
        if (lastSemicolon == -1) {
            lastSemicolon = bracket;
        }
        if ((propertyPart = tab.arg.substring(lastSemicolon + 1)).indexOf(61) != -1) {
            return;
        }
        String prefixPart = tab.arg.substring(0, lastSemicolon + 1);
        PropertyParser.ClassPropertiesInfo properties = PropertyParser.propertiesByClass.get(object.getObjectTagClass());
        for (Map.Entry<String, PropertyParser.PropertyGetter> property : properties.propertiesByMechanism.entrySet()) {
            if (!property.getKey().startsWith(propertyPart) || property.getValue().get(object) == null) continue;
            tab.add(prefixPart + property.getKey());
        }
    }
}

