/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.paper.events;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import java.util.Arrays;
import org.bukkit.command.BlockCommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.minecart.CommandMinecart;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.command.UnknownCommandEvent;

public class UnknownCommandScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static UnknownCommandScriptEvent instance;
    public UnknownCommandEvent event;
    public String command;
    public String rawArgs;
    public String sourceType;

    public UnknownCommandScriptEvent() {
        instance = this;
        this.registerCouldMatcher("command unknown");
    }

    public String getName() {
        return "CommandUnknown";
    }

    public boolean applyDetermination(ScriptEvent.ScriptPath path, ObjectTag determinationObj) {
        if (determinationObj instanceof ElementTag) {
            String determination = determinationObj.toString();
            if (CoreUtilities.equalsIgnoreCase((String)determination, (String)"none")) {
                this.event.setMessage(null);
            } else {
                this.event.setMessage(determination);
            }
            return true;
        }
        return super.applyDetermination(path, determinationObj);
    }

    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(this.event.getSender() instanceof Player ? new PlayerTag((Player)this.event.getSender()) : null, null);
    }

    public ObjectTag getContext(String name) {
        if (name.equals("command")) {
            return new ElementTag(this.command);
        }
        if (name.equals("raw_args")) {
            return new ElementTag(this.rawArgs);
        }
        if (name.equals("args")) {
            return new ListTag(Arrays.asList(ArgumentHelper.buildArgs((String)this.rawArgs)));
        }
        if (name.equals("server")) {
            return new ElementTag(this.sourceType.equals("server"));
        }
        if (name.equals("source_type")) {
            return new ElementTag(this.sourceType);
        }
        if (name.equals("command_block_location") && this.sourceType.equals("command_block")) {
            return new LocationTag(((BlockCommandSender)this.event.getSender()).getBlock().getLocation());
        }
        if (name.equals("command_minecart") && this.sourceType.equals("command_minecart")) {
            return new EntityTag((Entity)((CommandMinecart)this.event.getSender()));
        }
        if (name.equals("message")) {
            return new ElementTag(this.event.getMessage());
        }
        return super.getContext(name);
    }

    @EventHandler
    public void unknownCommandEvent(UnknownCommandEvent event) {
        this.event = event;
        String[] splitCommand = event.getCommandLine().split(" ", 2);
        this.command = splitCommand[0];
        String string = this.rawArgs = splitCommand.length > 1 ? splitCommand[1] : "";
        this.sourceType = event.getSender() instanceof Player ? "player" : (event.getSender() instanceof BlockCommandSender ? "command_block" : (event.getSender() instanceof CommandMinecart ? "command_minecart" : "server"));
        this.fire((Event)event);
    }
}

