/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.player;

import com.denizenscript.denizen.Denizen;
import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizen.utilities.inventory.SlotHelper;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerItemBreakEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class PlayerBreaksItemScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static PlayerBreaksItemScriptEvent instance;
    public ItemTag item;
    public PlayerItemBreakEvent event;

    public PlayerBreaksItemScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptEvent.ScriptPath path) {
        if (!path.eventLower.startsWith("player breaks held")) {
            return false;
        }
        return PlayerBreaksItemScriptEvent.couldMatchItem(path.eventArgLowerAt(3));
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        if (!this.item.tryAdvancedMatcher(path.eventArgLowerAt(3))) {
            return false;
        }
        if (!this.runInCheck(path, this.event.getPlayer().getLocation())) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public String getName() {
        return "PlayerItemBreak";
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData((Entity)this.event.getPlayer());
    }

    @Override
    public ObjectTag getContext(String name) {
        if (name.equals("item")) {
            return this.item;
        }
        if (name.equals("slot")) {
            return new ElementTag(SlotHelper.slotForItem(this.event.getPlayer().getInventory(), this.item.getItemStack()) + 1);
        }
        return super.getContext(name);
    }

    @Override
    public void cancellationChanged() {
        if (this.cancelled) {
            final Player player = this.event.getPlayer();
            final ItemStack itemstack = this.event.getBrokenItem();
            itemstack.setAmount(itemstack.getAmount() + 1);
            new BukkitRunnable(){

                public void run() {
                    itemstack.setDurability(itemstack.getType().getMaxDurability());
                    player.updateInventory();
                }
            }.runTaskLater((Plugin)Denizen.getInstance(), 1L);
        }
        super.cancellationChanged();
    }

    @EventHandler
    public void onPlayerItemBreak(PlayerItemBreakEvent event) {
        if (EntityTag.isNPC((Entity)event.getPlayer())) {
            return;
        }
        this.item = new ItemTag(event.getBrokenItem());
        this.event = event;
        this.cancelled = false;
        this.fire((Event)event);
    }
}

