/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.npc;

import com.denizenscript.denizen.objects.NPCTag;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import net.citizensnpcs.trait.LookClose;

public class LookcloseCommand
extends AbstractCommand {
    public LookcloseCommand() {
        this.setName("lookclose");
        this.setSyntax("lookclose (<npc>) (state:<true/false>) (range:<#>) (realistic)");
        this.setRequiredArguments(0, 4);
        this.isProcedural = false;
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry) {
            if (arg.matches("realistic", "realistically")) {
                scriptEntry.addObject("realistic", new ElementTag(true));
                continue;
            }
            if (arg.matchesInteger()) {
                scriptEntry.addObject("range", arg.asElement());
                continue;
            }
            if (arg.matchesBoolean()) {
                scriptEntry.addObject("toggle", arg.asElement());
                continue;
            }
            if (arg.matchesArgumentType(NPCTag.class)) {
                scriptEntry.addObject("npc", arg.asType(NPCTag.class));
                ((BukkitScriptEntryData)scriptEntry.entryData).setNPC(arg.asType(NPCTag.class));
                continue;
            }
            arg.reportUnhandled();
        }
        scriptEntry.defaultObject("npc", Utilities.getEntryNPC(scriptEntry));
        if (!scriptEntry.hasObject("npc")) {
            throw new InvalidArgumentsException("NPC linked was missing or invalid.");
        }
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        ElementTag realistic = scriptEntry.getElement("realistic");
        ElementTag range = scriptEntry.getElement("range");
        ElementTag toggle = scriptEntry.getElement("toggle");
        NPCTag npc = (NPCTag)scriptEntry.getObjectTag("npc");
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report((Debuggable)scriptEntry, this.getName(), npc, realistic, range, toggle);
        }
        LookClose trait = (LookClose)npc.getCitizen().getOrAddTrait(LookClose.class);
        if (toggle != null) {
            trait.lookClose(toggle.asBoolean());
        }
        if (realistic != null && realistic.asBoolean()) {
            trait.setRealisticLooking(true);
        } else {
            trait.setRealisticLooking(false);
        }
        if (range != null) {
            trait.setRange((double)range.asInt());
        }
    }
}

