/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.resps;

import redis.clients.jedis.resps.KeyedZSetElement;
import redis.clients.jedis.util.SafeEncoder;

public class KeyedListElement {
    private final String key;
    private final String element;

    public KeyedListElement(byte[] key, byte[] element) {
        this(SafeEncoder.encode(key), SafeEncoder.encode(element));
    }

    public KeyedListElement(String key, String element) {
        this.key = key;
        this.element = element;
    }

    public String getKey() {
        return this.key;
    }

    public String getElement() {
        return this.element;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof KeyedZSetElement)) {
            return false;
        }
        KeyedListElement other = (KeyedListElement)o;
        return this.key.equals(other.key) && this.element.equals(other.element);
    }

    public int hashCode() {
        return 31 * this.key.hashCode() + this.element.hashCode();
    }

    public String toString() {
        return "KeyedListElement{key=" + this.key + ", element='" + this.element + "} ";
    }
}

