/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.v1_17.impl.entities;

import com.denizenscript.denizen.nms.v1_17.ReflectionMappingsInfo;
import com.denizenscript.denizen.nms.v1_17.impl.entities.CraftItemProjectileImpl;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.ReflectionHelper;
import com.google.common.base.Preconditions;
import java.lang.invoke.MethodHandle;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.projectile.EntityProjectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.World;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import org.bukkit.Location;

public class EntityItemProjectileImpl
extends EntityProjectile {
    public static MethodHandle setBukkitEntityMethod = ReflectionHelper.getFinalSetter(Entity.class, (String)"bukkitEntity");
    public static final DataWatcherObject<ItemStack> ITEM;

    public EntityItemProjectileImpl(World world, Location location, ItemStack item) {
        super(EntityTypes.Q, world);
        try {
            setBukkitEntityMethod.invoke(this, new CraftItemProjectileImpl(((WorldServer)world).getMinecraftServer().server, this));
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
        this.setPositionRaw(location.getX(), location.getY(), location.getZ());
        this.setYawPitch(location.getYaw(), location.getPitch());
        this.setItemStack(item);
    }

    protected void initDatawatcher() {
        this.getDataWatcher().register(ITEM, (Object)ItemStack.b);
    }

    public ItemStack getItemStack() {
        return (ItemStack)this.getDataWatcher().get(ITEM);
    }

    public void setItemStack(ItemStack itemstack) {
        Preconditions.checkArgument((!itemstack.isEmpty() ? 1 : 0) != 0, (Object)"Cannot drop air");
        this.getDataWatcher().set(ITEM, (Object)itemstack);
        this.getDataWatcher().markDirty(ITEM);
    }

    protected void a(MovingObjectPositionBlock movingobjectpositionblock) {
        super.a(movingobjectpositionblock);
        this.a(Entity.RemovalReason.a);
    }

    public void a(DataWatcherObject<?> datawatcherobject) {
        super.a(datawatcherobject);
        if (ITEM.equals(datawatcherobject)) {
            this.getItemStack().a((Entity)this);
        }
    }

    public boolean e(NBTTagCompound nbttagcompound) {
        if (!this.getItemStack().isEmpty()) {
            nbttagcompound.set("Item", (NBTBase)this.getItemStack().save(new NBTTagCompound()));
        }
        super.e(nbttagcompound);
        return true;
    }

    public void load(NBTTagCompound nbttagcompound) {
        NBTTagCompound nbttagcompound1 = nbttagcompound.getCompound("Item");
        this.setItemStack(ItemStack.a((NBTTagCompound)nbttagcompound1));
        if (this.getItemStack().isEmpty()) {
            this.a(Entity.RemovalReason.a);
        }
        super.load(nbttagcompound);
    }

    public CraftItemProjectileImpl getBukkitEntity() {
        return (CraftItemProjectileImpl)super.getBukkitEntity();
    }

    static {
        DataWatcherObject watcher = null;
        try {
            watcher = (DataWatcherObject)ReflectionHelper.getFields(EntityItem.class).get((Object)ReflectionMappingsInfo.ItemEntity_DATA_ITEM).get(null);
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
        ITEM = watcher;
    }
}

