/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.utilities.inventory;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.inventory.CraftingInventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.ShapelessRecipe;

public class RecipeHelper {
    public static int tryRecipeMatch(ItemStack[] matrix, int matrixWidth, ShapeHelper shape, int offsetX, int offsetY) {
        int max = 64;
        for (int shapeX = 0; shapeX < shape.width; ++shapeX) {
            for (int shapeY = 0; shapeY < shape.height; ++shapeY) {
                if (shape.shapeText[shapeY].length() <= shapeX) continue;
                int x = offsetX + shapeX;
                int y = offsetY + shapeY;
                int matrixIndex = x + y * matrixWidth;
                ItemStack matrixItem = matrix[matrixIndex];
                RecipeChoice choices = shape.choiceMap.get(Character.valueOf(shape.shapeText[shapeY].charAt(shapeX)));
                if (choices == null) continue;
                if (matrixItem == null || !choices.test(matrixItem)) {
                    return 0;
                }
                max = Math.min(max, matrixItem.getAmount());
            }
        }
        return max;
    }

    public static int getShapedQuantity(CraftingInventory inventory, ShapeHelper shape) {
        ItemStack[] matrix = inventory.getMatrix();
        int matrixWidth = matrix.length == 9 ? 3 : 2;
        int canMoveX = matrixWidth - shape.width;
        int canMoveY = matrixWidth - shape.height;
        for (int offsetX = 0; offsetX <= canMoveX; ++offsetX) {
            for (int offsetY = 0; offsetY <= canMoveY; ++offsetY) {
                int result = RecipeHelper.tryRecipeMatch(matrix, matrixWidth, shape, offsetX, offsetY);
                if (result <= 0) continue;
                return result;
            }
        }
        return 0;
    }

    public static boolean tryRemoveSingle(List<ItemStack> items, List<RecipeChoice> choices) {
        block0: for (RecipeChoice choice : choices) {
            for (int i = 0; i < items.size(); ++i) {
                ItemStack item = items.get(i);
                if (!choice.test(item)) continue;
                if (item.getAmount() == 1) {
                    items.remove(i);
                    continue block0;
                }
                item.setAmount(item.getAmount() - 1);
                continue block0;
            }
            return false;
        }
        return true;
    }

    public static int getShapelessQuantity(CraftingInventory inventory, ShapelessRecipe recipe) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (ItemStack item : inventory.getMatrix()) {
            if (item == null || item.getType() == Material.AIR) continue;
            items.add(item.clone());
        }
        int amount = 0;
        while (RecipeHelper.tryRemoveSingle(items, recipe.getChoiceList())) {
            ++amount;
        }
        return amount;
    }

    public static int getMaximumOutputQuantity(Recipe recipe, CraftingInventory inventory) {
        if (recipe instanceof ShapedRecipe) {
            return RecipeHelper.getShapedQuantity(inventory, new ShapeHelper((ShapedRecipe)recipe));
        }
        if (recipe instanceof ShapelessRecipe) {
            return RecipeHelper.getShapelessQuantity(inventory, (ShapelessRecipe)recipe);
        }
        return 1;
    }

    public static class ShapeHelper {
        public int width;
        public int height;
        public String[] shapeText;
        public Map<Character, RecipeChoice> choiceMap;

        public ShapeHelper(ShapedRecipe recipe) {
            int len;
            this.choiceMap = recipe.getChoiceMap();
            this.shapeText = recipe.getShape();
            for (len = this.shapeText.length; len > 0 && this.shapeText[len - 1].isEmpty(); --len) {
            }
            while (len > 0 && this.shapeText[0].isEmpty()) {
                this.shapeText = Arrays.copyOfRange(this.shapeText, 1, len);
                --len;
            }
            this.height = len;
            this.width = 0;
            for (int i = 0; i < len; ++i) {
                this.width = Math.max(this.width, this.shapeText[i].length());
            }
            if (this.height <= 0 || this.width <= 0) {
                throw new RuntimeException("ShapedRecipe malformed.");
            }
        }
    }
}

