/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.shaded.redis.clients.jedis.params;

import com.denizenscript.shaded.redis.clients.jedis.Protocol;
import com.denizenscript.shaded.redis.clients.jedis.params.Params;
import com.denizenscript.shaded.redis.clients.jedis.util.SafeEncoder;
import java.util.ArrayList;
import java.util.Collections;

public class SetParams
extends Params {
    private static final String XX = "xx";
    private static final String NX = "nx";
    private static final String PX = "px";
    private static final String EX = "ex";
    private static final String EXAT = "exat";
    private static final String PXAT = "pxat";
    private static final String KEEPTTL = "keepttl";
    private static final String GET = "get";

    public static SetParams setParams() {
        return new SetParams();
    }

    @Deprecated
    public SetParams ex(int secondsToExpire) {
        return this.ex((long)secondsToExpire);
    }

    public SetParams ex(long secondsToExpire) {
        this.addParam(EX, secondsToExpire);
        return this;
    }

    public SetParams px(long millisecondsToExpire) {
        this.addParam(PX, millisecondsToExpire);
        return this;
    }

    public SetParams nx() {
        this.addParam(NX);
        return this;
    }

    public SetParams xx() {
        this.addParam(XX);
        return this;
    }

    public SetParams exAt(long seconds) {
        this.addParam(EXAT, seconds);
        return this;
    }

    public SetParams pxAt(long milliseconds) {
        this.addParam(PXAT, milliseconds);
        return this;
    }

    public SetParams keepttl() {
        this.addParam(KEEPTTL);
        return this;
    }

    public SetParams get() {
        this.addParam(GET);
        return this;
    }

    public byte[][] getByteParams(byte[] ... args) {
        ArrayList<byte[]> byteParams = new ArrayList<byte[]>();
        Collections.addAll(byteParams, args);
        if (this.contains(NX)) {
            byteParams.add(SafeEncoder.encode(NX));
        }
        if (this.contains(XX)) {
            byteParams.add(SafeEncoder.encode(XX));
        }
        if (this.contains(EX)) {
            byteParams.add(SafeEncoder.encode(EX));
            byteParams.add(Protocol.toByteArray((Long)this.getParam(EX)));
        }
        if (this.contains(PX)) {
            byteParams.add(SafeEncoder.encode(PX));
            byteParams.add(Protocol.toByteArray((Long)this.getParam(PX)));
        }
        if (this.contains(EXAT)) {
            byteParams.add(SafeEncoder.encode(EXAT));
            byteParams.add(Protocol.toByteArray((Long)this.getParam(EXAT)));
        }
        if (this.contains(PXAT)) {
            byteParams.add(SafeEncoder.encode(PXAT));
            byteParams.add(Protocol.toByteArray((Long)this.getParam(PXAT)));
        }
        if (this.contains(KEEPTTL)) {
            byteParams.add(SafeEncoder.encode(KEEPTTL));
        }
        if (this.contains(GET)) {
            byteParams.add(SafeEncoder.encode(GET));
        }
        return (byte[][])byteParams.toArray((T[])new byte[byteParams.size()][]);
    }
}

