/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.paper.events;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import io.papermc.paper.event.entity.EntityLoadCrossbowEvent;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;

public class EntityLoadCrossbowScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static EntityLoadCrossbowScriptEvent instance;
    public EntityLoadCrossbowEvent event;
    public EntityTag entity;

    public EntityLoadCrossbowScriptEvent() {
        instance = this;
        this.registerCouldMatcher("<entity> loads crossbow");
        this.registerSwitches(new String[]{"crossbow"});
    }

    public boolean matches(ScriptEvent.ScriptPath path) {
        if (!this.entity.tryAdvancedMatcher(path.eventArgLowerAt(0))) {
            return false;
        }
        if (!EntityLoadCrossbowScriptEvent.runWithCheck((ScriptEvent.ScriptPath)path, (ItemTag)new ItemTag(this.event.getCrossbow()), (String)"crossbow")) {
            return false;
        }
        return super.matches(path);
    }

    public String getName() {
        return "EntityLoadsCrossbow";
    }

    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(this.entity);
    }

    public boolean applyDetermination(ScriptEvent.ScriptPath path, ObjectTag determinationObj) {
        String lower;
        if (determinationObj instanceof ElementTag && (lower = CoreUtilities.toLowerCase((String)determinationObj.toString())).equals("keep_item")) {
            this.event.setConsumeItem(false);
            return true;
        }
        return super.applyDetermination(path, determinationObj);
    }

    public ObjectTag getContext(String name) {
        switch (name) {
            case "entity": {
                return this.entity.getDenizenObject();
            }
            case "crossbow": {
                return new ItemTag(this.event.getCrossbow());
            }
            case "hand": {
                return new ElementTag(this.event.getHand().name());
            }
            case "consumes": {
                return new ElementTag(this.event.shouldConsumeItem());
            }
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onLoadCrossbow(EntityLoadCrossbowEvent event) {
        this.event = event;
        this.entity = new EntityTag((Entity)event.getEntity());
        this.fire((Event)event);
    }
}

