/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.v1_16.helpers;

import com.denizenscript.denizen.nms.interfaces.BlockHelper;
import com.denizenscript.denizen.nms.util.PlayerProfile;
import com.denizenscript.denizen.nms.util.jnbt.CompoundTag;
import com.denizenscript.denizen.nms.util.jnbt.CompoundTagBuilder;
import com.denizenscript.denizen.nms.v1_16.impl.jnbt.CompoundTagImpl;
import com.denizenscript.denizencore.utilities.ReflectionHelper;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.google.common.collect.Iterables;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.server.v1_16_R3.BlockBase;
import net.minecraft.server.v1_16_R3.BlockPosition;
import net.minecraft.server.v1_16_R3.Chunk;
import net.minecraft.server.v1_16_R3.EnumPistonReaction;
import net.minecraft.server.v1_16_R3.Fluid;
import net.minecraft.server.v1_16_R3.IBlockData;
import net.minecraft.server.v1_16_R3.NBTTagCompound;
import net.minecraft.server.v1_16_R3.TileEntity;
import net.minecraft.server.v1_16_R3.TileEntitySkull;
import net.minecraft.server.v1_16_R3.World;
import net.minecraft.server.v1_16_R3.WorldServer;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Skull;
import org.bukkit.block.data.BlockData;
import org.bukkit.craftbukkit.v1_16_R3.CraftChunk;
import org.bukkit.craftbukkit.v1_16_R3.CraftWorld;
import org.bukkit.craftbukkit.v1_16_R3.block.CraftBlockEntityState;
import org.bukkit.craftbukkit.v1_16_R3.block.CraftBlockState;
import org.bukkit.craftbukkit.v1_16_R3.block.CraftSkull;
import org.bukkit.craftbukkit.v1_16_R3.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_16_R3.util.CraftMagicNumbers;
import org.bukkit.event.world.PortalCreateEvent;

public class BlockHelperImpl
implements BlockHelper {
    public static final Field craftBlockEntityState_tileEntity = ReflectionHelper.getFields(CraftBlockEntityState.class).get((Object)"tileEntity");
    public static final Field craftBlockEntityState_snapshot = ReflectionHelper.getFields(CraftBlockEntityState.class).get((Object)"snapshot");
    public static final Field craftSkull_profile = ReflectionHelper.getFields(CraftSkull.class).get((Object)"profile");
    public static final Field BLOCK_MATERIAL = ReflectionHelper.getFields(BlockBase.class).get((Object)"material");
    public static final MethodHandle MATERIAL_PUSH_REACTION_SETTER = ReflectionHelper.getFinalSetter(net.minecraft.server.v1_16_R3.Material.class, (String)"T");
    public static final MethodHandle BLOCK_STRENGTH_SETTER = ReflectionHelper.getFinalSetter(BlockBase.BlockData.class, (String)"strength");

    public void makeBlockStateRaw(BlockState state) {
        try {
            craftBlockEntityState_snapshot.set(state, craftBlockEntityState_tileEntity.get(state));
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
    }

    public void applyPhysics(Location location) {
        BlockPosition pos = new BlockPosition(location.getBlockX(), location.getBlockY(), location.getBlockZ());
        ((CraftWorld)location.getWorld()).getHandle().applyPhysics(pos, CraftMagicNumbers.getBlock((Material)location.getBlock().getType()));
    }

    public BlockData parseBlockData(Material material, String otherData) {
        return CraftBlockData.newData((Material)material, (String)otherData);
    }

    public List<Location> getBlocksList(PortalCreateEvent event) {
        ArrayList<Location> blocks = new ArrayList<Location>();
        for (BlockState block : event.getBlocks()) {
            blocks.add(block.getLocation());
        }
        return blocks;
    }

    public <T extends TileEntity> T getTE(CraftBlockEntityState<T> cbs) {
        try {
            return (T)((TileEntity)craftBlockEntityState_tileEntity.get(cbs));
        }
        catch (IllegalAccessException e) {
            Debug.echoError((Throwable)e);
            return null;
        }
    }

    public PlayerProfile getPlayerProfile(Skull skull) {
        GameProfile profile = ((TileEntitySkull)this.getTE((CraftSkull)skull)).gameProfile;
        if (profile == null) {
            return null;
        }
        String name = profile.getName();
        UUID id = profile.getId();
        Property property = (Property)Iterables.getFirst((Iterable)profile.getProperties().get((Object)"textures"), null);
        return new PlayerProfile(name, id, property != null ? property.getValue() : null);
    }

    public void setPlayerProfile(Skull skull, PlayerProfile playerProfile) {
        GameProfile gameProfile = new GameProfile(playerProfile.getUniqueId(), playerProfile.getName());
        if (playerProfile.hasTexture()) {
            gameProfile.getProperties().put((Object)"textures", (Object)new Property("textures", playerProfile.getTexture(), playerProfile.getTextureSignature()));
        }
        try {
            craftSkull_profile.set(skull, gameProfile);
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
        skull.update();
    }

    public CompoundTag getNbtData(Block block) {
        TileEntity te = ((CraftWorld)block.getWorld()).getHandle().getTileEntity(new BlockPosition(block.getX(), block.getY(), block.getZ()));
        if (te != null) {
            NBTTagCompound compound = new NBTTagCompound();
            te.save(compound);
            return CompoundTagImpl.fromNMSTag(compound);
        }
        return null;
    }

    public void setNbtData(Block block, CompoundTag ctag) {
        CompoundTagBuilder builder = ctag.createBuilder();
        builder.putInt("x", block.getX());
        builder.putInt("y", block.getY());
        builder.putInt("z", block.getZ());
        ctag = builder.build();
        BlockPosition blockPos = new BlockPosition(block.getX(), block.getY(), block.getZ());
        TileEntity te = ((CraftWorld)block.getWorld()).getHandle().getTileEntity(blockPos);
        te.load(((CraftBlockData)block.getBlockData()).getState(), ((CompoundTagImpl)ctag).toNMSTag());
    }

    public boolean setBlockResistance(Material material, float resistance) {
        net.minecraft.server.v1_16_R3.Block block = this.getMaterialBlock(material);
        if (block == null) {
            return false;
        }
        ReflectionHelper.setFieldValue(BlockBase.class, (String)"durability", (Object)block, (Object)Float.valueOf(resistance));
        return true;
    }

    public float getBlockResistance(Material material) {
        net.minecraft.server.v1_16_R3.Block block = this.getMaterialBlock(material);
        if (block == null) {
            return 0.0f;
        }
        return ((Float)ReflectionHelper.getFieldValue(BlockBase.class, (String)"durability", (Object)block)).floatValue();
    }

    public BlockState generateBlockState(Block block, Material mat) {
        CraftBlockState state = new CraftBlockState(block);
        state.setData(CraftMagicNumbers.getBlock((Material)mat).getBlockData());
        return state;
    }

    public net.minecraft.server.v1_16_R3.Block getMaterialBlock(Material bukkitMaterial) {
        if (!bukkitMaterial.isBlock()) {
            return null;
        }
        return ((CraftBlockData)bukkitMaterial.createBlockData()).getState().getBlock();
    }

    public net.minecraft.server.v1_16_R3.Material getInternalMaterial(Material bukkitMaterial) {
        try {
            return (net.minecraft.server.v1_16_R3.Material)BLOCK_MATERIAL.get(this.getMaterialBlock(bukkitMaterial));
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
            return null;
        }
    }

    public String getPushReaction(Material mat) {
        return this.getInternalMaterial(mat).getPushReaction().name();
    }

    public void setPushReaction(Material mat, String reaction) {
        try {
            MATERIAL_PUSH_REACTION_SETTER.invoke(this.getInternalMaterial(mat), EnumPistonReaction.valueOf((String)reaction));
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
    }

    public float getBlockStength(Material mat) {
        return this.getMaterialBlock((Material)mat).getBlockData().strength;
    }

    public void setBlockStrength(Material mat, float strength) {
        try {
            BLOCK_STRENGTH_SETTER.invoke(this.getMaterialBlock(mat).getBlockData(), strength);
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
    }

    public void doRandomTick(Location location) {
        Fluid fluid;
        BlockPosition pos = new BlockPosition(location.getBlockX(), location.getBlockY(), location.getBlockZ());
        Chunk nmsChunk = ((CraftChunk)location.getChunk()).getHandle();
        IBlockData nmsBlock = nmsChunk.getType(pos);
        WorldServer nmsWorld = ((CraftWorld)location.getWorld()).getHandle();
        if (nmsBlock.isTicking()) {
            nmsBlock.b(nmsWorld, pos, nmsWorld.random);
        }
        if ((fluid = nmsBlock.getFluid()).f()) {
            fluid.b((World)nmsWorld, pos, nmsWorld.random);
        }
    }
}

