/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.utilities.debugging;

import com.denizenscript.denizen.Denizen;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.DenizenCore;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.core.DurationTag;
import com.denizenscript.denizencore.scripts.ScriptRegistry;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.ReflectionHelper;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.World;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class DebugSubmit
extends Thread {
    public String recording;
    public String result = null;
    public String prefix;
    public static YamlConfiguration paperConfig;

    public void build() {
        try {
            Object temp;
            StringBuilder pluginlist = new StringBuilder();
            int newlineLength = 0;
            int pluginCount = Bukkit.getPluginManager().getPlugins().length;
            for (Plugin pl : Bukkit.getPluginManager().getPlugins()) {
                temp = '\u0001' + (pl.isEnabled() ? "2" : "4") + pl.getName() + ": " + pl.getDescription().getVersion() + ", ";
                pluginlist.append((String)temp);
                if ((newlineLength += ((String)temp).length()) <= 80) continue;
                newlineLength = 0;
                pluginlist.append("\n");
            }
            StringBuilder worldlist = new StringBuilder();
            newlineLength = 0;
            int worldCount = Bukkit.getWorlds().size();
            for (World w : Bukkit.getWorlds()) {
                temp = w.getName() + ", ";
                worldlist.append((String)temp);
                if ((newlineLength += ((String)temp).length()) <= 80) continue;
                newlineLength = 0;
                worldlist.append("\n");
            }
            StringBuilder playerlist = new StringBuilder();
            newlineLength = 0;
            int playerCount = Bukkit.getOnlinePlayers().size();
            for (Player pla : Bukkit.getOnlinePlayers()) {
                String temp2 = pla.getDisplayName() + ChatColor.GRAY + "(" + pla.getName() + "), ";
                playerlist.append(temp2);
                if ((newlineLength += temp2.length()) <= 80) continue;
                newlineLength = 0;
                playerlist.append("\n");
            }
            if (playerlist.length() < 2) {
                playerlist.append("No Online Players, ");
            }
            int plNormal = 0;
            int plNull = 0;
            int pl3 = 0;
            int pl0 = 0;
            int plWeird = 0;
            try {
                for (UUID id : PlayerTag.getAllPlayers().values()) {
                    if (id == null) {
                        ++plNull;
                        continue;
                    }
                    if (id.version() == 4) {
                        ++plNormal;
                        continue;
                    }
                    if (id.version() == 3) {
                        ++pl3;
                        continue;
                    }
                    if (id.version() == 0) {
                        ++pl0;
                        continue;
                    }
                    ++plWeird;
                }
            }
            catch (Throwable ex) {
                Debug.echoError(ex);
            }
            String playerSet = (plNormal > 0 ? plNormal + " normal, " : "") + (plNull > 0 ? plNull + " null, " : "") + (pl3 > 0 ? pl3 + " v3, " : "") + (pl0 > 0 ? pl0 + " v0, " : "") + (plWeird > 0 ? plWeird + " other, " : "");
            if (playerSet.length() > 2) {
                playerSet = playerSet.substring(0, playerSet.length() - 2);
            }
            boolean proxied = false;
            String modeSuffix = "";
            if (Bukkit.getServer().spigot().getConfig().getBoolean("settings.bungeecord")) {
                modeSuffix = " (BungeeCord)";
                proxied = true;
            } else if (Denizen.supportsPaper && DebugSubmit.getPaperConfigKey("settings.velocity-support.enabled")) {
                boolean velocityOnline = DebugSubmit.getPaperConfigKey("settings.velocity-support.online-mode");
                modeSuffix = velocityOnline ? ChatColor.GREEN + " (Velocity: online)" : ChatColor.RED + " (Velocity: offline)";
                proxied = true;
            }
            String onlineMode = (Bukkit.getServer().getOnlineMode() ? ChatColor.GREEN + "online" : (proxied ? ChatColor.YELLOW : ChatColor.RED) + "offline") + modeSuffix;
            this.prefix = "pastetype=log&response=micro&v=200&pastetitle=Denizen+Debug+Logs+From+" + URLEncoder.encode(ChatColor.stripColor((String)Bukkit.getServer().getMotd())) + "&pastecontents=" + URLEncoder.encode("Java Version: " + System.getProperty("java.version") + "\nUp-time: " + new DurationTag((double)(CoreUtilities.monotonicMillis() - DenizenCore.startTime) / 1000.0).formatted(false) + "\nServer Version: " + Bukkit.getServer().getName() + " version " + Bukkit.getServer().getVersion() + "\nDenizen Version: Core: " + DenizenCore.VERSION + ", CraftBukkit: " + Denizen.getInstance().coreImplementation.getImplementationVersion() + "\nActive Plugins (" + pluginCount + "): " + pluginlist.substring(0, pluginlist.length() - 2) + "\nScript Containers: " + ScriptRegistry.scriptContainers.size() + ", Events: " + ScriptEvent.totalPaths + "\nLoaded Worlds (" + worldCount + "): " + worldlist.substring(0, worldlist.length() - 2) + "\nOnline Players (" + playerCount + "): " + playerlist.substring(0, playerlist.length() - 2) + "\nTotal Players Ever: " + PlayerTag.getAllPlayers().size() + " (" + playerSet + ")\nMode: " + onlineMode + "\nLast reload: " + new DurationTag((double)(CoreUtilities.monotonicMillis() - DenizenCore.lastReloadTime) / 1000.0).formatted(false) + " ago\n\n", "UTF-8");
        }
        catch (Throwable ex) {
            Debug.echoError(ex);
        }
    }

    public static boolean getPaperConfigKey(String key) {
        if (!Denizen.supportsPaper) {
            return false;
        }
        try {
            if (paperConfig == null) {
                paperConfig = (YamlConfiguration)ReflectionHelper.getFields(Class.forName("com.destroystokyo.paper.PaperConfig")).get("config").get(null);
            }
            return paperConfig.getBoolean(key);
        }
        catch (Throwable ex) {
            Debug.echoError(ex);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        BufferedReader in = null;
        try {
            URL url = new URL("https://paste.denizenscript.com/New/Log");
            HttpURLConnection uc = (HttpURLConnection)url.openConnection();
            uc.setDoInput(true);
            uc.setDoOutput(true);
            uc.setConnectTimeout(10000);
            uc.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            uc.connect();
            uc.getOutputStream().write((this.prefix + this.recording).getBytes(StandardCharsets.UTF_8));
            in = new BufferedReader(new InputStreamReader(uc.getInputStream()));
            this.result = in.readLine();
            if (this.result != null && this.result.startsWith("<!DOCTYPE html")) {
                this.result = null;
            }
            in.close();
        }
        catch (Exception e) {
            Debug.echoError(e);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception e) {
                Debug.echoError(e);
            }
        }
    }
}

