/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.utilities;

import com.denizenscript.denizencore.scripts.ScriptBuilder;
import com.denizenscript.denizencore.utilities.CoreConfiguration;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.text.StringHolder;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.SafeConstructor;
import org.yaml.snakeyaml.representer.Representer;
import org.yaml.snakeyaml.resolver.Resolver;
import org.yaml.snakeyaml.scanner.ScannerImpl;

public class YamlConfiguration {
    public Map<StringHolder, Object> contents = new LinkedHashMap<StringHolder, Object>();
    boolean dirty = false;

    public static YamlConfiguration load(String data) {
        return YamlConfiguration.load(data, true);
    }

    public static YamlConfiguration load(String data, boolean useCustomResolver) {
        DumperOptions options = new DumperOptions();
        options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        options.setAllowUnicode(true);
        Yaml yaml = new Yaml((BaseConstructor)new SafeConstructor(), new Representer(), options, (Resolver)(useCustomResolver ? new CustomResolver() : new Resolver()));
        Object obj = yaml.load(data);
        YamlConfiguration config = new YamlConfiguration();
        if (obj == null) {
            return null;
        }
        if (obj instanceof String) {
            config.contents = new LinkedHashMap<StringHolder, Object>();
            config.contents.put(null, obj);
        } else if (obj instanceof Map) {
            config.contents = (Map)obj;
        } else {
            Debug.echoError("Invalid YAML object type: " + obj + " is " + obj.getClass().getSimpleName());
            return null;
        }
        YamlConfiguration.switchKeys(config.contents);
        return config;
    }

    public static void switchKeys(Map<StringHolder, Object> objs) {
        for (Map.Entry<StringHolder, Object> entry : new ArrayList<Map.Entry<StringHolder, Object>>(objs.entrySet())) {
            StringHolder key = entry.getKey();
            Object value = entry.getValue();
            objs.remove(key);
            objs.put(key == null ? null : new StringHolder(((Object)key).toString()), value);
        }
        for (Map.Entry<StringHolder, Object> entry : objs.entrySet()) {
            if (entry.getValue() instanceof Map) {
                Map map = (Map)entry.getValue();
                YamlConfiguration.switchKeys(map);
                objs.put(entry.getKey(), map);
                continue;
            }
            if (!(entry.getValue() instanceof List)) continue;
            List list = (List)entry.getValue();
            ArrayList<LinkedHashMap<StringHolder, Object>> outList = new ArrayList<LinkedHashMap<StringHolder, Object>>();
            for (Object obj : list) {
                if (obj instanceof Map) {
                    LinkedHashMap<StringHolder, Object> map = new LinkedHashMap<StringHolder, Object>((Map)obj);
                    YamlConfiguration.switchKeys(map);
                    outList.add(map);
                    continue;
                }
                outList.add((LinkedHashMap<StringHolder, Object>)obj);
            }
            objs.put(entry.getKey(), outList);
        }
    }

    public static Map<String, Object> reverse(Map<StringHolder, Object> objs, boolean patchLines) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        for (Map.Entry<StringHolder, Object> obj : objs.entrySet()) {
            if (obj.getValue() instanceof Map) {
                map.put(obj.getKey().str, YamlConfiguration.reverse((Map)obj.getValue(), patchLines));
                continue;
            }
            if (obj.getValue() instanceof List) {
                List vals = (List)obj.getValue();
                ArrayList<Object> output = new ArrayList<Object>(vals.size());
                for (Object val : vals) {
                    if (val == null) continue;
                    if (val instanceof Map) {
                        output.add(YamlConfiguration.reverse((Map)val, patchLines));
                        continue;
                    }
                    if (patchLines) {
                        output.add(ScriptBuilder.stripLinePrefix(val.toString()));
                        continue;
                    }
                    output.add(val);
                }
                map.put(obj.getKey().str, output);
                continue;
            }
            map.put(obj.getKey().str, obj.getValue());
        }
        return map;
    }

    public void forceLoweredRootKey(String keyName) {
        StringHolder key = new StringHolder(CoreUtilities.toLowerCase(keyName));
        Object obj = this.contents.get(key);
        if (obj != null) {
            this.contents.remove(key);
            this.contents.put(key, obj);
        }
    }

    public static List<String> patchListNonsense(List<Object> objs) {
        ArrayList<String> list = new ArrayList<String>();
        for (Object o : objs) {
            if (o == null) {
                list.add("null");
                continue;
            }
            list.add(o.toString());
        }
        return list;
    }

    public Set<StringHolder> getKeys(boolean deep) {
        if (!deep) {
            return new LinkedHashSet<StringHolder>(this.contents.keySet());
        }
        return this.getKeysDeep(this.contents, "");
    }

    public Map<StringHolder, Object> getMap() {
        return new LinkedHashMap<StringHolder, Object>(this.contents);
    }

    public void addAll(Map<StringHolder, Object> newContents) {
        this.contents.putAll(newContents);
    }

    private Set<StringHolder> getKeysDeep(Map<StringHolder, Object> objs, String base) {
        LinkedHashSet<StringHolder> strings = new LinkedHashSet<StringHolder>();
        for (Map.Entry<StringHolder, Object> obj : objs.entrySet()) {
            strings.add(new StringHolder(base + obj.getKey()));
            if (!(obj.getValue() instanceof Map)) continue;
            strings.addAll(this.getKeysDeep((Map)obj.getValue(), base + obj.getKey() + "."));
        }
        return strings;
    }

    public String saveToString(boolean patchLines) {
        DumperOptions options = new DumperOptions();
        options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        options.setAllowUnicode(true);
        Yaml yaml = new Yaml(options);
        String dumped = yaml.dump(YamlConfiguration.reverse(this.contents, patchLines));
        if (CoreConfiguration.debugVerbose) {
            Debug.log("Outputting " + dumped);
        }
        return dumped;
    }

    public Object get(String path) {
        if (path.isEmpty()) {
            return this.contents;
        }
        List<String> parts = CoreUtilities.split(path, '.');
        Map portion = this.contents;
        for (int i = 0; i < parts.size(); ++i) {
            Object oPortion = portion.get(new StringHolder(parts.get(i)));
            if (oPortion == null) {
                return null;
            }
            if (parts.size() == i + 1) {
                return oPortion;
            }
            if (!(oPortion instanceof Map)) {
                return null;
            }
            portion = (Map)oPortion;
        }
        return null;
    }

    public void set(String path, Object o) {
        if (o instanceof YamlConfiguration) {
            o = new LinkedHashMap<StringHolder, Object>(((YamlConfiguration)((Object)o)).contents);
        }
        List<String> parts = CoreUtilities.split(path, '.');
        LinkedHashMap portion = this.contents;
        for (int i = 0; i < parts.size(); ++i) {
            LinkedHashMap map;
            Object oPortion = portion.get(new StringHolder(parts.get(i)));
            if (parts.size() == i + 1) {
                if (o == null) {
                    portion.remove(new StringHolder(parts.get(i)));
                    this.emptyEmptyMaps(parts);
                } else {
                    portion.put(new StringHolder(parts.get(i)), o);
                }
                this.dirty = true;
                return;
            }
            if (oPortion == null) {
                map = new LinkedHashMap();
                portion.put(new StringHolder(parts.get(i)), map);
                portion = map;
                continue;
            }
            if (oPortion instanceof Map) {
                portion = (LinkedHashMap)oPortion;
                continue;
            }
            map = new LinkedHashMap();
            portion.put(new StringHolder(parts.get(i)), map);
            portion = map;
        }
        Debug.echoError("Failed to set somehow?");
    }

    void emptyEmptyMaps(List<String> parts) {
        Map portion = this.contents;
        for (int i = 0; i < parts.size(); ++i) {
            Object oPortion = portion.get(new StringHolder(parts.get(i)));
            if (oPortion == null) {
                return;
            }
            if (oPortion instanceof Map) {
                if (((Map)oPortion).isEmpty()) {
                    portion.remove(new StringHolder(parts.get(i)));
                    this.emptyEmptyMaps(parts);
                    return;
                }
            } else {
                return;
            }
            portion = (Map)oPortion;
        }
    }

    public boolean contains(String path) {
        return this.get(path) != null;
    }

    public String getString(String path) {
        Object o = this.get(path);
        if (o == null) {
            return null;
        }
        return o.toString();
    }

    public String getString(String path, String def) {
        Object o = this.get(path);
        if (o == null) {
            return def;
        }
        return o.toString();
    }

    public boolean isList(String path) {
        Object o = this.get(path);
        return o instanceof List;
    }

    public List<Object> getList(String path) {
        Object o = this.get(path);
        if (!(o instanceof List)) {
            return null;
        }
        return (List)o;
    }

    public List<String> getStringList(String path) {
        Object o = this.get(path);
        if (!(o instanceof List)) {
            return null;
        }
        return YamlConfiguration.patchListNonsense((List)o);
    }

    public YamlConfiguration getConfigurationSection(String path) {
        Object o = this.get(path);
        if (!(o instanceof Map)) {
            return null;
        }
        YamlConfiguration configuration = new YamlConfiguration();
        configuration.contents = (Map)o;
        return configuration;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    static {
        ScannerImpl.ESCAPE_REPLACEMENTS.put(Character.valueOf('/'), "/");
    }

    public static class CustomResolver
    extends Resolver {
        protected void addImplicitResolvers() {
        }
    }
}

