/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.item;

import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.tags.Attribute;
import org.bukkit.Material;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.meta.ItemMeta;

public class ItemBookGeneration
implements Property {
    public static final String[] handledTags = new String[]{"book_generation"};
    public static final String[] handledMechs = new String[]{"book_generation"};
    ItemTag item;

    public static boolean describes(ObjectTag item) {
        return item instanceof ItemTag && ((ItemTag)item).getBukkitMaterial() == Material.WRITTEN_BOOK;
    }

    public static ItemBookGeneration getFrom(ObjectTag _item) {
        if (!ItemBookGeneration.describes(_item)) {
            return null;
        }
        return new ItemBookGeneration((ItemTag)_item);
    }

    private ItemBookGeneration(ItemTag _item) {
        this.item = _item;
    }

    @Override
    public ObjectTag getObjectAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        if (attribute.startsWith("book_generation")) {
            BookMeta meta = (BookMeta)this.item.getItemMeta();
            if (!meta.hasGeneration()) {
                return null;
            }
            return new ElementTag(meta.getGeneration().name()).getObjectAttribute(attribute.fulfill(1));
        }
        return null;
    }

    @Override
    public String getPropertyString() {
        BookMeta meta = (BookMeta)this.item.getItemMeta();
        if (!meta.hasGeneration()) {
            return null;
        }
        return meta.getGeneration().name();
    }

    @Override
    public String getPropertyId() {
        return "book_generation";
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("book_generation") && mechanism.requireEnum(BookMeta.Generation.class)) {
            BookMeta meta = (BookMeta)this.item.getItemMeta();
            meta.setGeneration(BookMeta.Generation.valueOf((String)mechanism.getValue().asString().toUpperCase()));
            this.item.setItemMeta((ItemMeta)meta);
        }
    }
}

