/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.shaded.redis.clients.jedis;

import com.denizenscript.shaded.redis.clients.jedis.AccessControlUser;
import com.denizenscript.shaded.redis.clients.jedis.BinaryJedisPubSub;
import com.denizenscript.shaded.redis.clients.jedis.BitOP;
import com.denizenscript.shaded.redis.clients.jedis.BitPosParams;
import com.denizenscript.shaded.redis.clients.jedis.BuilderFactory;
import com.denizenscript.shaded.redis.clients.jedis.Client;
import com.denizenscript.shaded.redis.clients.jedis.DebugParams;
import com.denizenscript.shaded.redis.clients.jedis.DefaultJedisClientConfig;
import com.denizenscript.shaded.redis.clients.jedis.GeoCoordinate;
import com.denizenscript.shaded.redis.clients.jedis.GeoRadiusResponse;
import com.denizenscript.shaded.redis.clients.jedis.GeoUnit;
import com.denizenscript.shaded.redis.clients.jedis.HostAndPort;
import com.denizenscript.shaded.redis.clients.jedis.JedisClientConfig;
import com.denizenscript.shaded.redis.clients.jedis.JedisMonitor;
import com.denizenscript.shaded.redis.clients.jedis.JedisShardInfo;
import com.denizenscript.shaded.redis.clients.jedis.JedisSocketFactory;
import com.denizenscript.shaded.redis.clients.jedis.ListPosition;
import com.denizenscript.shaded.redis.clients.jedis.Pipeline;
import com.denizenscript.shaded.redis.clients.jedis.Protocol;
import com.denizenscript.shaded.redis.clients.jedis.ScanParams;
import com.denizenscript.shaded.redis.clients.jedis.ScanResult;
import com.denizenscript.shaded.redis.clients.jedis.SortingParams;
import com.denizenscript.shaded.redis.clients.jedis.StreamConsumersInfo;
import com.denizenscript.shaded.redis.clients.jedis.StreamGroupInfo;
import com.denizenscript.shaded.redis.clients.jedis.StreamInfo;
import com.denizenscript.shaded.redis.clients.jedis.Transaction;
import com.denizenscript.shaded.redis.clients.jedis.Tuple;
import com.denizenscript.shaded.redis.clients.jedis.ZParams;
import com.denizenscript.shaded.redis.clients.jedis.args.ClientPauseMode;
import com.denizenscript.shaded.redis.clients.jedis.args.ClientType;
import com.denizenscript.shaded.redis.clients.jedis.args.FlushMode;
import com.denizenscript.shaded.redis.clients.jedis.args.ListDirection;
import com.denizenscript.shaded.redis.clients.jedis.args.SaveMode;
import com.denizenscript.shaded.redis.clients.jedis.args.UnblockType;
import com.denizenscript.shaded.redis.clients.jedis.commands.AdvancedBinaryJedisCommands;
import com.denizenscript.shaded.redis.clients.jedis.commands.BasicCommands;
import com.denizenscript.shaded.redis.clients.jedis.commands.BinaryJedisCommands;
import com.denizenscript.shaded.redis.clients.jedis.commands.BinaryScriptingCommands;
import com.denizenscript.shaded.redis.clients.jedis.commands.MultiKeyBinaryCommands;
import com.denizenscript.shaded.redis.clients.jedis.commands.ProtocolCommand;
import com.denizenscript.shaded.redis.clients.jedis.exceptions.InvalidURIException;
import com.denizenscript.shaded.redis.clients.jedis.exceptions.JedisConnectionException;
import com.denizenscript.shaded.redis.clients.jedis.exceptions.JedisDataException;
import com.denizenscript.shaded.redis.clients.jedis.exceptions.JedisException;
import com.denizenscript.shaded.redis.clients.jedis.params.ClientKillParams;
import com.denizenscript.shaded.redis.clients.jedis.params.FailoverParams;
import com.denizenscript.shaded.redis.clients.jedis.params.GeoAddParams;
import com.denizenscript.shaded.redis.clients.jedis.params.GeoRadiusParam;
import com.denizenscript.shaded.redis.clients.jedis.params.GeoRadiusStoreParam;
import com.denizenscript.shaded.redis.clients.jedis.params.GetExParams;
import com.denizenscript.shaded.redis.clients.jedis.params.LPosParams;
import com.denizenscript.shaded.redis.clients.jedis.params.MigrateParams;
import com.denizenscript.shaded.redis.clients.jedis.params.RestoreParams;
import com.denizenscript.shaded.redis.clients.jedis.params.SetParams;
import com.denizenscript.shaded.redis.clients.jedis.params.StrAlgoLCSParams;
import com.denizenscript.shaded.redis.clients.jedis.params.XAddParams;
import com.denizenscript.shaded.redis.clients.jedis.params.XAutoClaimParams;
import com.denizenscript.shaded.redis.clients.jedis.params.XClaimParams;
import com.denizenscript.shaded.redis.clients.jedis.params.XPendingParams;
import com.denizenscript.shaded.redis.clients.jedis.params.XReadGroupParams;
import com.denizenscript.shaded.redis.clients.jedis.params.XReadParams;
import com.denizenscript.shaded.redis.clients.jedis.params.XTrimParams;
import com.denizenscript.shaded.redis.clients.jedis.params.ZAddParams;
import com.denizenscript.shaded.redis.clients.jedis.params.ZIncrByParams;
import com.denizenscript.shaded.redis.clients.jedis.resps.LCSMatchResult;
import com.denizenscript.shaded.redis.clients.jedis.util.JedisURIHelper;
import com.denizenscript.shaded.redis.clients.jedis.util.SafeEncoder;
import java.io.Closeable;
import java.io.Serializable;
import java.net.URI;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocketFactory;

public class BinaryJedis
implements BasicCommands,
BinaryJedisCommands,
MultiKeyBinaryCommands,
AdvancedBinaryJedisCommands,
BinaryScriptingCommands,
Closeable {
    protected final Client client;
    protected Transaction transaction = null;
    protected Pipeline pipeline = null;
    protected static final byte[][] DUMMY_ARRAY = new byte[0][];

    public BinaryJedis() {
        this.client = new Client();
    }

    @Deprecated
    public BinaryJedis(String uriString) {
        URI uri = URI.create(uriString);
        if (JedisURIHelper.isValid(uri)) {
            this.client = BinaryJedis.createClientFromURI(uri);
            this.initializeFromURI(uri);
        } else {
            this.client = new Client(uriString);
        }
    }

    public BinaryJedis(HostAndPort hp) {
        this(hp, (JedisClientConfig)DefaultJedisClientConfig.builder().build());
    }

    public BinaryJedis(String host, int port) {
        this.client = new Client(host, port);
    }

    public BinaryJedis(String host, int port, JedisClientConfig config) {
        this(new HostAndPort(host, port), config);
    }

    public BinaryJedis(HostAndPort hostPort, JedisClientConfig config) {
        this.client = new Client(hostPort, config);
        this.initializeFromClientConfig(config);
    }

    private void initializeFromClientConfig(JedisClientConfig config) {
        try {
            String clientName;
            int dbIndex;
            this.connect();
            String password = config.getPassword();
            if (password != null) {
                String user = config.getUser();
                if (user != null) {
                    this.auth(user, password);
                } else {
                    this.auth(password);
                }
            }
            if ((dbIndex = config.getDatabase()) > 0) {
                this.select(dbIndex);
            }
            if ((clientName = config.getClientName()) != null) {
                this.clientSetname(SafeEncoder.encode(clientName));
            }
        }
        catch (JedisException je) {
            try {
                if (this.isConnected()) {
                    this.quit();
                }
                this.disconnect();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw je;
        }
    }

    public BinaryJedis(String host, int port, boolean ssl) {
        this(host, port, DefaultJedisClientConfig.builder().ssl(ssl).build());
    }

    public BinaryJedis(String host, int port, boolean ssl, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier) {
        this(host, port, DefaultJedisClientConfig.builder().ssl(ssl).sslSocketFactory(sslSocketFactory).sslParameters(sslParameters).hostnameVerifier(hostnameVerifier).build());
    }

    public BinaryJedis(String host, int port, int timeout) {
        this(host, port, timeout, timeout);
    }

    public BinaryJedis(String host, int port, int timeout, boolean ssl) {
        this(host, port, timeout, timeout, ssl);
    }

    public BinaryJedis(String host, int port, int timeout, boolean ssl, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier) {
        this(host, port, timeout, timeout, ssl, sslSocketFactory, sslParameters, hostnameVerifier);
    }

    public BinaryJedis(String host, int port, int connectionTimeout, int soTimeout) {
        this(host, port, DefaultJedisClientConfig.builder().connectionTimeoutMillis(connectionTimeout).socketTimeoutMillis(soTimeout).build());
    }

    public BinaryJedis(String host, int port, int connectionTimeout, int soTimeout, int infiniteSoTimeout) {
        this(host, port, DefaultJedisClientConfig.builder().connectionTimeoutMillis(connectionTimeout).socketTimeoutMillis(soTimeout).blockingSocketTimeoutMillis(infiniteSoTimeout).build());
    }

    public BinaryJedis(String host, int port, int connectionTimeout, int soTimeout, boolean ssl) {
        this(host, port, DefaultJedisClientConfig.builder().connectionTimeoutMillis(connectionTimeout).socketTimeoutMillis(soTimeout).ssl(ssl).build());
    }

    public BinaryJedis(String host, int port, int connectionTimeout, int soTimeout, boolean ssl, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier) {
        this(host, port, DefaultJedisClientConfig.builder().connectionTimeoutMillis(connectionTimeout).socketTimeoutMillis(soTimeout).ssl(ssl).sslSocketFactory(sslSocketFactory).sslParameters(sslParameters).hostnameVerifier(hostnameVerifier).build());
    }

    public BinaryJedis(String host, int port, int connectionTimeout, int soTimeout, int infiniteSoTimeout, boolean ssl, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier) {
        this(host, port, DefaultJedisClientConfig.builder().connectionTimeoutMillis(connectionTimeout).socketTimeoutMillis(soTimeout).blockingSocketTimeoutMillis(infiniteSoTimeout).ssl(ssl).sslSocketFactory(sslSocketFactory).sslParameters(sslParameters).hostnameVerifier(hostnameVerifier).build());
    }

    public BinaryJedis(JedisShardInfo shardInfo) {
        this(shardInfo.getHost(), shardInfo.getPort(), DefaultJedisClientConfig.builder().connectionTimeoutMillis(shardInfo.getConnectionTimeout()).socketTimeoutMillis(shardInfo.getSoTimeout()).user(shardInfo.getUser()).password(shardInfo.getPassword()).database(shardInfo.getDb()).ssl(shardInfo.getSsl()).sslSocketFactory(shardInfo.getSslSocketFactory()).sslParameters(shardInfo.getSslParameters()).hostnameVerifier(shardInfo.getHostnameVerifier()).build());
    }

    public BinaryJedis(URI uri) {
        this.client = BinaryJedis.createClientFromURI(uri);
        this.initializeFromURI(uri);
    }

    public BinaryJedis(URI uri, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier) {
        this(uri, (JedisClientConfig)DefaultJedisClientConfig.builder().sslSocketFactory(sslSocketFactory).sslParameters(sslParameters).hostnameVerifier(hostnameVerifier).build());
    }

    public BinaryJedis(URI uri, int timeout) {
        this(uri, timeout, timeout);
    }

    public BinaryJedis(URI uri, int timeout, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier) {
        this(uri, timeout, timeout, sslSocketFactory, sslParameters, hostnameVerifier);
    }

    public BinaryJedis(URI uri, int connectionTimeout, int soTimeout) {
        this(uri, (JedisClientConfig)DefaultJedisClientConfig.builder().connectionTimeoutMillis(connectionTimeout).socketTimeoutMillis(soTimeout).build());
    }

    public BinaryJedis(URI uri, int connectionTimeout, int soTimeout, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier) {
        this(uri, (JedisClientConfig)DefaultJedisClientConfig.builder().connectionTimeoutMillis(connectionTimeout).socketTimeoutMillis(soTimeout).sslSocketFactory(sslSocketFactory).sslParameters(sslParameters).hostnameVerifier(hostnameVerifier).build());
    }

    public BinaryJedis(URI uri, int connectionTimeout, int soTimeout, int infiniteSoTimeout, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier) {
        this(uri, (JedisClientConfig)DefaultJedisClientConfig.builder().connectionTimeoutMillis(connectionTimeout).socketTimeoutMillis(soTimeout).blockingSocketTimeoutMillis(infiniteSoTimeout).sslSocketFactory(sslSocketFactory).sslParameters(sslParameters).hostnameVerifier(hostnameVerifier).build());
    }

    public BinaryJedis(URI uri, JedisClientConfig config) {
        if (!JedisURIHelper.isValid(uri)) {
            throw new InvalidURIException(String.format("Cannot open Redis connection due invalid URI \"%s\".", uri.toString()));
        }
        this.client = new Client(new HostAndPort(uri.getHost(), uri.getPort()), DefaultJedisClientConfig.builder().connectionTimeoutMillis(config.getConnectionTimeoutMillis()).socketTimeoutMillis(config.getSocketTimeoutMillis()).blockingSocketTimeoutMillis(config.getBlockingSocketTimeoutMillis()).user(JedisURIHelper.getUser(uri)).password(JedisURIHelper.getPassword(uri)).database(JedisURIHelper.getDBIndex(uri)).clientName(config.getClientName()).ssl(JedisURIHelper.isRedisSSLScheme(uri)).sslSocketFactory(config.getSslSocketFactory()).sslParameters(config.getSslParameters()).hostnameVerifier(config.getHostnameVerifier()).build());
        this.initializeFromURI(uri);
    }

    private static Client createClientFromURI(URI uri) {
        if (!JedisURIHelper.isValid(uri)) {
            throw new InvalidURIException(String.format("Cannot open Redis connection due invalid URI \"%s\".", uri.toString()));
        }
        return new Client(new HostAndPort(uri.getHost(), uri.getPort()), DefaultJedisClientConfig.builder().ssl(JedisURIHelper.isRedisSSLScheme(uri)).build());
    }

    private void initializeFromURI(URI uri) {
        int dbIndex;
        String password = JedisURIHelper.getPassword(uri);
        if (password != null) {
            String user = JedisURIHelper.getUser(uri);
            if (user != null) {
                this.auth(user, password);
            } else {
                this.auth(password);
            }
        }
        if ((dbIndex = JedisURIHelper.getDBIndex(uri)) > 0) {
            this.select(dbIndex);
        }
    }

    @Deprecated
    public BinaryJedis(JedisSocketFactory jedisSocketFactory) {
        this.client = new Client(jedisSocketFactory);
    }

    public BinaryJedis(JedisSocketFactory jedisSocketFactory, JedisClientConfig clientConfig) {
        this.client = new Client(jedisSocketFactory);
        this.initializeFromClientConfig(clientConfig);
    }

    public String toString() {
        return "BinaryJedis{" + this.client + '}';
    }

    public boolean isConnected() {
        return this.client.isConnected();
    }

    public boolean isBroken() {
        return this.client.isBroken();
    }

    public void connect() {
        this.client.connect();
    }

    public void disconnect() {
        this.client.disconnect();
    }

    public void resetState() {
        if (this.isConnected()) {
            if (this.transaction != null) {
                this.transaction.close();
            }
            if (this.pipeline != null) {
                this.pipeline.close();
            }
            this.client.resetState();
        }
        this.transaction = null;
        this.pipeline = null;
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public int getDB() {
        return this.client.getDB();
    }

    @Override
    public Boolean copy(byte[] srcKey, byte[] dstKey, int db, boolean replace) {
        this.checkIsInMultiOrPipeline();
        this.client.copy(srcKey, dstKey, db, replace);
        return BuilderFactory.BOOLEAN.build(this.client.getOne());
    }

    @Override
    public Boolean copy(byte[] srcKey, byte[] dstKey, boolean replace) {
        this.checkIsInMultiOrPipeline();
        this.client.copy(srcKey, dstKey, replace);
        return BuilderFactory.BOOLEAN.build(this.client.getOne());
    }

    @Override
    public String ping() {
        this.checkIsInMultiOrPipeline();
        this.client.ping();
        return this.client.getStatusCodeReply();
    }

    public byte[] ping(byte[] message) {
        this.checkIsInMultiOrPipeline();
        this.client.ping(message);
        return this.client.getBinaryBulkReply();
    }

    @Override
    public String set(byte[] key, byte[] value) {
        this.checkIsInMultiOrPipeline();
        this.client.set(key, value);
        return this.client.getStatusCodeReply();
    }

    @Override
    public String set(byte[] key, byte[] value, SetParams params) {
        this.checkIsInMultiOrPipeline();
        this.client.set(key, value, params);
        return this.client.getStatusCodeReply();
    }

    @Override
    public byte[] get(byte[] key) {
        this.checkIsInMultiOrPipeline();
        this.client.get(key);
        return this.client.getBinaryBulkReply();
    }

    @Override
    public byte[] getDel(byte[] key) {
        this.checkIsInMultiOrPipeline();
        this.client.getDel(key);
        return this.client.getBinaryBulkReply();
    }

    @Override
    public byte[] getEx(byte[] key, GetExParams params) {
        this.checkIsInMultiOrPipeline();
        this.client.getEx(key, params);
        return this.client.getBinaryBulkReply();
    }

    @Override
    public String quit() {
        this.checkIsInMultiOrPipeline();
        this.client.quit();
        String quitReturn = this.client.getStatusCodeReply();
        this.client.disconnect();
        return quitReturn;
    }

    @Override
    public Long exists(byte[] ... keys) {
        this.checkIsInMultiOrPipeline();
        this.client.exists(keys);
        return this.client.getIntegerReply();
    }

    @Override
    public Boolean exists(byte[] key) {
        this.checkIsInMultiOrPipeline();
        this.client.exists(new byte[][]{key});
        return this.client.getIntegerReply() == 1L;
    }

    @Override
    public Long del(byte[] ... keys) {
        this.checkIsInMultiOrPipeline();
        this.client.del(keys);
        return this.client.getIntegerReply();
    }

    @Override
    public Long del(byte[] key) {
        this.checkIsInMultiOrPipeline();
        this.client.del(new byte[][]{key});
        return this.client.getIntegerReply();
    }

    @Override
    public Long unlink(byte[] ... keys) {
        this.checkIsInMultiOrPipeline();
        this.client.unlink(keys);
        return this.client.getIntegerReply();
    }

    @Override
    public Long unlink(byte[] key) {
        this.checkIsInMultiOrPipeline();
        this.client.unlink(new byte[][]{key});
        return this.client.getIntegerReply();
    }

    @Override
    public String type(byte[] key) {
        this.checkIsInMultiOrPipeline();
        this.client.type(key);
        return this.client.getStatusCodeReply();
    }

    @Override
    public String flushDB() {
        this.checkIsInMultiOrPipeline();
        this.client.flushDB();
        return this.client.getStatusCodeReply();
    }

    @Override
    public String flushDB(FlushMode flushMode) {
        this.checkIsInMultiOrPipeline();
        this.client.flushDB(flushMode);
        return this.client.getStatusCodeReply();
    }

    @Override
    public Set<byte[]> keys(byte[] pattern) {
        this.checkIsInMultiOrPipeline();
        this.client.keys(pattern);
        return SetFromList.of(this.client.getBinaryMultiBulkReply());
    }

    @Override
    public byte[] randomBinaryKey() {
        this.checkIsInMultiOrPipeline();
        this.client.randomKey();
        return this.client.getBinaryBulkReply();
    }

    @Override
    public String rename(byte[] oldkey, byte[] newkey) {
        this.checkIsInMultiOrPipeline();
        this.client.rename(oldkey, newkey);
        return this.client.getStatusCodeReply();
    }

    @Override
    public Long renamenx(byte[] oldkey, byte[] newkey) {
        this.checkIsInMultiOrPipeline();
        this.client.renamenx(oldkey, newkey);
        return this.client.getIntegerReply();
    }

    @Override
    public Long dbSize() {
        this.checkIsInMultiOrPipeline();
        this.client.dbSize();
        return this.client.getIntegerReply();
    }

    @Override
    public Long expire(byte[] key, long seconds) {
        this.checkIsInMultiOrPipeline();
        this.client.expire(key, seconds);
        return this.client.getIntegerReply();
    }

    @Override
    public Long expireAt(byte[] key, long unixTime) {
        this.checkIsInMultiOrPipeline();
        this.client.expireAt(key, unixTime);
        return this.client.getIntegerReply();
    }

    @Override
    public Long ttl(byte[] key) {
        this.checkIsInMultiOrPipeline();
        this.client.ttl(key);
        return this.client.getIntegerReply();
    }

    @Override
    public Long touch(byte[] ... keys) {
        this.checkIsInMultiOrPipeline();
        this.client.touch(keys);
        return this.client.getIntegerReply();
    }

    @Override
    public Long touch(byte[] key) {
        this.checkIsInMultiOrPipeline();
        this.client.touch(new byte[][]{key});
        return this.client.getIntegerReply();
    }

    @Override
    public String select(int index) {
        this.checkIsInMultiOrPipeline();
        this.client.select(index);
        String statusCodeReply = this.client.getStatusCodeReply();
        this.client.setDb(index);
        return statusCodeReply;
    }

    @Override
    public String swapDB(int index1, int index2) {
        this.checkIsInMultiOrPipeline();
        this.client.swapDB(index1, index2);
        return this.client.getStatusCodeReply();
    }

    @Override
    public Long move(byte[] key, int dbIndex) {
        this.checkIsInMultiOrPipeline();
        this.client.move(key, dbIndex);
        return this.client.getIntegerReply();
    }

    @Override
    public String flushAll() {
        this.checkIsInMultiOrPipeline();
        this.client.flushAll();
        return this.client.getStatusCodeReply();
    }

    @Override
    public String flushAll(FlushMode flushMode) {
        this.checkIsInMultiOrPipeline();
        this.client.flushAll(flushMode);
        return this.client.getStatusCodeReply();
    }

    @Override
    public byte[] getSet(byte[] key, byte[] value) {
        this.checkIsInMultiOrPipeline();
        this.client.getSet(key, value);
        return this.client.getBinaryBulkReply();
    }

    @Override
    public List<byte[]> mget(byte[] ... keys) {
        this.checkIsInMultiOrPipeline();
        this.client.mget(keys);
        return this.client.getBinaryMultiBulkReply();
    }

    @Override
    public Long setnx(byte[] key, byte[] value) {
        this.checkIsInMultiOrPipeline();
        this.client.setnx(key, value);
        return this.client.getIntegerReply();
    }

    @Override
    public String setex(byte[] key, long seconds, byte[] value) {
        this.checkIsInMultiOrPipeline();
        this.client.setex(key, seconds, value);
        return this.client.getStatusCodeReply();
    }

    @Override
    public String mset(byte[] ... keysvalues) {
        this.checkIsInMultiOrPipeline();
        this.client.mset(keysvalues);
        return this.client.getStatusCodeReply();
    }

    @Override
    public Long msetnx(byte[] ... keysvalues) {
        this.checkIsInMultiOrPipeline();
        this.client.msetnx(keysvalues);
        return this.client.getIntegerReply();
    }

    @Override
    public Long decrBy(byte[] key, long decrement) {
        this.checkIsInMultiOrPipeline();
        this.client.decrBy(key, decrement);
        return this.client.getIntegerReply();
    }

    @Override
    public Long decr(byte[] key) {
        this.checkIsInMultiOrPipeline();
        this.client.decr(key);
        return this.client.getIntegerReply();
    }

    @Override
    public Long incrBy(byte[] key, long increment) {
        this.checkIsInMultiOrPipeline();
        this.client.incrBy(key, increment);
        return this.client.getIntegerReply();
    }

    @Override
    public Double incrByFloat(byte[] key, double increment) {
        this.checkIsInMultiOrPipeline();
        this.client.incrByFloat(key, increment);
        return BuilderFactory.DOUBLE.build(this.client.getOne());
    }

    @Override
    public Long incr(byte[] key) {
        this.checkIsInMultiOrPipeline();
        this.client.incr(key);
        return this.client.getIntegerReply();
    }

    @Override
    public Long append(byte[] key, byte[] value) {
        this.checkIsInMultiOrPipeline();
        this.client.append(key, value);
        return this.client.getIntegerReply();
    }

    @Override
    public byte[] substr(byte[] key, int start, int end) {
        this.checkIsInMultiOrPipeline();
        this.client.substr(key, start, end);
        return this.client.getBinaryBulkReply();
    }

    @Override
    public Long hset(byte[] key, byte[] field, byte[] value) {
        this.checkIsInMultiOrPipeline();
        this.client.hset(key, field, value);
        return this.client.getIntegerReply();
    }

    @Override
    public Long hset(byte[] key, Map<byte[], byte[]> hash) {
        this.checkIsInMultiOrPipeline();
        this.client.hset(key, hash);
        return this.client.getIntegerReply();
    }

    @Override
    public byte[] hget(byte[] key, byte[] field) {
        this.checkIsInMultiOrPipeline();
        this.client.hget(key, field);
        return this.client.getBinaryBulkReply();
    }

    @Override
    public Long hsetnx(byte[] key, byte[] field, byte[] value) {
        this.checkIsInMultiOrPipeline();
        this.client.hsetnx(key, field, value);
        return this.client.getIntegerReply();
    }

    @Override
    public String hmset(byte[] key, Map<byte[], byte[]> hash) {
        this.checkIsInMultiOrPipeline();
        this.client.hmset(key, hash);
        return this.client.getStatusCodeReply();
    }

    @Override
    public List<byte[]> hmget(byte[] key, byte[] ... fields) {
        this.checkIsInMultiOrPipeline();
        this.client.hmget(key, fields);
        return this.client.getBinaryMultiBulkReply();
    }

    @Override
    public Long hincrBy(byte[] key, byte[] field, long value) {
        this.checkIsInMultiOrPipeline();
        this.client.hincrBy(key, field, value);
        return this.client.getIntegerReply();
    }

    @Override
    public Double hincrByFloat(byte[] key, byte[] field, double value) {
        this.checkIsInMultiOrPipeline();
        this.client.hincrByFloat(key, field, value);
        return BuilderFactory.DOUBLE.build(this.client.getOne());
    }

    @Override
    public Boolean hexists(byte[] key, byte[] field) {
        this.checkIsInMultiOrPipeline();
        this.client.hexists(key, field);
        return this.client.getIntegerReply() == 1L;
    }

    @Override
    public Long hdel(byte[] key, byte[] ... fields) {
        this.checkIsInMultiOrPipeline();
        this.client.hdel(key, fields);
        return this.client.getIntegerReply();
    }

    @Override
    public Long hlen(byte[] key) {
        this.checkIsInMultiOrPipeline();
        this.client.hlen(key);
        return this.client.getIntegerReply();
    }

    @Override
    public Set<byte[]> hkeys(byte[] key) {
        this.checkIsInMultiOrPipeline();
        this.client.hkeys(key);
        return SetFromList.of(this.client.getBinaryMultiBulkReply());
    }

    @Override
    public List<byte[]> hvals(byte[] key) {
        this.checkIsInMultiOrPipeline();
        this.client.hvals(key);
        return this.client.getBinaryMultiBulkReply();
    }

    @Override
    public Map<byte[], byte[]> hgetAll(byte[] key) {
        this.checkIsInMultiOrPipeline();
        this.client.hgetAll(key);
        return BuilderFactory.BYTE_ARRAY_MAP.build(this.client.getBinaryMultiBulkReply());
    }

    @Override
    public byte[] hrandfield(byte[] key) {
        this.checkIsInMultiOrPipeline();
        this.client.hrandfield(key);
        return this.client.getBinaryBulkReply();
    }

    @Override
    public List<byte[]> hrandfield(byte[] key, long count) {
        this.checkIsInMultiOrPipeline();
        this.client.hrandfield(key, count);
        return this.client.getBinaryMultiBulkReply();
    }

    @Override
    public Map<byte[], byte[]> hrandfieldWithValues(byte[] key, long count) {
        this.checkIsInMultiOrPipeline();
        this.client.hrandfieldWithValues(key, count);
        return BuilderFactory.BYTE_ARRAY_MAP.build(this.client.getBinaryMultiBulkReply());
    }

    @Override
    public Long rpush(byte[] key, byte[] ... strings) {
        this.checkIsInMultiOrPipeline();
        this.client.rpush(key, strings);
        return this.client.getIntegerReply();
    }

    @Override
    public Long lpush(byte[] key, byte[] ... strings) {
        this.checkIsInMultiOrPipeline();
        this.client.lpush(key, strings);
        return this.client.getIntegerReply();
    }

    @Override
    public Long llen(byte[] key) {
        this.checkIsInMultiOrPipeline();
        this.client.llen(key);
        return this.client.getIntegerReply();
    }

    @Override
    public List<byte[]> lrange(byte[] key, long start, long stop) {
        this.checkIsInMultiOrPipeline();
        this.client.lrange(key, start, stop);
        return this.client.getBinaryMultiBulkReply();
    }

    @Override
    public String ltrim(byte[] key, long start, long stop) {
        this.checkIsInMultiOrPipeline();
        this.client.ltrim(key, start, stop);
        return this.client.getStatusCodeReply();
    }

    @Override
    public byte[] lindex(byte[] key, long index) {
        this.checkIsInMultiOrPipeline();
        this.client.lindex(key, index);
        return this.client.getBinaryBulkReply();
    }

    @Override
    public String lset(byte[] key, long index, byte[] value) {
        this.checkIsInMultiOrPipeline();
        this.client.lset(key, index, value);
        return this.client.getStatusCodeReply();
    }

    @Override
    public Long lrem(byte[] key, long count, byte[] value) {
        this.checkIsInMultiOrPipeline();
        this.client.lrem(key, count, value);
        return this.client.getIntegerReply();
    }

    @Override
    public byte[] lpop(byte[] key) {
        this.checkIsInMultiOrPipeline();
        this.client.lpop(key);
        return this.client.getBinaryBulkReply();
    }

    @Override
    public List<byte[]> lpop(byte[] key, int count) {
        this.checkIsInMultiOrPipeline();
        this.client.lpop(key, count);
        return this.client.getBinaryMultiBulkReply();
    }

    @Override
    public Long lpos(byte[] key, byte[] element) {
        this.checkIsInMultiOrPipeline();
        this.client.lpos(key, element);
        return this.client.getIntegerReply();
    }

    @Override
    public Long lpos(byte[] key, byte[] element, LPosParams params) {
        this.checkIsInMultiOrPipeline();
        this.client.lpos(key, element, params);
        return this.client.getIntegerReply();
    }

    @Override
    public List<Long> lpos(byte[] key, byte[] element, LPosParams params, long count) {
        this.checkIsInMultiOrPipeline();
        this.client.lpos(key, element, params, count);
        return this.client.getIntegerMultiBulkReply();
    }

    @Override
    public byte[] rpop(byte[] key) {
        this.checkIsInMultiOrPipeline();
        this.client.rpop(key);
        return this.client.getBinaryBulkReply();
    }

    @Override
    public List<byte[]> rpop(byte[] key, int count) {
        this.checkIsInMultiOrPipeline();
        this.client.rpop(key, count);
        return this.client.getBinaryMultiBulkReply();
    }

    @Override
    public byte[] rpoplpush(byte[] srckey, byte[] dstkey) {
        this.checkIsInMultiOrPipeline();
        this.client.rpoplpush(srckey, dstkey);
        return this.client.getBinaryBulkReply();
    }

    @Override
    public Long sadd(byte[] key, byte[] ... members) {
        this.checkIsInMultiOrPipeline();
        this.client.sadd(key, members);
        return this.client.getIntegerReply();
    }

    @Override
    public Set<byte[]> smembers(byte[] key) {
        this.checkIsInMultiOrPipeline();
        this.client.smembers(key);
        return SetFromList.of(this.client.getBinaryMultiBulkReply());
    }

    @Override
    public Long srem(byte[] key, byte[] ... member) {
        this.checkIsInMultiOrPipeline();
        this.client.srem(key, member);
        return this.client.getIntegerReply();
    }

    @Override
    public byte[] spop(byte[] key) {
        this.checkIsInMultiOrPipeline();
        this.client.spop(key);
        return this.client.getBinaryBulkReply();
    }

    @Override
    public Set<byte[]> spop(byte[] key, long count) {
        this.checkIsInMultiOrPipeline();
        this.client.spop(key, count);
        List<byte[]> members = this.client.getBinaryMultiBulkReply();
        if (members == null) {
            return null;
        }
        return SetFromList.of(members);
    }

    @Override
    public Long smove(byte[] srckey, byte[] dstkey, byte[] member) {
        this.checkIsInMultiOrPipeline();
        this.client.smove(srckey, dstkey, member);
        return this.client.getIntegerReply();
    }

    @Override
    public Long scard(byte[] key) {
        this.checkIsInMultiOrPipeline();
        this.client.scard(key);
        return this.client.getIntegerReply();
    }

    @Override
    public Boolean sismember(byte[] key, byte[] member) {
        this.checkIsInMultiOrPipeline();
        this.client.sismember(key, member);
        return this.client.getIntegerReply() == 1L;
    }

    @Override
    public List<Boolean> smismember(byte[] key, byte[] ... members) {
        this.checkIsInMultiOrPipeline();
        this.client.smismember(key, members);
        return BuilderFactory.BOOLEAN_LIST.build(this.client.getIntegerMultiBulkReply());
    }

    @Override
    public Set<byte[]> sinter(byte[] ... keys) {
        this.checkIsInMultiOrPipeline();
        this.client.sinter(keys);
        return SetFromList.of(this.client.getBinaryMultiBulkReply());
    }

    @Override
    public Long sinterstore(byte[] dstkey, byte[] ... keys) {
        this.checkIsInMultiOrPipeline();
        this.client.sinterstore(dstkey, keys);
        return this.client.getIntegerReply();
    }

    @Override
    public Set<byte[]> sunion(byte[] ... keys) {
        this.checkIsInMultiOrPipeline();
        this.client.sunion(keys);
        return SetFromList.of(this.client.getBinaryMultiBulkReply());
    }

    @Override
    public Long sunionstore(byte[] dstkey, byte[] ... keys) {
        this.checkIsInMultiOrPipeline();
        this.client.sunionstore(dstkey, keys);
        return this.client.getIntegerReply();
    }

    @Override
    public Set<byte[]> sdiff(byte[] ... keys) {
        this.checkIsInMultiOrPipeline();
        this.client.sdiff(keys);
        return SetFromList.of(this.client.getBinaryMultiBulkReply());
    }

    @Override
    public Long sdiffstore(byte[] dstkey, byte[] ... keys) {
        this.checkIsInMultiOrPipeline();
        this.client.sdiffstore(dstkey, keys);
        return this.client.getIntegerReply();
    }

    @Override
    public byte[] srandmember(byte[] key) {
        this.checkIsInMultiOrPipeline();
        this.client.srandmember(key);
        return this.client.getBinaryBulkReply();
    }

    @Override
    public List<byte[]> srandmember(byte[] key, int count) {
        this.checkIsInMultiOrPipeline();
        this.client.srandmember(key, count);
        return this.client.getBinaryMultiBulkReply();
    }

    @Override
    public Long zadd(byte[] key, double score, byte[] member) {
        this.checkIsInMultiOrPipeline();
        this.client.zadd(key, score, member);
        return this.client.getIntegerReply();
    }

    @Override
    public Long zadd(byte[] key, double score, byte[] member, ZAddParams params) {
        this.checkIsInMultiOrPipeline();
        this.client.zadd(key, score, member, params);
        return this.client.getIntegerReply();
    }

    @Override
    public Long zadd(byte[] key, Map<byte[], Double> scoreMembers) {
        this.checkIsInMultiOrPipeline();
        this.client.zadd(key, scoreMembers);
        return this.client.getIntegerReply();
    }

    @Override
    public Long zadd(byte[] key, Map<byte[], Double> scoreMembers, ZAddParams params) {
        this.checkIsInMultiOrPipeline();
        this.client.zadd(key, scoreMembers, params);
        return this.client.getIntegerReply();
    }

    @Override
    public Double zaddIncr(byte[] key, double score, byte[] member, ZAddParams params) {
        this.checkIsInMultiOrPipeline();
        this.client.zaddIncr(key, score, member, params);
        return BuilderFactory.DOUBLE.build(this.client.getOne());
    }

    @Override
    public Set<byte[]> zrange(byte[] key, long start, long stop) {
        this.checkIsInMultiOrPipeline();
        this.client.zrange(key, start, stop);
        return SetFromList.of(this.client.getBinaryMultiBulkReply());
    }

    @Override
    public Long zrem(byte[] key, byte[] ... members) {
        this.checkIsInMultiOrPipeline();
        this.client.zrem(key, members);
        return this.client.getIntegerReply();
    }

    @Override
    public Double zincrby(byte[] key, double increment, byte[] member) {
        this.checkIsInMultiOrPipeline();
        this.client.zincrby(key, increment, member);
        return BuilderFactory.DOUBLE.build(this.client.getOne());
    }

    @Override
    public Double zincrby(byte[] key, double increment, byte[] member, ZIncrByParams params) {
        this.checkIsInMultiOrPipeline();
        this.client.zincrby(key, increment, member, params);
        return BuilderFactory.DOUBLE.build(this.client.getOne());
    }

    @Override
    public Long zrank(byte[] key, byte[] member) {
        this.checkIsInMultiOrPipeline();
        this.client.zrank(key, member);
        return this.client.getIntegerReply();
    }

    @Override
    public Long zrevrank(byte[] key, byte[] member) {
        this.checkIsInMultiOrPipeline();
        this.client.zrevrank(key, member);
        return this.client.getIntegerReply();
    }

    @Override
    public Set<byte[]> zrevrange(byte[] key, long start, long stop) {
        this.checkIsInMultiOrPipeline();
        this.client.zrevrange(key, start, stop);
        return SetFromList.of(this.client.getBinaryMultiBulkReply());
    }

    @Override
    public Set<Tuple> zrangeWithScores(byte[] key, long start, long stop) {
        this.checkIsInMultiOrPipeline();
        this.client.zrangeWithScores(key, start, stop);
        return this.getTupledSet();
    }

    @Override
    public Set<Tuple> zrevrangeWithScores(byte[] key, long start, long stop) {
        this.checkIsInMultiOrPipeline();
        this.client.zrevrangeWithScores(key, start, stop);
        return this.getTupledSet();
    }

    @Override
    public byte[] zrandmember(byte[] key) {
        this.checkIsInMultiOrPipeline();
        this.client.zrandmember(key);
        return this.client.getBinaryBulkReply();
    }

    @Override
    public Set<byte[]> zrandmember(byte[] key, long count) {
        this.checkIsInMultiOrPipeline();
        this.client.zrandmember(key, count);
        return SetFromList.of(this.client.getBinaryMultiBulkReply());
    }

    @Override
    public Set<Tuple> zrandmemberWithScores(byte[] key, long count) {
        this.checkIsInMultiOrPipeline();
        this.client.zrandmemberWithScores(key, count);
        return this.getTupledSet();
    }

    @Override
    public Long zcard(byte[] key) {
        this.checkIsInMultiOrPipeline();
        this.client.zcard(key);
        return this.client.getIntegerReply();
    }

    @Override
    public Double zscore(byte[] key, byte[] member) {
        this.checkIsInMultiOrPipeline();
        this.client.zscore(key, member);
        return BuilderFactory.DOUBLE.build(this.client.getOne());
    }

    @Override
    public List<Double> zmscore(byte[] key, byte[] ... members) {
        this.checkIsInMultiOrPipeline();
        this.client.zmscore(key, members);
        return BuilderFactory.DOUBLE_LIST.build(this.client.getBinaryMultiBulkReply());
    }

    @Override
    public Tuple zpopmax(byte[] key) {
        this.checkIsInMultiOrPipeline();
        this.client.zpopmax(key);
        return BuilderFactory.TUPLE.build(this.client.getBinaryMultiBulkReply());
    }

    @Override
    public Set<Tuple> zpopmax(byte[] key, int count) {
        this.checkIsInMultiOrPipeline();
        this.client.zpopmax(key, count);
        return this.getTupledSet();
    }

    @Override
    public Tuple zpopmin(byte[] key) {
        this.checkIsInMultiOrPipeline();
        this.client.zpopmin(key);
        return BuilderFactory.TUPLE.build(this.client.getBinaryMultiBulkReply());
    }

    @Override
    public Set<Tuple> zpopmin(byte[] key, int count) {
        this.checkIsInMultiOrPipeline();
        this.client.zpopmin(key, (long)count);
        return this.getTupledSet();
    }

    public Transaction multi() {
        this.client.multi();
        this.client.getOne();
        this.transaction = new Transaction(this.client);
        return this.transaction;
    }

    protected void checkIsInMultiOrPipeline() {
        if (this.client.isInMulti()) {
            throw new JedisDataException("Cannot use Jedis when in Multi. Please use Transaction or reset jedis state.");
        }
        if (this.pipeline != null && this.pipeline.hasPipelinedResponse()) {
            throw new JedisDataException("Cannot use Jedis when in Pipeline. Please use Pipeline or reset jedis state .");
        }
    }

    @Override
    public String watch(byte[] ... keys) {
        this.checkIsInMultiOrPipeline();
        this.client.watch(keys);
        return this.client.getStatusCodeReply();
    }

    @Override
    public String unwatch() {
        this.checkIsInMultiOrPipeline();
        this.client.unwatch();
        return this.client.getStatusCodeReply();
    }

    @Override
    public List<byte[]> sort(byte[] key) {
        this.checkIsInMultiOrPipeline();
        this.client.sort(key);
        return this.client.getBinaryMultiBulkReply();
    }

    @Override
    public List<byte[]> sort(byte[] key, SortingParams sortingParameters) {
        this.checkIsInMultiOrPipeline();
        this.client.sort(key, sortingParameters);
        return this.client.getBinaryMultiBulkReply();
    }

    @Override
    public Long sort(byte[] key, SortingParams sortingParameters, byte[] dstkey) {
        this.checkIsInMultiOrPipeline();
        this.client.sort(key, sortingParameters, dstkey);
        return this.client.getIntegerReply();
    }

    @Override
    public Long sort(byte[] key, byte[] dstkey) {
        this.checkIsInMultiOrPipeline();
        this.client.sort(key, dstkey);
        return this.client.getIntegerReply();
    }

    @Override
    public byte[] lmove(byte[] srcKey, byte[] dstKey, ListDirection from, ListDirection to) {
        this.checkIsInMultiOrPipeline();
        this.client.lmove(srcKey, dstKey, from, to);
        return this.client.getBinaryBulkReply();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] blmove(byte[] srcKey, byte[] dstKey, ListDirection from, ListDirection to, double timeout) {
        this.checkIsInMultiOrPipeline();
        this.client.blmove(srcKey, dstKey, from, to, timeout);
        this.client.setTimeoutInfinite();
        try {
            byte[] byArray = this.client.getBinaryBulkReply();
            return byArray;
        }
        finally {
            this.client.rollbackTimeout();
        }
    }

    @Override
    public List<byte[]> blpop(int timeout, byte[] ... keys) {
        return this.blpop(this.getKeysAndTimeout(timeout, keys));
    }

    @Override
    public List<byte[]> blpop(double timeout, byte[] ... keys) {
        return this.blpop(this.getKeysAndTimeout(timeout, keys));
    }

    @Override
    public List<byte[]> brpop(int timeout, byte[] ... keys) {
        return this.brpop(this.getKeysAndTimeout(timeout, keys));
    }

    @Override
    public List<byte[]> brpop(double timeout, byte[] ... keys) {
        return this.brpop(this.getKeysAndTimeout(timeout, keys));
    }

    @Override
    public List<byte[]> blpop(byte[] ... args) {
        this.checkIsInMultiOrPipeline();
        this.client.blpop(args);
        this.client.setTimeoutInfinite();
        try {
            List<byte[]> list = this.client.getBinaryMultiBulkReply();
            return list;
        }
        finally {
            this.client.rollbackTimeout();
        }
    }

    @Override
    public List<byte[]> brpop(byte[] ... args) {
        this.checkIsInMultiOrPipeline();
        this.client.brpop(args);
        this.client.setTimeoutInfinite();
        try {
            List<byte[]> list = this.client.getBinaryMultiBulkReply();
            return list;
        }
        finally {
            this.client.rollbackTimeout();
        }
    }

    private byte[][] getKeysAndTimeout(int timeout, byte[][] keys) {
        int size = keys.length;
        byte[][] args = new byte[size + 1][];
        System.arraycopy(keys, 0, args, 0, size);
        args[size] = Protocol.toByteArray(timeout);
        return args;
    }

    private byte[][] getKeysAndTimeout(double timeout, byte[][] keys) {
        int size = keys.length;
        byte[][] args = new byte[size + 1][];
        System.arraycopy(keys, 0, args, 0, size);
        args[size] = Protocol.toByteArray(timeout);
        return args;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<byte[]> bzpopmax(double timeout, byte[] ... keys) {
        this.checkIsInMultiOrPipeline();
        this.client.bzpopmax(timeout, keys);
        this.client.setTimeoutInfinite();
        try {
            List<byte[]> list = this.client.getBinaryMultiBulkReply();
            return list;
        }
        finally {
            this.client.rollbackTimeout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<byte[]> bzpopmin(double timeout, byte[] ... keys) {
        this.checkIsInMultiOrPipeline();
        this.client.bzpopmin(timeout, keys);
        this.client.setTimeoutInfinite();
        try {
            List<byte[]> list = this.client.getBinaryMultiBulkReply();
            return list;
        }
        finally {
            this.client.rollbackTimeout();
        }
    }

    @Override
    public String auth(String password) {
        this.checkIsInMultiOrPipeline();
        this.client.auth(password);
        return this.client.getStatusCodeReply();
    }

    @Override
    public String auth(String user, String password) {
        this.checkIsInMultiOrPipeline();
        this.client.auth(user, password);
        return this.client.getStatusCodeReply();
    }

    public Pipeline pipelined() {
        this.pipeline = new Pipeline();
        this.pipeline.setClient(this.client);
        return this.pipeline;
    }

    @Override
    public Long zcount(byte[] key, double min, double max) {
        this.checkIsInMultiOrPipeline();
        this.client.zcount(key, min, max);
        return this.client.getIntegerReply();
    }

    @Override
    public Long zcount(byte[] key, byte[] min, byte[] max) {
        this.checkIsInMultiOrPipeline();
        this.client.zcount(key, min, max);
        return this.client.getIntegerReply();
    }

    @Override
    public Set<byte[]> zdiff(byte[] ... keys) {
        this.checkIsInMultiOrPipeline();
        this.client.zdiff(keys);
        return BuilderFactory.BYTE_ARRAY_ZSET.build(this.client.getBinaryMultiBulkReply());
    }

    @Override
    public Set<Tuple> zdiffWithScores(byte[] ... keys) {
        this.checkIsInMultiOrPipeline();
        this.client.zdiffWithScores(keys);
        return this.getTupledSet();
    }

    @Override
    public Long zdiffStore(byte[] dstkey, byte[] ... keys) {
        this.checkIsInMultiOrPipeline();
        this.client.zdiffStore(dstkey, keys);
        return this.client.getIntegerReply();
    }

    @Override
    public Set<byte[]> zrangeByScore(byte[] key, double min, double max) {
        this.checkIsInMultiOrPipeline();
        this.client.zrangeByScore(key, min, max);
        return SetFromList.of(this.client.getBinaryMultiBulkReply());
    }

    @Override
    public Set<byte[]> zrangeByScore(byte[] key, byte[] min, byte[] max) {
        this.checkIsInMultiOrPipeline();
        this.client.zrangeByScore(key, min, max);
        return SetFromList.of(this.client.getBinaryMultiBulkReply());
    }

    @Override
    public Set<byte[]> zrangeByScore(byte[] key, double min, double max, int offset, int count) {
        this.checkIsInMultiOrPipeline();
        this.client.zrangeByScore(key, min, max, offset, count);
        return SetFromList.of(this.client.getBinaryMultiBulkReply());
    }

    @Override
    public Set<byte[]> zrangeByScore(byte[] key, byte[] min, byte[] max, int offset, int count) {
        this.checkIsInMultiOrPipeline();
        this.client.zrangeByScore(key, min, max, offset, count);
        return SetFromList.of(this.client.getBinaryMultiBulkReply());
    }

    @Override
    public Set<Tuple> zrangeByScoreWithScores(byte[] key, double min, double max) {
        this.checkIsInMultiOrPipeline();
        this.client.zrangeByScoreWithScores(key, min, max);
        return this.getTupledSet();
    }

    @Override
    public Set<Tuple> zrangeByScoreWithScores(byte[] key, byte[] min, byte[] max) {
        this.checkIsInMultiOrPipeline();
        this.client.zrangeByScoreWithScores(key, min, max);
        return this.getTupledSet();
    }

    @Override
    public Set<Tuple> zrangeByScoreWithScores(byte[] key, double min, double max, int offset, int count) {
        this.checkIsInMultiOrPipeline();
        this.client.zrangeByScoreWithScores(key, min, max, offset, count);
        return this.getTupledSet();
    }

    @Override
    public Set<Tuple> zrangeByScoreWithScores(byte[] key, byte[] min, byte[] max, int offset, int count) {
        this.checkIsInMultiOrPipeline();
        this.client.zrangeByScoreWithScores(key, min, max, offset, count);
        return this.getTupledSet();
    }

    protected Set<Tuple> getTupledSet() {
        List<byte[]> membersWithScores = this.client.getBinaryMultiBulkReply();
        if (membersWithScores == null) {
            return null;
        }
        if (membersWithScores.isEmpty()) {
            return Collections.emptySet();
        }
        LinkedHashSet<Tuple> set = new LinkedHashSet<Tuple>(membersWithScores.size() / 2, 1.0f);
        Iterator<byte[]> iterator = membersWithScores.iterator();
        while (iterator.hasNext()) {
            set.add(new Tuple(iterator.next(), BuilderFactory.DOUBLE.build(iterator.next())));
        }
        return set;
    }

    @Override
    public Set<byte[]> zrevrangeByScore(byte[] key, double max, double min) {
        this.checkIsInMultiOrPipeline();
        this.client.zrevrangeByScore(key, max, min);
        return SetFromList.of(this.client.getBinaryMultiBulkReply());
    }

    @Override
    public Set<byte[]> zrevrangeByScore(byte[] key, byte[] max, byte[] min) {
        this.checkIsInMultiOrPipeline();
        this.client.zrevrangeByScore(key, max, min);
        return SetFromList.of(this.client.getBinaryMultiBulkReply());
    }

    @Override
    public Set<byte[]> zrevrangeByScore(byte[] key, double max, double min, int offset, int count) {
        this.checkIsInMultiOrPipeline();
        this.client.zrevrangeByScore(key, max, min, offset, count);
        return SetFromList.of(this.client.getBinaryMultiBulkReply());
    }

    @Override
    public Set<byte[]> zrevrangeByScore(byte[] key, byte[] max, byte[] min, int offset, int count) {
        this.checkIsInMultiOrPipeline();
        this.client.zrevrangeByScore(key, max, min, offset, count);
        return SetFromList.of(this.client.getBinaryMultiBulkReply());
    }

    @Override
    public Set<Tuple> zrevrangeByScoreWithScores(byte[] key, double max, double min) {
        this.checkIsInMultiOrPipeline();
        this.client.zrevrangeByScoreWithScores(key, max, min);
        return this.getTupledSet();
    }

    @Override
    public Set<Tuple> zrevrangeByScoreWithScores(byte[] key, double max, double min, int offset, int count) {
        this.checkIsInMultiOrPipeline();
        this.client.zrevrangeByScoreWithScores(key, max, min, offset, count);
        return this.getTupledSet();
    }

    @Override
    public Set<Tuple> zrevrangeByScoreWithScores(byte[] key, byte[] max, byte[] min) {
        this.checkIsInMultiOrPipeline();
        this.client.zrevrangeByScoreWithScores(key, max, min);
        return this.getTupledSet();
    }

    @Override
    public Set<Tuple> zrevrangeByScoreWithScores(byte[] key, byte[] max, byte[] min, int offset, int count) {
        this.checkIsInMultiOrPipeline();
        this.client.zrevrangeByScoreWithScores(key, max, min, offset, count);
        return this.getTupledSet();
    }

    @Override
    public Long zremrangeByRank(byte[] key, long start, long stop) {
        this.checkIsInMultiOrPipeline();
        this.client.zremrangeByRank(key, start, stop);
        return this.client.getIntegerReply();
    }

    @Override
    public Long zremrangeByScore(byte[] key, double min, double max) {
        this.checkIsInMultiOrPipeline();
        this.client.zremrangeByScore(key, min, max);
        return this.client.getIntegerReply();
    }

    @Override
    public Long zremrangeByScore(byte[] key, byte[] min, byte[] max) {
        this.checkIsInMultiOrPipeline();
        this.client.zremrangeByScore(key, min, max);
        return this.client.getIntegerReply();
    }

    @Override
    public Set<byte[]> zunion(ZParams params, byte[] ... keys) {
        this.checkIsInMultiOrPipeline();
        this.client.zunion(params, keys);
        return BuilderFactory.BYTE_ARRAY_ZSET.build(this.client.getBinaryMultiBulkReply());
    }

    @Override
    public Set<Tuple> zunionWithScores(ZParams params, byte[] ... keys) {
        this.checkIsInMultiOrPipeline();
        this.client.zunionWithScores(params, keys);
        return BuilderFactory.TUPLE_ZSET.build(this.client.getBinaryMultiBulkReply());
    }

    @Override
    public Long zunionstore(byte[] dstkey, byte[] ... sets) {
        this.checkIsInMultiOrPipeline();
        this.client.zunionstore(dstkey, sets);
        return this.client.getIntegerReply();
    }

    @Override
    public Long zunionstore(byte[] dstkey, ZParams params, byte[] ... sets) {
        this.checkIsInMultiOrPipeline();
        this.client.zunionstore(dstkey, params, sets);
        return this.client.getIntegerReply();
    }

    @Override
    public Set<byte[]> zinter(ZParams params, byte[] ... keys) {
        this.checkIsInMultiOrPipeline();
        this.client.zinter(params, keys);
        return BuilderFactory.BYTE_ARRAY_ZSET.build(this.client.getBinaryMultiBulkReply());
    }

    @Override
    public Set<Tuple> zinterWithScores(ZParams params, byte[] ... keys) {
        this.checkIsInMultiOrPipeline();
        this.client.zinterWithScores(params, keys);
        return BuilderFactory.TUPLE_ZSET.build(this.client.getBinaryMultiBulkReply());
    }

    @Override
    public Long zinterstore(byte[] dstkey, byte[] ... sets) {
        this.checkIsInMultiOrPipeline();
        this.client.zinterstore(dstkey, sets);
        return this.client.getIntegerReply();
    }

    @Override
    public Long zinterstore(byte[] dstkey, ZParams params, byte[] ... sets) {
        this.checkIsInMultiOrPipeline();
        this.client.zinterstore(dstkey, params, sets);
        return this.client.getIntegerReply();
    }

    @Override
    public Long zlexcount(byte[] key, byte[] min, byte[] max) {
        this.checkIsInMultiOrPipeline();
        this.client.zlexcount(key, min, max);
        return this.client.getIntegerReply();
    }

    @Override
    public Set<byte[]> zrangeByLex(byte[] key, byte[] min, byte[] max) {
        this.checkIsInMultiOrPipeline();
        this.client.zrangeByLex(key, min, max);
        return SetFromList.of(this.client.getBinaryMultiBulkReply());
    }

    @Override
    public Set<byte[]> zrangeByLex(byte[] key, byte[] min, byte[] max, int offset, int count) {
        this.checkIsInMultiOrPipeline();
        this.client.zrangeByLex(key, min, max, offset, count);
        return SetFromList.of(this.client.getBinaryMultiBulkReply());
    }

    @Override
    public Set<byte[]> zrevrangeByLex(byte[] key, byte[] max, byte[] min) {
        this.checkIsInMultiOrPipeline();
        this.client.zrevrangeByLex(key, max, min);
        return SetFromList.of(this.client.getBinaryMultiBulkReply());
    }

    @Override
    public Set<byte[]> zrevrangeByLex(byte[] key, byte[] max, byte[] min, int offset, int count) {
        this.checkIsInMultiOrPipeline();
        this.client.zrevrangeByLex(key, max, min, offset, count);
        return SetFromList.of(this.client.getBinaryMultiBulkReply());
    }

    @Override
    public Long zremrangeByLex(byte[] key, byte[] min, byte[] max) {
        this.checkIsInMultiOrPipeline();
        this.client.zremrangeByLex(key, min, max);
        return this.client.getIntegerReply();
    }

    @Override
    public String save() {
        this.client.save();
        return this.client.getStatusCodeReply();
    }

    @Override
    public String bgsave() {
        this.client.bgsave();
        return this.client.getStatusCodeReply();
    }

    @Override
    public String bgrewriteaof() {
        this.client.bgrewriteaof();
        return this.client.getStatusCodeReply();
    }

    @Override
    public Long lastsave() {
        this.client.lastsave();
        return this.client.getIntegerReply();
    }

    @Override
    public String shutdown() throws JedisException {
        this.client.shutdown();
        try {
            String status = this.client.getStatusCodeReply();
            throw new JedisException(status);
        }
        catch (JedisConnectionException jce) {
            String status = null;
            return status;
        }
    }

    @Override
    public void shutdown(SaveMode saveMode) throws JedisException {
        this.client.shutdown(saveMode);
        try {
            throw new JedisException(this.client.getStatusCodeReply());
        }
        catch (JedisConnectionException jedisConnectionException) {
            return;
        }
    }

    @Override
    public String info() {
        this.client.info();
        return this.client.getBulkReply();
    }

    @Override
    public String info(String section) {
        this.client.info(section);
        return this.client.getBulkReply();
    }

    public void monitor(JedisMonitor jedisMonitor) {
        this.client.monitor();
        this.client.getStatusCodeReply();
        jedisMonitor.proceed(this.client);
    }

    @Override
    public String slaveof(String host, int port) {
        this.client.slaveof(host, port);
        return this.client.getStatusCodeReply();
    }

    @Override
    public String slaveofNoOne() {
        this.client.slaveofNoOne();
        return this.client.getStatusCodeReply();
    }

    @Override
    public List<Object> roleBinary() {
        this.checkIsInMultiOrPipeline();
        this.client.role();
        return BuilderFactory.RAW_OBJECT_LIST.build(this.client.getOne());
    }

    @Override
    public List<byte[]> configGet(byte[] pattern) {
        this.checkIsInMultiOrPipeline();
        this.client.configGet(pattern);
        return this.client.getBinaryMultiBulkReply();
    }

    @Override
    public String configResetStat() {
        this.checkIsInMultiOrPipeline();
        this.client.configResetStat();
        return this.client.getStatusCodeReply();
    }

    @Override
    public String configRewrite() {
        this.checkIsInMultiOrPipeline();
        this.client.configRewrite();
        return this.client.getStatusCodeReply();
    }

    @Override
    @Deprecated
    public byte[] configSet(byte[] parameter, byte[] value) {
        this.checkIsInMultiOrPipeline();
        this.client.configSet(parameter, value);
        return this.client.getBinaryBulkReply();
    }

    @Override
    public String configSetBinary(byte[] parameter, byte[] value) {
        this.checkIsInMultiOrPipeline();
        this.client.configSet(parameter, value);
        return this.client.getStatusCodeReply();
    }

    @Override
    public Long strlen(byte[] key) {
        this.checkIsInMultiOrPipeline();
        this.client.strlen(key);
        return this.client.getIntegerReply();
    }

    @Override
    public LCSMatchResult strAlgoLCSKeys(byte[] keyA, byte[] keyB, StrAlgoLCSParams params) {
        this.checkIsInMultiOrPipeline();
        this.client.strAlgoLCSKeys(keyA, keyB, params);
        return BuilderFactory.STR_ALGO_LCS_RESULT_BUILDER.build(this.client.getOne());
    }

    @Override
    public LCSMatchResult strAlgoLCSStrings(byte[] strA, byte[] strB, StrAlgoLCSParams params) {
        this.checkIsInMultiOrPipeline();
        this.client.strAlgoLCSStrings(strA, strB, params);
        return BuilderFactory.STR_ALGO_LCS_RESULT_BUILDER.build(this.client.getOne());
    }

    @Deprecated
    public void sync() {
        this.client.sync();
    }

    @Override
    public Long lpushx(byte[] key, byte[] ... string) {
        this.checkIsInMultiOrPipeline();
        this.client.lpushx(key, string);
        return this.client.getIntegerReply();
    }

    @Override
    public Long persist(byte[] key) {
        this.checkIsInMultiOrPipeline();
        this.client.persist(key);
        return this.client.getIntegerReply();
    }

    @Override
    public Long rpushx(byte[] key, byte[] ... string) {
        this.checkIsInMultiOrPipeline();
        this.client.rpushx(key, string);
        return this.client.getIntegerReply();
    }

    @Override
    public byte[] echo(byte[] string) {
        this.checkIsInMultiOrPipeline();
        this.client.echo(string);
        return this.client.getBinaryBulkReply();
    }

    @Override
    public Long linsert(byte[] key, ListPosition where, byte[] pivot, byte[] value) {
        this.checkIsInMultiOrPipeline();
        this.client.linsert(key, where, pivot, value);
        return this.client.getIntegerReply();
    }

    @Override
    public String debug(DebugParams params) {
        this.client.debug(params);
        return this.client.getStatusCodeReply();
    }

    public Client getClient() {
        return this.client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] brpoplpush(byte[] source, byte[] destination, int timeout) {
        this.checkIsInMultiOrPipeline();
        this.client.brpoplpush(source, destination, timeout);
        this.client.setTimeoutInfinite();
        try {
            byte[] byArray = this.client.getBinaryBulkReply();
            return byArray;
        }
        finally {
            this.client.rollbackTimeout();
        }
    }

    @Override
    public Boolean setbit(byte[] key, long offset, boolean value) {
        this.checkIsInMultiOrPipeline();
        this.client.setbit(key, offset, value);
        return this.client.getIntegerReply() == 1L;
    }

    @Override
    @Deprecated
    public Boolean setbit(byte[] key, long offset, byte[] value) {
        this.checkIsInMultiOrPipeline();
        this.client.setbit(key, offset, value);
        return this.client.getIntegerReply() == 1L;
    }

    @Override
    public Boolean getbit(byte[] key, long offset) {
        this.checkIsInMultiOrPipeline();
        this.client.getbit(key, offset);
        return this.client.getIntegerReply() == 1L;
    }

    public Long bitpos(byte[] key, boolean value) {
        return this.bitpos(key, value, new BitPosParams());
    }

    public Long bitpos(byte[] key, boolean value, BitPosParams params) {
        this.checkIsInMultiOrPipeline();
        this.client.bitpos(key, value, params);
        return this.client.getIntegerReply();
    }

    @Override
    public Long setrange(byte[] key, long offset, byte[] value) {
        this.checkIsInMultiOrPipeline();
        this.client.setrange(key, offset, value);
        return this.client.getIntegerReply();
    }

    @Override
    public byte[] getrange(byte[] key, long startOffset, long endOffset) {
        this.checkIsInMultiOrPipeline();
        this.client.getrange(key, startOffset, endOffset);
        return this.client.getBinaryBulkReply();
    }

    @Override
    public Long publish(byte[] channel, byte[] message) {
        this.checkIsInMultiOrPipeline();
        this.client.publish(channel, message);
        return this.client.getIntegerReply();
    }

    @Override
    public void subscribe(BinaryJedisPubSub jedisPubSub, byte[] ... channels) {
        this.client.setTimeoutInfinite();
        try {
            jedisPubSub.proceed(this.client, channels);
        }
        finally {
            this.client.rollbackTimeout();
        }
    }

    @Override
    public void psubscribe(BinaryJedisPubSub jedisPubSub, byte[] ... patterns) {
        this.client.setTimeoutInfinite();
        try {
            jedisPubSub.proceedWithPatterns(this.client, patterns);
        }
        finally {
            this.client.rollbackTimeout();
        }
    }

    @Override
    public Object eval(byte[] script, List<byte[]> keys, List<byte[]> args) {
        return this.eval(script, Protocol.toByteArray(keys.size()), BinaryJedis.getParamsWithBinary(keys, args));
    }

    protected static byte[][] getParamsWithBinary(List<byte[]> keys, List<byte[]> args) {
        int i;
        int keyCount = keys.size();
        int argCount = args.size();
        byte[][] params = new byte[keyCount + argCount][];
        for (i = 0; i < keyCount; ++i) {
            params[i] = keys.get(i);
        }
        for (i = 0; i < argCount; ++i) {
            params[keyCount + i] = args.get(i);
        }
        return params;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public Object eval(byte[] script, byte[] keyCount, byte[] ... params) {
        this.checkIsInMultiOrPipeline();
        this.client.eval(script, keyCount, params);
        this.client.setTimeoutInfinite();
        try {
            Object object = this.client.getOne();
            return object;
        }
        finally {
            this.client.rollbackTimeout();
        }
    }

    @Override
    public Object eval(byte[] script, int keyCount, byte[] ... params) {
        return this.eval(script, Protocol.toByteArray(keyCount), params);
    }

    @Override
    public Object eval(byte[] script) {
        return this.eval(script, 0, (byte[][])new byte[0][]);
    }

    @Override
    public Object evalsha(byte[] sha1) {
        return this.evalsha(sha1, 0, new byte[0][]);
    }

    @Override
    public Object evalsha(byte[] sha1, List<byte[]> keys, List<byte[]> args) {
        return this.evalsha(sha1, keys.size(), BinaryJedis.getParamsWithBinary(keys, args));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object evalsha(byte[] sha1, int keyCount, byte[] ... params) {
        this.checkIsInMultiOrPipeline();
        this.client.evalsha(sha1, keyCount, params);
        this.client.setTimeoutInfinite();
        try {
            Object object = this.client.getOne();
            return object;
        }
        finally {
            this.client.rollbackTimeout();
        }
    }

    @Override
    public String scriptFlush() {
        this.client.scriptFlush();
        return this.client.getStatusCodeReply();
    }

    @Override
    public String scriptFlush(FlushMode flushMode) {
        this.client.scriptFlush(flushMode);
        return this.client.getStatusCodeReply();
    }

    public Long scriptExists(byte[] sha1) {
        byte[][] a = new byte[][]{sha1};
        return this.scriptExists(a).get(0);
    }

    @Override
    public List<Long> scriptExists(byte[] ... sha1) {
        this.client.scriptExists(sha1);
        return this.client.getIntegerMultiBulkReply();
    }

    @Override
    public byte[] scriptLoad(byte[] script) {
        this.client.scriptLoad(script);
        return this.client.getBinaryBulkReply();
    }

    @Override
    public String scriptKill() {
        this.client.scriptKill();
        return this.client.getStatusCodeReply();
    }

    @Override
    public String slowlogReset() {
        this.client.slowlogReset();
        return this.client.getBulkReply();
    }

    @Override
    public Long slowlogLen() {
        this.client.slowlogLen();
        return this.client.getIntegerReply();
    }

    @Override
    public List<Object> slowlogGetBinary() {
        this.client.slowlogGet();
        return this.client.getObjectMultiBulkReply();
    }

    @Override
    public List<Object> slowlogGetBinary(long entries) {
        this.client.slowlogGet(entries);
        return this.client.getObjectMultiBulkReply();
    }

    @Override
    public Long objectRefcount(byte[] key) {
        this.client.objectRefcount(key);
        return this.client.getIntegerReply();
    }

    @Override
    public byte[] objectEncoding(byte[] key) {
        this.client.objectEncoding(key);
        return this.client.getBinaryBulkReply();
    }

    @Override
    public Long objectIdletime(byte[] key) {
        this.client.objectIdletime(key);
        return this.client.getIntegerReply();
    }

    @Override
    public List<byte[]> objectHelpBinary() {
        this.client.objectHelp();
        return this.client.getBinaryMultiBulkReply();
    }

    @Override
    public Long objectFreq(byte[] key) {
        this.client.objectFreq(key);
        return this.client.getIntegerReply();
    }

    @Override
    public Long bitcount(byte[] key) {
        this.checkIsInMultiOrPipeline();
        this.client.bitcount(key);
        return this.client.getIntegerReply();
    }

    @Override
    public Long bitcount(byte[] key, long start, long end) {
        this.checkIsInMultiOrPipeline();
        this.client.bitcount(key, start, end);
        return this.client.getIntegerReply();
    }

    @Override
    public Long bitop(BitOP op, byte[] destKey, byte[] ... srcKeys) {
        this.checkIsInMultiOrPipeline();
        this.client.bitop(op, destKey, srcKeys);
        return this.client.getIntegerReply();
    }

    @Override
    public byte[] dump(byte[] key) {
        this.checkIsInMultiOrPipeline();
        this.client.dump(key);
        return this.client.getBinaryBulkReply();
    }

    @Override
    public String restore(byte[] key, long ttl, byte[] serializedValue) {
        this.checkIsInMultiOrPipeline();
        this.client.restore(key, ttl, serializedValue);
        return this.client.getStatusCodeReply();
    }

    @Override
    public String restoreReplace(byte[] key, long ttl, byte[] serializedValue) {
        this.checkIsInMultiOrPipeline();
        this.client.restoreReplace(key, ttl, serializedValue);
        return this.client.getStatusCodeReply();
    }

    @Override
    public String restore(byte[] key, long ttl, byte[] serializedValue, RestoreParams params) {
        this.checkIsInMultiOrPipeline();
        this.client.restore(key, ttl, serializedValue, params);
        return this.client.getStatusCodeReply();
    }

    @Override
    public Long pexpire(byte[] key, long milliseconds) {
        this.checkIsInMultiOrPipeline();
        this.client.pexpire(key, milliseconds);
        return this.client.getIntegerReply();
    }

    @Override
    public Long pexpireAt(byte[] key, long millisecondsTimestamp) {
        this.checkIsInMultiOrPipeline();
        this.client.pexpireAt(key, millisecondsTimestamp);
        return this.client.getIntegerReply();
    }

    @Override
    public Long pttl(byte[] key) {
        this.checkIsInMultiOrPipeline();
        this.client.pttl(key);
        return this.client.getIntegerReply();
    }

    @Override
    public String psetex(byte[] key, long milliseconds, byte[] value) {
        this.checkIsInMultiOrPipeline();
        this.client.psetex(key, milliseconds, value);
        return this.client.getStatusCodeReply();
    }

    @Override
    public byte[] memoryDoctorBinary() {
        this.checkIsInMultiOrPipeline();
        this.client.memoryDoctor();
        return this.client.getBinaryBulkReply();
    }

    @Override
    public Long memoryUsage(byte[] key) {
        this.checkIsInMultiOrPipeline();
        this.client.memoryUsage(key);
        return this.client.getIntegerReply();
    }

    @Override
    public Long memoryUsage(byte[] key, int samples) {
        this.checkIsInMultiOrPipeline();
        this.client.memoryUsage(key, samples);
        return this.client.getIntegerReply();
    }

    @Override
    public String failover() {
        return this.failover(null);
    }

    @Override
    public String failover(FailoverParams failoverParams) {
        this.checkIsInMultiOrPipeline();
        this.client.failover(failoverParams);
        this.client.setTimeoutInfinite();
        try {
            String string = this.client.getStatusCodeReply();
            return string;
        }
        finally {
            this.client.rollbackTimeout();
        }
    }

    @Override
    public String failoverAbort() {
        this.checkIsInMultiOrPipeline();
        this.client.failoverAbort();
        return this.client.getStatusCodeReply();
    }

    @Override
    public byte[] aclWhoAmIBinary() {
        this.checkIsInMultiOrPipeline();
        this.client.aclWhoAmI();
        return this.client.getBinaryBulkReply();
    }

    @Override
    public byte[] aclGenPassBinary() {
        this.checkIsInMultiOrPipeline();
        this.client.aclGenPass();
        return this.client.getBinaryBulkReply();
    }

    @Override
    public List<byte[]> aclListBinary() {
        this.checkIsInMultiOrPipeline();
        this.client.aclList();
        return this.client.getBinaryMultiBulkReply();
    }

    @Override
    public List<byte[]> aclUsersBinary() {
        this.checkIsInMultiOrPipeline();
        this.client.aclUsers();
        return this.client.getBinaryMultiBulkReply();
    }

    @Override
    public AccessControlUser aclGetUser(byte[] name) {
        this.checkIsInMultiOrPipeline();
        this.client.aclGetUser(name);
        return BuilderFactory.ACCESS_CONTROL_USER.build(this.client.getObjectMultiBulkReply());
    }

    @Override
    public String aclSetUser(byte[] name) {
        this.checkIsInMultiOrPipeline();
        this.client.aclSetUser(name);
        return this.client.getStatusCodeReply();
    }

    @Override
    public String aclSetUser(byte[] name, byte[] ... keys) {
        this.checkIsInMultiOrPipeline();
        this.client.aclSetUser(name, keys);
        return this.client.getStatusCodeReply();
    }

    @Override
    public Long aclDelUser(byte[] name) {
        this.checkIsInMultiOrPipeline();
        this.client.aclDelUser(name);
        return this.client.getIntegerReply();
    }

    @Override
    public List<byte[]> aclCatBinary() {
        this.checkIsInMultiOrPipeline();
        this.client.aclCat();
        return this.client.getBinaryMultiBulkReply();
    }

    @Override
    public List<byte[]> aclCat(byte[] category) {
        this.checkIsInMultiOrPipeline();
        this.client.aclCat(category);
        return this.client.getBinaryMultiBulkReply();
    }

    @Override
    public List<byte[]> aclLogBinary() {
        this.checkIsInMultiOrPipeline();
        this.client.aclLog();
        return this.client.getBinaryMultiBulkReply();
    }

    @Override
    public List<byte[]> aclLogBinary(int limit) {
        this.checkIsInMultiOrPipeline();
        this.client.aclLog(limit);
        return this.client.getBinaryMultiBulkReply();
    }

    @Override
    public byte[] aclLog(byte[] options) {
        this.checkIsInMultiOrPipeline();
        this.client.aclLog(options);
        return this.client.getBinaryBulkReply();
    }

    @Override
    public String aclLoad() {
        this.checkIsInMultiOrPipeline();
        this.client.aclLoad();
        return this.client.getStatusCodeReply();
    }

    @Override
    public String aclSave() {
        this.checkIsInMultiOrPipeline();
        this.client.aclSave();
        return this.client.getStatusCodeReply();
    }

    @Override
    public String clientKill(byte[] ipPort) {
        this.checkIsInMultiOrPipeline();
        this.client.clientKill(ipPort);
        return this.client.getStatusCodeReply();
    }

    @Override
    public String clientKill(String ip, int port) {
        this.checkIsInMultiOrPipeline();
        this.client.clientKill(ip, port);
        return this.client.getStatusCodeReply();
    }

    @Override
    public Long clientKill(ClientKillParams params) {
        this.checkIsInMultiOrPipeline();
        this.client.clientKill(params);
        return this.client.getIntegerReply();
    }

    @Override
    public byte[] clientGetnameBinary() {
        this.checkIsInMultiOrPipeline();
        this.client.clientGetname();
        return this.client.getBinaryBulkReply();
    }

    @Override
    public byte[] clientListBinary() {
        this.checkIsInMultiOrPipeline();
        this.client.clientList();
        return this.client.getBinaryBulkReply();
    }

    @Override
    public byte[] clientListBinary(ClientType type) {
        this.checkIsInMultiOrPipeline();
        this.client.clientList(type);
        return this.client.getBinaryBulkReply();
    }

    @Override
    public byte[] clientListBinary(long ... clientIds) {
        this.checkIsInMultiOrPipeline();
        this.client.clientList(clientIds);
        return this.client.getBinaryBulkReply();
    }

    @Override
    public byte[] clientInfoBinary() {
        this.checkIsInMultiOrPipeline();
        this.client.clientInfo();
        return this.client.getBinaryBulkReply();
    }

    @Override
    public String clientSetname(byte[] name) {
        this.checkIsInMultiOrPipeline();
        this.client.clientSetname(name);
        return this.client.getBulkReply();
    }

    @Override
    public Long clientId() {
        this.checkIsInMultiOrPipeline();
        this.client.clientId();
        return this.client.getIntegerReply();
    }

    @Override
    public Long clientUnblock(long clientId, UnblockType unblockType) {
        this.checkIsInMultiOrPipeline();
        this.client.clientUnblock(clientId, unblockType);
        return this.client.getIntegerReply();
    }

    @Override
    public String clientPause(long timeout) {
        this.checkIsInMultiOrPipeline();
        this.client.clientPause(timeout);
        return this.client.getBulkReply();
    }

    @Override
    public String clientPause(long timeout, ClientPauseMode mode) {
        this.checkIsInMultiOrPipeline();
        this.client.clientPause(timeout, mode);
        return this.client.getBulkReply();
    }

    public List<String> time() {
        this.checkIsInMultiOrPipeline();
        this.client.time();
        return this.client.getMultiBulkReply();
    }

    @Override
    public String migrate(String host, int port, byte[] key, int destinationDb, int timeout) {
        this.checkIsInMultiOrPipeline();
        this.client.migrate(host, port, key, destinationDb, timeout);
        return this.client.getStatusCodeReply();
    }

    @Override
    public String migrate(String host, int port, int destinationDB, int timeout, MigrateParams params, byte[] ... keys) {
        this.checkIsInMultiOrPipeline();
        this.client.migrate(host, port, destinationDB, timeout, params, keys);
        return this.client.getStatusCodeReply();
    }

    @Override
    public Long waitReplicas(int replicas, long timeout) {
        this.checkIsInMultiOrPipeline();
        this.client.waitReplicas(replicas, timeout);
        return this.client.getIntegerReply();
    }

    @Override
    public Long pfadd(byte[] key, byte[] ... elements) {
        this.checkIsInMultiOrPipeline();
        this.client.pfadd(key, elements);
        return this.client.getIntegerReply();
    }

    @Override
    public long pfcount(byte[] key) {
        this.checkIsInMultiOrPipeline();
        this.client.pfcount(key);
        return this.client.getIntegerReply();
    }

    @Override
    public String pfmerge(byte[] destkey, byte[] ... sourcekeys) {
        this.checkIsInMultiOrPipeline();
        this.client.pfmerge(destkey, sourcekeys);
        return this.client.getStatusCodeReply();
    }

    @Override
    public Long pfcount(byte[] ... keys) {
        this.checkIsInMultiOrPipeline();
        this.client.pfcount(keys);
        return this.client.getIntegerReply();
    }

    @Override
    public ScanResult<byte[]> scan(byte[] cursor) {
        return this.scan(cursor, new ScanParams());
    }

    @Override
    public ScanResult<byte[]> scan(byte[] cursor, ScanParams params) {
        return this.scan(cursor, params, null);
    }

    @Override
    public ScanResult<byte[]> scan(byte[] cursor, ScanParams params, byte[] type) {
        this.checkIsInMultiOrPipeline();
        this.client.scan(cursor, params, type);
        List<Object> result = this.client.getObjectMultiBulkReply();
        byte[] newcursor = (byte[])result.get(0);
        List rawResults = (List)result.get(1);
        return new ScanResult<byte[]>(newcursor, rawResults);
    }

    @Override
    public ScanResult<Map.Entry<byte[], byte[]>> hscan(byte[] key, byte[] cursor) {
        return this.hscan(key, cursor, new ScanParams());
    }

    @Override
    public ScanResult<Map.Entry<byte[], byte[]>> hscan(byte[] key, byte[] cursor, ScanParams params) {
        this.checkIsInMultiOrPipeline();
        this.client.hscan(key, cursor, params);
        List<Object> result = this.client.getObjectMultiBulkReply();
        byte[] newcursor = (byte[])result.get(0);
        ArrayList results = new ArrayList();
        List rawResults = (List)result.get(1);
        Iterator iterator = rawResults.iterator();
        while (iterator.hasNext()) {
            results.add(new AbstractMap.SimpleEntry(iterator.next(), iterator.next()));
        }
        return new ScanResult<Map.Entry<byte[], byte[]>>(newcursor, results);
    }

    @Override
    public ScanResult<byte[]> sscan(byte[] key, byte[] cursor) {
        return this.sscan(key, cursor, new ScanParams());
    }

    @Override
    public ScanResult<byte[]> sscan(byte[] key, byte[] cursor, ScanParams params) {
        this.checkIsInMultiOrPipeline();
        this.client.sscan(key, cursor, params);
        List<Object> result = this.client.getObjectMultiBulkReply();
        byte[] newcursor = (byte[])result.get(0);
        List rawResults = (List)result.get(1);
        return new ScanResult<byte[]>(newcursor, rawResults);
    }

    @Override
    public ScanResult<Tuple> zscan(byte[] key, byte[] cursor) {
        return this.zscan(key, cursor, new ScanParams());
    }

    @Override
    public ScanResult<Tuple> zscan(byte[] key, byte[] cursor, ScanParams params) {
        this.checkIsInMultiOrPipeline();
        this.client.zscan(key, cursor, params);
        List<Object> result = this.client.getObjectMultiBulkReply();
        byte[] newcursor = (byte[])result.get(0);
        ArrayList<Tuple> results = new ArrayList<Tuple>();
        List rawResults = (List)result.get(1);
        Iterator iterator = rawResults.iterator();
        while (iterator.hasNext()) {
            results.add(new Tuple((byte[])iterator.next(), BuilderFactory.DOUBLE.build(iterator.next())));
        }
        return new ScanResult<Tuple>(newcursor, results);
    }

    @Override
    public Long geoadd(byte[] key, double longitude, double latitude, byte[] member) {
        this.checkIsInMultiOrPipeline();
        this.client.geoadd(key, longitude, latitude, member);
        return this.client.getIntegerReply();
    }

    @Override
    public Long geoadd(byte[] key, Map<byte[], GeoCoordinate> memberCoordinateMap) {
        this.checkIsInMultiOrPipeline();
        this.client.geoadd(key, memberCoordinateMap);
        return this.client.getIntegerReply();
    }

    @Override
    public Long geoadd(byte[] key, GeoAddParams params, Map<byte[], GeoCoordinate> memberCoordinateMap) {
        this.checkIsInMultiOrPipeline();
        this.client.geoadd(key, params, memberCoordinateMap);
        return this.client.getIntegerReply();
    }

    @Override
    public Double geodist(byte[] key, byte[] member1, byte[] member2) {
        this.checkIsInMultiOrPipeline();
        this.client.geodist(key, member1, member2);
        return BuilderFactory.DOUBLE.build(this.client.getOne());
    }

    @Override
    public Double geodist(byte[] key, byte[] member1, byte[] member2, GeoUnit unit) {
        this.checkIsInMultiOrPipeline();
        this.client.geodist(key, member1, member2, unit);
        return BuilderFactory.DOUBLE.build(this.client.getOne());
    }

    @Override
    public List<byte[]> geohash(byte[] key, byte[] ... members) {
        this.checkIsInMultiOrPipeline();
        this.client.geohash(key, members);
        return this.client.getBinaryMultiBulkReply();
    }

    @Override
    public List<GeoCoordinate> geopos(byte[] key, byte[] ... members) {
        this.checkIsInMultiOrPipeline();
        this.client.geopos(key, members);
        return BuilderFactory.GEO_COORDINATE_LIST.build(this.client.getObjectMultiBulkReply());
    }

    @Override
    public List<GeoRadiusResponse> georadius(byte[] key, double longitude, double latitude, double radius, GeoUnit unit) {
        this.checkIsInMultiOrPipeline();
        this.client.georadius(key, longitude, latitude, radius, unit);
        return BuilderFactory.GEORADIUS_WITH_PARAMS_RESULT.build(this.client.getObjectMultiBulkReply());
    }

    @Override
    public List<GeoRadiusResponse> georadiusReadonly(byte[] key, double longitude, double latitude, double radius, GeoUnit unit) {
        this.checkIsInMultiOrPipeline();
        this.client.georadiusReadonly(key, longitude, latitude, radius, unit);
        return BuilderFactory.GEORADIUS_WITH_PARAMS_RESULT.build(this.client.getObjectMultiBulkReply());
    }

    @Override
    public List<GeoRadiusResponse> georadius(byte[] key, double longitude, double latitude, double radius, GeoUnit unit, GeoRadiusParam param) {
        this.checkIsInMultiOrPipeline();
        this.client.georadius(key, longitude, latitude, radius, unit, param);
        return BuilderFactory.GEORADIUS_WITH_PARAMS_RESULT.build(this.client.getObjectMultiBulkReply());
    }

    @Override
    public Long georadiusStore(byte[] key, double longitude, double latitude, double radius, GeoUnit unit, GeoRadiusParam param, GeoRadiusStoreParam storeParam) {
        this.checkIsInMultiOrPipeline();
        this.client.georadiusStore(key, longitude, latitude, radius, unit, param, storeParam);
        return this.client.getIntegerReply();
    }

    @Override
    public List<GeoRadiusResponse> georadiusReadonly(byte[] key, double longitude, double latitude, double radius, GeoUnit unit, GeoRadiusParam param) {
        this.checkIsInMultiOrPipeline();
        this.client.georadiusReadonly(key, longitude, latitude, radius, unit, param);
        return BuilderFactory.GEORADIUS_WITH_PARAMS_RESULT.build(this.client.getObjectMultiBulkReply());
    }

    @Override
    public List<GeoRadiusResponse> georadiusByMember(byte[] key, byte[] member, double radius, GeoUnit unit) {
        this.checkIsInMultiOrPipeline();
        this.client.georadiusByMember(key, member, radius, unit);
        return BuilderFactory.GEORADIUS_WITH_PARAMS_RESULT.build(this.client.getObjectMultiBulkReply());
    }

    @Override
    public List<GeoRadiusResponse> georadiusByMemberReadonly(byte[] key, byte[] member, double radius, GeoUnit unit) {
        this.checkIsInMultiOrPipeline();
        this.client.georadiusByMemberReadonly(key, member, radius, unit);
        return BuilderFactory.GEORADIUS_WITH_PARAMS_RESULT.build(this.client.getObjectMultiBulkReply());
    }

    @Override
    public List<GeoRadiusResponse> georadiusByMember(byte[] key, byte[] member, double radius, GeoUnit unit, GeoRadiusParam param) {
        this.checkIsInMultiOrPipeline();
        this.client.georadiusByMember(key, member, radius, unit, param);
        return BuilderFactory.GEORADIUS_WITH_PARAMS_RESULT.build(this.client.getObjectMultiBulkReply());
    }

    @Override
    public Long georadiusByMemberStore(byte[] key, byte[] member, double radius, GeoUnit unit, GeoRadiusParam param, GeoRadiusStoreParam storeParam) {
        this.checkIsInMultiOrPipeline();
        this.client.georadiusByMemberStore(key, member, radius, unit, param, storeParam);
        return this.client.getIntegerReply();
    }

    @Override
    public List<GeoRadiusResponse> georadiusByMemberReadonly(byte[] key, byte[] member, double radius, GeoUnit unit, GeoRadiusParam param) {
        this.checkIsInMultiOrPipeline();
        this.client.georadiusByMemberReadonly(key, member, radius, unit, param);
        return BuilderFactory.GEORADIUS_WITH_PARAMS_RESULT.build(this.client.getObjectMultiBulkReply());
    }

    @Override
    public List<Long> bitfield(byte[] key, byte[] ... arguments) {
        this.checkIsInMultiOrPipeline();
        this.client.bitfield(key, arguments);
        return this.client.getIntegerMultiBulkReply();
    }

    @Override
    public List<Long> bitfieldReadonly(byte[] key, byte[] ... arguments) {
        this.checkIsInMultiOrPipeline();
        this.client.bitfieldReadonly(key, arguments);
        return this.client.getIntegerMultiBulkReply();
    }

    @Override
    public Long hstrlen(byte[] key, byte[] field) {
        this.checkIsInMultiOrPipeline();
        this.client.hstrlen(key, field);
        return this.client.getIntegerReply();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<byte[]> xread(int count, long block, Map<byte[], byte[]> streams) {
        this.checkIsInMultiOrPipeline();
        this.client.xread(count, block, streams);
        this.client.setTimeoutInfinite();
        try {
            List<byte[]> list = this.client.getBinaryMultiBulkReply();
            return list;
        }
        finally {
            this.client.rollbackTimeout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<byte[]> xread(XReadParams xReadParams, Map.Entry<byte[], byte[]> ... streams) {
        this.checkIsInMultiOrPipeline();
        this.client.xread(xReadParams, streams);
        if (!xReadParams.hasBlock()) {
            return this.client.getBinaryMultiBulkReply();
        }
        this.client.setTimeoutInfinite();
        try {
            List<byte[]> list = this.client.getBinaryMultiBulkReply();
            return list;
        }
        finally {
            this.client.rollbackTimeout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<byte[]> xreadGroup(byte[] groupname, byte[] consumer, int count, long block, boolean noAck, Map<byte[], byte[]> streams) {
        this.checkIsInMultiOrPipeline();
        this.client.xreadGroup(groupname, consumer, count, block, noAck, streams);
        this.client.setTimeoutInfinite();
        try {
            List<byte[]> list = this.client.getBinaryMultiBulkReply();
            return list;
        }
        finally {
            this.client.rollbackTimeout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<byte[]> xreadGroup(byte[] groupname, byte[] consumer, XReadGroupParams xReadGroupParams, Map.Entry<byte[], byte[]> ... streams) {
        this.checkIsInMultiOrPipeline();
        this.client.xreadGroup(groupname, consumer, xReadGroupParams, streams);
        if (!xReadGroupParams.hasBlock()) {
            return this.client.getBinaryMultiBulkReply();
        }
        this.client.setTimeoutInfinite();
        try {
            List<byte[]> list = this.client.getBinaryMultiBulkReply();
            return list;
        }
        finally {
            this.client.rollbackTimeout();
        }
    }

    @Override
    public byte[] xadd(byte[] key, byte[] id, Map<byte[], byte[]> hash, long maxLen, boolean approximateLength) {
        this.checkIsInMultiOrPipeline();
        this.client.xadd(key, id, hash, maxLen, approximateLength);
        return this.client.getBinaryBulkReply();
    }

    @Override
    public byte[] xadd(byte[] key, Map<byte[], byte[]> hash, XAddParams params) {
        this.checkIsInMultiOrPipeline();
        this.client.xadd(key, hash, params);
        return this.client.getBinaryBulkReply();
    }

    @Override
    public Long xlen(byte[] key) {
        this.checkIsInMultiOrPipeline();
        this.client.xlen(key);
        return this.client.getIntegerReply();
    }

    @Override
    public List<byte[]> xrange(byte[] key, byte[] start, byte[] end) {
        this.checkIsInMultiOrPipeline();
        this.client.xrange(key, start, end);
        return this.client.getBinaryMultiBulkReply();
    }

    @Override
    public List<byte[]> xrange(byte[] key, byte[] start, byte[] end, int count) {
        this.checkIsInMultiOrPipeline();
        this.client.xrange(key, start, end, count);
        return this.client.getBinaryMultiBulkReply();
    }

    @Override
    public List<byte[]> xrevrange(byte[] key, byte[] end, byte[] start) {
        this.checkIsInMultiOrPipeline();
        this.client.xrevrange(key, end, start);
        return this.client.getBinaryMultiBulkReply();
    }

    @Override
    public List<byte[]> xrevrange(byte[] key, byte[] end, byte[] start, int count) {
        this.checkIsInMultiOrPipeline();
        this.client.xrevrange(key, end, start, count);
        return this.client.getBinaryMultiBulkReply();
    }

    @Override
    public Long xack(byte[] key, byte[] group, byte[] ... ids) {
        this.checkIsInMultiOrPipeline();
        this.client.xack(key, group, ids);
        return this.client.getIntegerReply();
    }

    @Override
    public String xgroupCreate(byte[] key, byte[] consumer, byte[] id, boolean makeStream) {
        this.checkIsInMultiOrPipeline();
        this.client.xgroupCreate(key, consumer, id, makeStream);
        return this.client.getStatusCodeReply();
    }

    @Override
    public String xgroupSetID(byte[] key, byte[] consumer, byte[] id) {
        this.checkIsInMultiOrPipeline();
        this.client.xgroupSetID(key, consumer, id);
        return this.client.getStatusCodeReply();
    }

    @Override
    public Long xgroupDestroy(byte[] key, byte[] consumer) {
        this.checkIsInMultiOrPipeline();
        this.client.xgroupDestroy(key, consumer);
        return this.client.getIntegerReply();
    }

    @Override
    public Long xgroupDelConsumer(byte[] key, byte[] consumer, byte[] consumerName) {
        this.checkIsInMultiOrPipeline();
        this.client.xgroupDelConsumer(key, consumer, consumerName);
        return this.client.getIntegerReply();
    }

    @Override
    public Long xdel(byte[] key, byte[] ... ids) {
        this.checkIsInMultiOrPipeline();
        this.client.xdel(key, ids);
        return this.client.getIntegerReply();
    }

    @Override
    public Long xtrim(byte[] key, long maxLen, boolean approximateLength) {
        this.checkIsInMultiOrPipeline();
        this.client.xtrim(key, maxLen, approximateLength);
        return this.client.getIntegerReply();
    }

    @Override
    public Long xtrim(byte[] key, XTrimParams params) {
        this.checkIsInMultiOrPipeline();
        this.client.xtrim(key, params);
        return this.client.getIntegerReply();
    }

    @Override
    public List<Object> xpending(byte[] key, byte[] groupname, byte[] start, byte[] end, int count, byte[] consumername) {
        this.checkIsInMultiOrPipeline();
        this.client.xpending(key, groupname, start, end, count, consumername);
        return this.client.getObjectMultiBulkReply();
    }

    @Override
    public Object xpending(byte[] key, byte[] groupname) {
        this.checkIsInMultiOrPipeline();
        this.client.xpending(key, groupname);
        return this.client.getOne();
    }

    @Override
    public List<Object> xpending(byte[] key, byte[] groupname, XPendingParams params) {
        this.checkIsInMultiOrPipeline();
        this.client.xpending(key, groupname, params);
        return this.client.getObjectMultiBulkReply();
    }

    @Override
    public List<byte[]> xclaim(byte[] key, byte[] groupname, byte[] consumername, long minIdleTime, long newIdleTime, int retries, boolean force, byte[] ... ids) {
        this.checkIsInMultiOrPipeline();
        this.client.xclaim(key, groupname, consumername, minIdleTime, newIdleTime, retries, force, ids);
        return this.client.getBinaryMultiBulkReply();
    }

    @Override
    public List<byte[]> xclaim(byte[] key, byte[] group, byte[] consumername, long minIdleTime, XClaimParams params, byte[] ... ids) {
        this.checkIsInMultiOrPipeline();
        this.client.xclaim(key, group, consumername, minIdleTime, params, ids);
        return this.client.getBinaryMultiBulkReply();
    }

    @Override
    public List<byte[]> xclaimJustId(byte[] key, byte[] group, byte[] consumername, long minIdleTime, XClaimParams params, byte[] ... ids) {
        this.checkIsInMultiOrPipeline();
        this.client.xclaimJustId(key, group, consumername, minIdleTime, params, ids);
        return this.client.getBinaryMultiBulkReply();
    }

    @Override
    public List<Object> xautoclaim(byte[] key, byte[] groupName, byte[] consumerName, long minIdleTime, byte[] start, XAutoClaimParams params) {
        this.checkIsInMultiOrPipeline();
        this.client.xautoclaim(key, groupName, consumerName, minIdleTime, start, params);
        return this.client.getObjectMultiBulkReply();
    }

    @Override
    public List<Object> xautoclaimJustId(byte[] key, byte[] groupName, byte[] consumerName, long minIdleTime, byte[] start, XAutoClaimParams params) {
        this.checkIsInMultiOrPipeline();
        this.client.xautoclaimJustId(key, groupName, consumerName, minIdleTime, start, params);
        return this.client.getObjectMultiBulkReply();
    }

    @Override
    public StreamInfo xinfoStream(byte[] key) {
        this.checkIsInMultiOrPipeline();
        this.client.xinfoStream(key);
        return BuilderFactory.STREAM_INFO.build(this.client.getOne());
    }

    @Override
    public Object xinfoStreamBinary(byte[] key) {
        this.checkIsInMultiOrPipeline();
        this.client.xinfoStream(key);
        return this.client.getOne();
    }

    @Override
    public List<StreamGroupInfo> xinfoGroup(byte[] key) {
        this.checkIsInMultiOrPipeline();
        this.client.xinfoGroup(key);
        return BuilderFactory.STREAM_GROUP_INFO_LIST.build(this.client.getBinaryMultiBulkReply());
    }

    @Override
    public List<Object> xinfoGroupBinary(byte[] key) {
        this.checkIsInMultiOrPipeline();
        this.client.xinfoGroup(key);
        return this.client.getObjectMultiBulkReply();
    }

    @Override
    public List<StreamConsumersInfo> xinfoConsumers(byte[] key, byte[] group) {
        this.checkIsInMultiOrPipeline();
        this.client.xinfoConsumers(key, group);
        return BuilderFactory.STREAM_CONSUMERS_INFO_LIST.build(this.client.getBinaryMultiBulkReply());
    }

    @Override
    public List<Object> xinfoConsumersBinary(byte[] key, byte[] group) {
        this.checkIsInMultiOrPipeline();
        this.client.xinfoConsumers(key, group);
        return this.client.getObjectMultiBulkReply();
    }

    public Object sendCommand(ProtocolCommand cmd, byte[] ... args) {
        this.checkIsInMultiOrPipeline();
        this.client.sendCommand(cmd, args);
        return this.client.getOne();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object sendBlockingCommand(ProtocolCommand cmd, byte[] ... args) {
        this.checkIsInMultiOrPipeline();
        this.client.sendCommand(cmd, args);
        this.client.setTimeoutInfinite();
        try {
            Object object = this.client.getOne();
            return object;
        }
        finally {
            this.client.rollbackTimeout();
        }
    }

    public Object sendCommand(ProtocolCommand cmd) {
        return this.sendCommand(cmd, DUMMY_ARRAY);
    }

    protected static class SetFromList<E>
    extends AbstractSet<E>
    implements Serializable {
        private static final long serialVersionUID = -2850347066962734052L;
        private final List<E> list;

        private SetFromList(List<E> list) {
            if (list == null) {
                throw new NullPointerException("list");
            }
            this.list = list;
        }

        @Override
        public void clear() {
            this.list.clear();
        }

        @Override
        public int size() {
            return this.list.size();
        }

        @Override
        public boolean isEmpty() {
            return this.list.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.list.contains(o);
        }

        @Override
        public boolean remove(Object o) {
            return this.list.remove(o);
        }

        @Override
        public boolean add(E e) {
            return !this.contains(e) && this.list.add(e);
        }

        @Override
        public Iterator<E> iterator() {
            return this.list.iterator();
        }

        @Override
        public Object[] toArray() {
            return this.list.toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return this.list.toArray(a);
        }

        @Override
        public String toString() {
            return this.list.toString();
        }

        @Override
        public int hashCode() {
            return this.list.hashCode();
        }

        @Override
        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (o == this) {
                return true;
            }
            if (!(o instanceof Set)) {
                return false;
            }
            Collection c = (Collection)o;
            if (c.size() != this.size()) {
                return false;
            }
            return this.containsAll(c);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.list.containsAll(c);
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            return this.list.removeAll(c);
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            return this.list.retainAll(c);
        }

        protected static <E> SetFromList<E> of(List<E> list) {
            return new SetFromList<E>(list);
        }
    }
}

