/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.events;

import com.denizenscript.denizencore.DenizenCore;
import com.denizenscript.denizencore.events.ScriptEventCouldMatcher;
import com.denizenscript.denizencore.events.core.ConsoleOutputScriptEvent;
import com.denizenscript.denizencore.events.core.CustomScriptEvent;
import com.denizenscript.denizencore.events.core.DeltaTimeScriptEvent;
import com.denizenscript.denizencore.events.core.PreScriptReloadScriptEvent;
import com.denizenscript.denizencore.events.core.RedisPubSubMessageScriptEvent;
import com.denizenscript.denizencore.events.core.ReloadScriptsScriptEvent;
import com.denizenscript.denizencore.events.core.ScriptGeneratesErrorScriptEvent;
import com.denizenscript.denizencore.events.core.ScriptsLoadedScriptEvent;
import com.denizenscript.denizencore.events.core.ServerGeneratesExceptionScriptEvent;
import com.denizenscript.denizencore.events.core.ShutdownScriptEvent;
import com.denizenscript.denizencore.events.core.SystemTimeScriptEvent;
import com.denizenscript.denizencore.events.core.TickScriptEvent;
import com.denizenscript.denizencore.events.core.WebserverWebRequestScriptEvent;
import com.denizenscript.denizencore.flags.AbstractFlagTracker;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ScriptTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import com.denizenscript.denizencore.scripts.ScriptEntrySet;
import com.denizenscript.denizencore.scripts.containers.ScriptContainer;
import com.denizenscript.denizencore.scripts.containers.core.WorldScriptContainer;
import com.denizenscript.denizencore.scripts.queues.ContextSource;
import com.denizenscript.denizencore.scripts.queues.core.InstantQueue;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.utilities.CoreConfiguration;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.Deprecations;
import com.denizenscript.denizencore.utilities.YamlConfiguration;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import com.denizenscript.denizencore.utilities.scheduling.OneTimeSchedulable;
import com.denizenscript.denizencore.utilities.text.StringHolder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.function.BiFunction;
import java.util.regex.Pattern;

public abstract class ScriptEvent
implements ContextSource,
Cloneable {
    public static ArrayList<WorldScriptContainer> worldContainers = new ArrayList();
    public static ArrayList<ScriptEvent> events = new ArrayList();
    public static HashMap<String, ArrayList<ScriptEvent>> couldMatchOptimizer = new HashMap();
    public static int totalPaths = 0;
    public static ArrayList<ScriptEvent> legacyCouldMatchEvents = new ArrayList();
    public static HashMap<String, ScriptEvent> eventLookup = new HashMap();
    public ArrayList<ScriptPath> eventPaths = new ArrayList();
    public InternalEventData eventData = new InternalEventData();
    public boolean cancelled = false;
    public static ScriptPath tryingToBuildPath = null;
    public static ScriptEvent tryingToBuildEvent = null;
    public static List<BiFunction<ScriptEvent, ScriptPath, Boolean>> extraMatchers = new ArrayList<BiFunction<ScriptEvent, ScriptPath, Boolean>>();
    private static ScriptEventCouldMatcher currentCouldMatcher = null;
    public static HashSet<String> globalSwitches = new HashSet<String>(Arrays.asList("cancelled", "ignorecancelled", "priority", "server_flagged", "in", "chance"));
    public static final HashMap<String, MatchHelper> knownMatchers = new HashMap();

    public ScriptEvent clone() {
        try {
            return (ScriptEvent)super.clone();
        }
        catch (CloneNotSupportedException e) {
            Debug.echoError("Clone not supported for script events?!");
            return this;
        }
    }

    public static void registerCoreEvents() {
        ScriptEvent.registerScriptEvent(ConsoleOutputScriptEvent.class);
        ScriptEvent.registerScriptEvent(CustomScriptEvent.class);
        ScriptEvent.registerScriptEvent(DeltaTimeScriptEvent.class);
        ScriptEvent.registerScriptEvent(RedisPubSubMessageScriptEvent.class);
        ScriptEvent.registerScriptEvent(PreScriptReloadScriptEvent.class);
        ScriptEvent.registerScriptEvent(ReloadScriptsScriptEvent.class);
        ScriptEvent.registerScriptEvent(ScriptGeneratesErrorScriptEvent.class);
        ScriptEvent.registerScriptEvent(ServerGeneratesExceptionScriptEvent.class);
        ScriptEvent.registerScriptEvent(ScriptsLoadedScriptEvent.class);
        ScriptEvent.registerScriptEvent(ShutdownScriptEvent.class);
        ScriptEvent.registerScriptEvent(SystemTimeScriptEvent.class);
        ScriptEvent.registerScriptEvent(TickScriptEvent.class);
        ScriptEvent.registerScriptEvent(WebserverWebRequestScriptEvent.class);
    }

    public static void registerScriptEvent(Class<? extends ScriptEvent> eventClass) {
        try {
            ScriptEvent event = eventClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            ScriptEvent.registerScriptEvent(event);
        }
        catch (Throwable ex) {
            Debug.echoError("Failed to register script event '" + eventClass.getName() + "':");
            Debug.echoError(ex);
        }
    }

    public static void registerScriptEvent(ScriptEvent event) {
        events.add(event);
        eventLookup.put(CoreUtilities.toLowerCase(event.getName()), event);
        if (event.eventData.couldMatchers.isEmpty() || event.eventData.needsLegacy) {
            legacyCouldMatchEvents.add(event);
        }
    }

    public static void reload() {
        if (CoreConfiguration.debugLoadingInfo) {
            Debug.log("Reloading script events...");
        }
        ScriptEvent.reloadPreClear();
        totalPaths = 0;
        for (ScriptContainer scriptContainer : worldContainers) {
            try {
                if (!CoreUtilities.equalsIgnoreCase(scriptContainer.getContents().getString("enabled", "true"), "true")) continue;
                YamlConfiguration config = scriptContainer.getConfigurationSection("events");
                if (config == null) {
                    Debug.echoError("Missing or invalid events block for <Y>" + scriptContainer.getName());
                    continue;
                }
                for (StringHolder evt1 : config.getKeys(false)) {
                    if (evt1 == null || evt1.str == null) {
                        Debug.echoError("Missing or invalid events block for <Y>" + scriptContainer.getName());
                        continue;
                    }
                    ++totalPaths;
                    ScriptEvent.loadSinglePath(evt1, scriptContainer);
                }
            }
            catch (Exception ex) {
                Debug.echoError("Failed to load world script container '<Y>" + scriptContainer.getName() + "<W>':");
                Debug.echoError(ex);
            }
        }
        ScriptEvent.reloadPostLoad();
        Debug.log("Processed <A>" + totalPaths + "<W> script event paths.");
    }

    private static void reloadPreClear() {
        for (ScriptEvent event : events) {
            try {
                event.destroy();
                event.eventPaths.clear();
            }
            catch (Throwable ex) {
                Debug.echoError("Failed to unload event '<Y>" + event.getName() + "<W>':");
                Debug.echoError(ex);
            }
        }
    }

    private static void loadSinglePath(StringHolder evt1, ScriptContainer container) {
        String evt;
        if (CoreUtilities.contains(evt1.str, '@')) {
            Debug.echoError("Script '<Y>" + container.getName() + "<W>' has event '<Y>" + evt1.str.replace("@", "<R>@<Y>") + "<W>' which contains object notation, which is deprecated for use in world events. Please remove it.");
        }
        boolean after = false;
        if (evt1.low.startsWith("on ")) {
            evt = evt1.str.substring("on ".length());
        } else if (evt1.low.startsWith("after ")) {
            evt = evt1.str.substring("after ".length());
            after = true;
        } else {
            Debug.echoError("Script path '<Y>" + evt1.str + "<W>' is invalid (missing 'on' or 'after').");
            return;
        }
        evt = evt.replace("&dot", ".").replace("&amp", "&");
        ScriptPath path = new ScriptPath(container, evt, evt1.str);
        path.fireAfter = after;
        ScriptEvent.tryLoadDirect(path);
    }

    private static boolean tryLoadDirect(ScriptPath path) {
        if (path.set == null) {
            Debug.echoError("Script path '<Y>" + path + "<W>' is invalid (empty or misconfigured).");
            return false;
        }
        tryingToBuildPath = path;
        ArrayList<ScriptEvent> toScan = couldMatchOptimizer.get(path.eventArgLowerAt(0));
        if (toScan != null) {
            ScriptEvent.tryLoadForSet(path, toScan);
        }
        ScriptEvent.tryLoadForSet(path, legacyCouldMatchEvents);
        if (path.matches.size() > 1) {
            Debug.log("Event <Y>" + path + "<W> is matched to multiple ScriptEvents: <Y>" + CoreUtilities.join("<W>,<Y> ", path.matches));
        } else if (path.matches.isEmpty()) {
            ScriptPath legacy;
            if (path.eventArgsLower.length > 2 && path.eventArgLowerAt(path.eventArgsLower.length - 2).equals("in") && ScriptEvent.tryLoadDirect(legacy = new ScriptPath(path.container, path.event.substring(0, path.eventLower.lastIndexOf(" in ")), path.rawContainerPath))) {
                Deprecations.inAreaSwitchFormat.warn(path.container);
                return true;
            }
            if (toScan == null) {
                Debug.echoError("Event <Y>" + path + "<W> is not matched to any ScriptEvents.");
            } else {
                int sizedRight = 0;
                block0: for (ScriptEvent evt : toScan) {
                    for (ScriptEventCouldMatcher matcher : evt.eventData.couldMatchers) {
                        if (matcher.validators.length != path.eventArgsLower.length) continue;
                        ++sizedRight;
                        continue block0;
                    }
                }
                Debug.echoError("Event <Y>" + path + "<W> is not matched to any ScriptEvents.  First word '<Y>" + path.eventArgLowerAt(0) + "<W>' matched lookup table, of which <Y>" + sizedRight + "<W> are correct length, but specific matching failed.");
            }
            if (path.matchFailReasons != null) {
                for (String reason : path.matchFailReasons) {
                    Debug.log(reason);
                }
            }
            path.matchFailReasons = null;
            return false;
        }
        path.matchFailReasons = null;
        return true;
    }

    private static void tryLoadForSet(ScriptPath path, ArrayList<ScriptEvent> events) {
        Iterator<ScriptEvent> iterator = events.iterator();
        while (iterator.hasNext()) {
            ScriptEvent event;
            tryingToBuildEvent = event = iterator.next();
            if (!event.couldMatch(path) || path.matches.contains(event)) continue;
            event.eventPaths.add(path);
            path.matches.add(event);
            if (!CoreConfiguration.debugLoadingInfo) continue;
            Debug.log("Event match, <Y>" + event.getName() + "<W> matched for '<Y>" + path + "<W>'!");
        }
    }

    private static void reloadPostLoad() {
        for (ScriptEvent event : events) {
            try {
                if (event.eventPaths.isEmpty()) continue;
                event.sort();
                event.init();
            }
            catch (Throwable ex) {
                Debug.echoError("Failed to load event '<Y>" + event.getName() + "<W>':");
                Debug.echoError(ex);
            }
        }
    }

    public static void addPossibleCouldMatchFailReason(String reason, String example) {
        if (tryingToBuildPath == null || tryingToBuildEvent == null) {
            return;
        }
        if (ScriptEvent.tryingToBuildPath.matchFailReasons == null) {
            ScriptEvent.tryingToBuildPath.matchFailReasons = new ArrayList<String>();
        }
        String baseText = "Almost matched: <Y>" + tryingToBuildEvent.getName();
        String reasonText = "<W>, but failed because: <Y>" + reason + "<W>: '<LR>" + example + "<W>'";
        if (currentCouldMatcher == null) {
            ScriptEvent.tryingToBuildPath.matchFailReasons.add(baseText + reasonText);
        } else {
            ScriptEvent.tryingToBuildPath.matchFailReasons.add(baseText + "<W> as <Y>" + ScriptEvent.currentCouldMatcher.format + reasonText);
        }
    }

    public static boolean matchesScript(ScriptEvent sEvent, ScriptPath path) {
        if (path.switch_cancelled != null ? path.switch_cancelled != sEvent.cancelled : (path.switch_ignoreCancelled != null ? path.switch_ignoreCancelled == false && sEvent.cancelled : sEvent.cancelled)) {
            return false;
        }
        if (path.switch_serverFlagged != null) {
            for (String string : path.switch_serverFlagged) {
                if (DenizenCore.serverFlagMap.hasFlag(string)) continue;
                return false;
            }
        }
        if (path.switch_chance != 0.0 && CoreUtilities.getRandom().nextDouble() * 100.0 > path.switch_chance) {
            return false;
        }
        for (BiFunction biFunction : extraMatchers) {
            if (((Boolean)biFunction.apply(sEvent, path)).booleanValue()) continue;
            return false;
        }
        return sEvent.matches(path);
    }

    public void sort() {
        try {
            for (ScriptPath path : this.eventPaths) {
                String gotten = path.switches.get("priority");
                path.priority = gotten == null ? 0 : Integer.parseInt(gotten);
            }
        }
        catch (NumberFormatException ex) {
            Debug.echoError("Failed to sort events: not-a-number priority value! " + ex.getMessage());
        }
        this.eventPaths.sort((scriptPath, t1) -> {
            int rel = scriptPath.priority - t1.priority;
            return Integer.compare(rel, 0);
        });
    }

    public void init() {
    }

    public void destroy() {
    }

    public void cancellationChanged() {
    }

    @Deprecated
    public static boolean isDefaultDetermination(ObjectTag determination) {
        Debug.echoError("VERSION MISMATCH, UPDATE ALL DENIZEN-RELATED SUBPROJECTS.");
        return false;
    }

    public boolean applyDetermination(ScriptPath path, ObjectTag determination) {
        Debug.echoError("Unknown determination '" + determination + "'");
        return false;
    }

    public boolean handleBaseDetermination(ScriptPath path, ObjectTag determination) {
        String text;
        if (determination instanceof ElementTag && (text = determination.toString()).length() <= "cancelled:false".length()) {
            String low;
            switch (low = CoreUtilities.toLowerCase(text)) {
                case "cancelled:true": 
                case "cancelled": {
                    Debug.echoDebug((Debuggable)path.container, "Event cancelled!");
                    this.cancelled = true;
                    this.cancellationChanged();
                    return true;
                }
                case "cancelled:false": {
                    Debug.echoDebug((Debuggable)path.container, "Event uncancelled!");
                    this.cancelled = false;
                    this.cancellationChanged();
                    return true;
                }
            }
        }
        return this.applyDetermination(path, determination);
    }

    public ScriptEntryData getScriptEntryData() {
        return DenizenCore.implementation.getEmptyScriptEntryData();
    }

    public final void registerSwitches(String ... switches) {
        this.eventData.localSwitches.addAll(Arrays.asList(switches));
    }

    public final void registerCouldMatcher(String format) {
        int paren = format.indexOf(40);
        if (paren == -1) {
            ScriptEventCouldMatcher matcher = new ScriptEventCouldMatcher(format);
            this.eventData.couldMatchers.add(matcher);
            if (matcher.validators[0] instanceof ScriptEventCouldMatcher.StringBasedValidator) {
                String text = ((ScriptEventCouldMatcher.StringBasedValidator)matcher.validators[0]).word;
                ArrayList list = couldMatchOptimizer.computeIfAbsent(text, k -> new ArrayList());
                if (!list.contains(this)) {
                    list.add(this);
                }
            } else {
                this.eventData.needsLegacy = true;
            }
            return;
        }
        int endParen = format.indexOf(41, paren);
        if (endParen == -1) {
            Debug.echoError("Invalid couldMatcher registration '" + format + "': inconsistent parens");
            return;
        }
        String base = paren == 0 ? "" : format.substring(0, paren - 1);
        String afterText = endParen + 2 >= format.length() ? "" : format.substring(endParen + 2);
        String optional = format.substring(paren + 1, endParen);
        this.registerCouldMatcher(base + (afterText.isEmpty() || base.isEmpty() ? afterText : " " + afterText));
        this.registerCouldMatcher((base.isEmpty() ? "" : base + " ") + optional + (afterText.isEmpty() ? "" : " " + afterText));
    }

    private boolean couldMatchSwitches(ScriptPath path) {
        for (String switchName : path.switches.keySet()) {
            if (globalSwitches.contains(switchName) || this.eventData.localSwitches.contains(switchName)) continue;
            ScriptEvent.addPossibleCouldMatchFailReason("unrecognized switch name", switchName);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean couldMatch(ScriptPath path) {
        if (this.eventData.couldMatchers.isEmpty()) {
            throw new UnsupportedOperationException("CouldMatch not implemented for event '" + this.getName() + "'! Report this error to the Denizen developers!");
        }
        try {
            Iterator<ScriptEventCouldMatcher> iterator = this.eventData.couldMatchers.iterator();
            while (iterator.hasNext()) {
                ScriptEventCouldMatcher matcher;
                currentCouldMatcher = matcher = iterator.next();
                if (!matcher.doesMatch(path)) continue;
                boolean bl = this.couldMatchSwitches(path);
                return bl;
            }
        }
        finally {
            currentCouldMatcher = null;
        }
        return false;
    }

    public boolean matches(ScriptPath path) {
        return true;
    }

    public abstract String getName();

    public ScriptEvent fire() {
        ScriptEvent copy = this.clone();
        ++this.eventData.stats_fires;
        for (ScriptPath path : this.eventPaths) {
            try {
                if (!ScriptEvent.matchesScript(copy, path)) continue;
                if (path.fireAfter) {
                    ScriptPath finalPath = path;
                    DenizenCore.schedule(new OneTimeSchedulable(() -> copy.run(finalPath), 0.01f));
                    continue;
                }
                copy.run(path);
            }
            catch (Exception e) {
                Debug.echoError("Matching script " + path.container.getName() + " event path:" + path.event + ":::");
                Debug.echoError(e);
            }
        }
        return copy;
    }

    public void run(ScriptPath path) {
        try {
            ++this.eventData.stats_scriptFires;
            if (path.container.shouldDebug()) {
                Debug.echoDebug((Debuggable)path.container, "<Y>Running script event '<A>" + this.getName() + "<Y>', event='<A>" + (path.fireAfter ? "after " : "on ") + path.event + "<Y>' for script '<A>" + path.container.getName() + "<Y>'");
            }
            if (path.set == null) {
                return;
            }
            List<ScriptEntry> entries = ScriptContainer.cleanDup(this.getScriptEntryData(), path.set);
            InstantQueue queue = new InstantQueue(path.container.getName());
            queue.addEntries(entries);
            queue.setContextSource(this);
            if (!path.fireAfter) {
                queue.determinationTarget = o -> this.handleBaseDetermination(path, o);
            }
            queue.start(true);
            this.eventData.stats_nanoTimes += System.nanoTime() - queue.startTime;
        }
        catch (Exception e) {
            Debug.echoError("Handling script " + path.container.getName() + " path:" + path.event + ":::");
            Debug.echoError(e);
        }
    }

    public TagContext getTagContext(ScriptPath path) {
        TagContext context = this.getScriptEntryData().getTagContext().clone();
        context.script = new ScriptTag(path.container);
        context.debug = path.container.shouldDebug();
        return context;
    }

    @Override
    public ObjectTag getContext(String name) {
        switch (name) {
            case "cancelled": {
                return new ElementTag(this.cancelled);
            }
            case "event_name": {
                return new ElementTag(this.getName());
            }
        }
        return null;
    }

    public String toString() {
        return this.getName();
    }

    public static boolean isAdvancedMatchable(String input) {
        return input.startsWith("regex:") || CoreUtilities.contains(input, '|') || CoreUtilities.contains(input, '*') || input.startsWith("!");
    }

    public static MatchHelper createMatcher(String input) {
        MatchHelper result = knownMatchers.get(input);
        if (result != null) {
            return result;
        }
        if (input.startsWith("!")) {
            result = new InverseMatchHelper(ScriptEvent.createMatcher(input.substring(1)));
        } else if (input.startsWith("regex:")) {
            result = new RegexMatchHelper(input.substring("regex:".length()));
        } else if (CoreUtilities.contains(input, '|')) {
            String toSplit = input;
            if (toSplit.startsWith("li@")) {
                toSplit = toSplit.substring("li@".length());
            }
            toSplit = CoreUtilities.replace(toSplit, "el@", "");
            List<String> split = CoreUtilities.split(toSplit, '|');
            MatchHelper[] matchers = new MatchHelper[split.size()];
            for (int i = 0; i < split.size(); ++i) {
                matchers[i] = ScriptEvent.createMatcher(split.get(i));
            }
            result = new MultipleMatchesHelper(matchers);
        } else {
            int asterisk = input.indexOf(42);
            result = asterisk != -1 ? (input.length() == 1 ? new AlwaysMatchHelper() : (asterisk == 0 && input.indexOf(42, 1) == -1 ? new PrefixAsteriskMatchHelper(input.substring(1)) : (asterisk == input.length() - 1 ? new PostfixAsteriskMatchHelper(input.substring(0, input.length() - 1)) : new MultipleAsteriskMatchHelper(CoreUtilities.split(CoreUtilities.toLowerCase(input), '*').toArray(new String[0]))))) : new ExactMatchHelper(input);
        }
        knownMatchers.put(input, result);
        return result;
    }

    public static boolean runGenericCheck(String matchableValue, String trueValue) {
        if (matchableValue == null) {
            return false;
        }
        trueValue = CoreUtilities.toLowerCase(trueValue);
        MatchHelper matcher = ScriptEvent.createMatcher(matchableValue);
        return matcher.doesMatch(trueValue);
    }

    public static boolean runGenericSwitchCheck(ScriptPath path, String switchName, String value) {
        String with = path.switches.get(switchName);
        if (with == null) {
            return true;
        }
        if (value == null) {
            return false;
        }
        value = CoreUtilities.toLowerCase(value);
        MatchHelper matcher = ScriptEvent.createMatcher(with);
        return matcher.doesMatch(value);
    }

    public static boolean coreFlaggedCheck(String flagged, AbstractFlagTracker tracker) {
        if (flagged == null) {
            return true;
        }
        if (tracker == null) {
            return false;
        }
        for (String flag : CoreUtilities.split(flagged, '|')) {
            if (!(flag.startsWith("!") ? tracker.hasFlag(flag.substring(1)) : !tracker.hasFlag(flag))) continue;
            return false;
        }
        return true;
    }

    public static class InternalEventData {
        public long stats_fires = 0L;
        public long stats_scriptFires = 0L;
        public long stats_nanoTimes = 0L;
        public ArrayList<ScriptEventCouldMatcher> couldMatchers = new ArrayList();
        public HashSet<String> localSwitches = new HashSet();
        public boolean needsLegacy = false;
    }

    public static class ScriptPath {
        public ScriptContainer container;
        public String event;
        public String eventLower;
        public String rawContainerPath;
        public int priority = 0;
        public ScriptEntrySet set;
        public Boolean switch_cancelled;
        public Boolean switch_ignoreCancelled;
        public HashMap<String, String> switches = new HashMap();
        public List<String> rawSwitches = new ArrayList<String>();
        public String[] eventArgs;
        public String[] eventArgsLower;
        public String[] rawEventArgs;
        public List<ScriptEvent> matches = new ArrayList<ScriptEvent>();
        public boolean fireAfter = false;
        public List<String> matchFailReasons = null;
        public double switch_chance;
        public List<String> switch_serverFlagged;
        public static HashSet<String> notSwitches = new HashSet<String>(Collections.singleton("regex"));

        public String rawEventArgAt(int index) {
            return index < this.rawEventArgs.length ? this.rawEventArgs[index] : "";
        }

        public String eventArgAt(int index) {
            return index < this.eventArgs.length ? this.eventArgs[index] : "";
        }

        public String eventArgLowerAt(int index) {
            return index < this.eventArgsLower.length ? this.eventArgsLower[index] : "";
        }

        @Deprecated
        public final boolean eventArgsLowEqualStartingAt(int index, String a, String b) {
            return this.eventArgLowerAt(index).equals(a) && this.eventArgLowerAt(index + 1).equals(b);
        }

        public boolean checkSwitch(String key, String value) {
            String pathValue = this.switches.get(key);
            if (pathValue == null) {
                return true;
            }
            return CoreUtilities.equalsIgnoreCase(pathValue, value);
        }

        public boolean tryObjectSwitch(String key, ObjectTag obj) {
            String val = this.switches.get(key);
            if (val == null) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            return obj.tryAdvancedMatcher(val);
        }

        public ScriptPath(ScriptContainer container, String event, String rawContainerPath) {
            this.event = event;
            this.rawContainerPath = rawContainerPath;
            this.rawEventArgs = CoreUtilities.split(event, ' ').toArray(new String[0]);
            this.container = container;
            ArrayList<String> eventLabel = new ArrayList<String>();
            for (String possible : CoreUtilities.split(event, ' ').toArray(new String[0])) {
                List<String> split = CoreUtilities.split(possible, ':', 2);
                String low = CoreUtilities.toLowerCase(split.get(0));
                if (split.size() > 1 && !ArgumentHelper.matchesInteger(split.get(0)) && !notSwitches.contains(low)) {
                    this.switches.put(low, split.get(1));
                    this.rawSwitches.add(low + ":" + split.get(1));
                    continue;
                }
                eventLabel.add(possible);
            }
            this.eventLower = CoreUtilities.toLowerCase(String.join((CharSequence)" ", eventLabel));
            this.eventArgs = eventLabel.toArray(new String[0]);
            this.eventArgsLower = CoreUtilities.split(this.eventLower, ' ').toArray(new String[0]);
            this.switch_cancelled = this.switches.containsKey("cancelled") ? Boolean.valueOf(CoreUtilities.equalsIgnoreCase(this.switches.get("cancelled"), "true")) : null;
            this.switch_ignoreCancelled = this.switches.containsKey("ignorecancelled") ? Boolean.valueOf(CoreUtilities.equalsIgnoreCase(this.switches.get("ignorecancelled"), "true")) : null;
            this.switch_serverFlagged = this.switches.containsKey("server_flagged") ? CoreUtilities.split(this.switches.get("server_flagged"), '|') : null;
            this.switch_chance = this.switches.containsKey("chance") ? new ElementTag(this.switches.get("chance")).asDouble() : 0.0;
            this.set = container.getSetFor("events." + rawContainerPath);
            if (this.set == null || this.set.entries == null) {
                Debug.echoError("Invalid script (formatting error?) in container '" + container.getName() + " at event '" + rawContainerPath + "'.");
            }
        }

        public String toString() {
            return this.container.getName() + ".events.on " + this.event;
        }
    }

    public static abstract class MatchHelper {
        public abstract boolean doesMatch(String var1);

        public boolean doesMatch(String input, ExactCheckerInterface exactChecker) {
            return this.doesMatch(input);
        }

        @FunctionalInterface
        public static interface ExactCheckerInterface {
            public boolean check(String var1);
        }
    }

    public static class InverseMatchHelper
    extends MatchHelper {
        public MatchHelper matcher;

        public InverseMatchHelper(MatchHelper matcher) {
            this.matcher = matcher;
        }

        @Override
        public boolean doesMatch(String input) {
            return !this.matcher.doesMatch(input);
        }

        @Override
        public boolean doesMatch(String input, MatchHelper.ExactCheckerInterface checker) {
            return !this.matcher.doesMatch(input, checker);
        }
    }

    public static class RegexMatchHelper
    extends MatchHelper {
        public Pattern regex;

        public RegexMatchHelper(String regex) {
            this.regex = Pattern.compile(regex, 2);
        }

        @Override
        public boolean doesMatch(String input) {
            return this.regex.matcher(input).matches();
        }
    }

    public static class MultipleMatchesHelper
    extends MatchHelper {
        public MatchHelper[] matches;

        public MultipleMatchesHelper(MatchHelper[] matches) {
            this.matches = matches;
        }

        @Override
        public boolean doesMatch(String input) {
            for (MatchHelper match : this.matches) {
                if (!match.doesMatch(input)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean doesMatch(String input, MatchHelper.ExactCheckerInterface checker) {
            for (MatchHelper match : this.matches) {
                if (!match.doesMatch(input, checker)) continue;
                return true;
            }
            return false;
        }
    }

    public static class AlwaysMatchHelper
    extends MatchHelper {
        @Override
        public boolean doesMatch(String input) {
            return true;
        }
    }

    public static class PrefixAsteriskMatchHelper
    extends MatchHelper {
        public String text;

        public PrefixAsteriskMatchHelper(String text) {
            this.text = CoreUtilities.toLowerCase(text);
        }

        @Override
        public boolean doesMatch(String input) {
            return CoreUtilities.toLowerCase(input).endsWith(this.text);
        }
    }

    public static class PostfixAsteriskMatchHelper
    extends MatchHelper {
        public String text;

        public PostfixAsteriskMatchHelper(String text) {
            this.text = CoreUtilities.toLowerCase(text);
        }

        @Override
        public boolean doesMatch(String input) {
            return CoreUtilities.toLowerCase(input).startsWith(this.text);
        }
    }

    public static class MultipleAsteriskMatchHelper
    extends MatchHelper {
        public String[] texts;

        public MultipleAsteriskMatchHelper(String[] texts) {
            this.texts = texts;
        }

        @Override
        public boolean doesMatch(String input) {
            int index = 0;
            if (!(input = CoreUtilities.toLowerCase(input)).startsWith(this.texts[0]) || !input.endsWith(this.texts[this.texts.length - 1])) {
                return false;
            }
            for (String text : this.texts) {
                if (text.isEmpty()) continue;
                if ((index = input.indexOf(text, index)) == -1) {
                    return false;
                }
                index += text.length();
            }
            return true;
        }
    }

    public static class ExactMatchHelper
    extends MatchHelper {
        public String text;

        public ExactMatchHelper(String text) {
            this.text = CoreUtilities.toLowerCase(text);
        }

        @Override
        public boolean doesMatch(String input) {
            return CoreUtilities.equalsIgnoreCase(this.text, input);
        }

        @Override
        public boolean doesMatch(String input, MatchHelper.ExactCheckerInterface exactChecker) {
            return CoreUtilities.equalsIgnoreCase(this.text, input) || exactChecker.check(this.text);
        }
    }
}

