/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.tags.core;

import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.tags.TagManager;
import com.denizenscript.denizencore.tags.TagRunnable;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.DefinitionProvider;
import com.denizenscript.denizencore.utilities.debugging.Debug;

public class DefinitionTagBase {
    public DefinitionTagBase() {
        TagRunnable.BaseInterface<ObjectTag> defTag = attribute -> {
            if (!attribute.hasParam()) {
                Debug.echoError("Invalid definition tag, no context specified!");
                return null;
            }
            String defName = attribute.getParam();
            DefinitionProvider definitionProvider = attribute.context.definitionProvider;
            if (definitionProvider == null) {
                Debug.echoError("No definitions are provided in this tag's context!");
                return null;
            }
            ObjectTag def = definitionProvider.getDefinitionObject(defName);
            if (def == null) {
                attribute.echoError("Invalid definition name '" + defName + "'.");
                return null;
            }
            if (attribute.attributes.length == 1) {
                return def.refreshState();
            }
            return CoreUtilities.fixType(def, attribute.context);
        };
        TagManager.registerTagHandler(ObjectTag.class, "def", defTag);
        TagManager.registerTagHandler(ObjectTag.class, "definition", defTag);
        TagManager.registerTagHandler(ObjectTag.class, "", defTag);
    }
}

