/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.v1_19.helpers;

import com.denizenscript.denizen.nms.interfaces.FishingHelper;
import com.denizenscript.denizen.nms.v1_19.ReflectionMappingsInfo;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.ReflectionHelper;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.lang.reflect.Field;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityFishingHook;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.IMaterial;
import net.minecraft.world.level.World;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.LootTableRegistry;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_19_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_19_R1.entity.CraftFishHook;
import org.bukkit.craftbukkit.v1_19_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_19_R1.inventory.CraftItemStack;
import org.bukkit.entity.FishHook;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.inventory.ItemStack;

public class FishingHelperImpl
implements FishingHelper {
    public static Field FISHING_HOOK_NIBBLE_SETTER = ReflectionHelper.getFields(EntityFishingHook.class).get(ReflectionMappingsInfo.FishingHook_nibble, Integer.TYPE);
    public static Field FISHING_HOOK_LURE_TIME_SETTER = ReflectionHelper.getFields(EntityFishingHook.class).get(ReflectionMappingsInfo.FishingHook_timeUntilLured, Integer.TYPE);
    public static Field FISHING_HOOK_HOOK_TIME_SETTER = ReflectionHelper.getFields(EntityFishingHook.class).get(ReflectionMappingsInfo.FishingHook_timeUntilHooked, Integer.TYPE);

    @Override
    public ItemStack getResult(FishHook fishHook, FishingHelper.CatchType catchType) {
        net.minecraft.world.item.ItemStack result = null;
        EntityFishingHook nmsHook = ((CraftFishHook)fishHook).getHandle();
        if (catchType == FishingHelper.CatchType.DEFAULT) {
            float f = ((CraftWorld)fishHook.getWorld()).getHandle().w.i();
            int i = EnchantmentManager.h((EntityLiving)nmsHook.i());
            int j = EnchantmentManager.a((Enchantment)Enchantments.C, (EntityLiving)nmsHook.i());
            float f1 = 0.1f - (float)i * 0.025f - (float)j * 0.01f;
            float f2 = 0.05f + (float)i * 0.01f - (float)j * 0.01f;
            f1 = MathHelper.a((float)f1, (float)0.0f, (float)1.0f);
            f2 = MathHelper.a((float)f2, (float)0.0f, (float)1.0f);
            result = f < f1 ? this.catchRandomJunk(nmsHook) : ((f -= f1) < f2 ? this.catchRandomTreasure(nmsHook) : this.catchRandomFish(nmsHook));
        } else if (catchType == FishingHelper.CatchType.JUNK) {
            result = this.catchRandomJunk(nmsHook);
        } else if (catchType == FishingHelper.CatchType.TREASURE) {
            result = this.catchRandomTreasure(nmsHook);
        } else if (catchType == FishingHelper.CatchType.FISH) {
            result = this.catchRandomFish(nmsHook);
        }
        if (result != null) {
            return CraftItemStack.asBukkitCopy((net.minecraft.world.item.ItemStack)result);
        }
        return null;
    }

    public net.minecraft.world.item.ItemStack getRandomReward(EntityFishingHook hook, MinecraftKey key) {
        WorldServer worldServer = (WorldServer)hook.s;
        LootTableInfo.Builder playerFishEvent2 = new LootTableInfo.Builder(worldServer);
        LootTableRegistry registry = ((WorldServer)hook.s).n().aH();
        LootTableInfo info = playerFishEvent2.b(LootContextParameters.f, (Object)new Vec3D(hook.df(), hook.dh(), hook.dl())).b(LootContextParameters.i, (Object)new net.minecraft.world.item.ItemStack((IMaterial)Items.pe)).a(LootContextParameterSets.e);
        ObjectArrayList itemStacks = registry.a(key).a(info);
        return (net.minecraft.world.item.ItemStack)itemStacks.get(worldServer.w.a(itemStacks.size()));
    }

    @Override
    public FishHook spawnHook(Location location, Player player) {
        WorldServer nmsWorld = ((CraftWorld)location.getWorld()).getHandle();
        EntityFishingHook hook = new EntityFishingHook((EntityHuman)((CraftPlayer)player).getHandle(), (World)nmsWorld, 0, 0);
        nmsWorld.addFreshEntity((Entity)hook, CreatureSpawnEvent.SpawnReason.CUSTOM);
        return (FishHook)hook.getBukkitEntity();
    }

    private net.minecraft.world.item.ItemStack catchRandomJunk(EntityFishingHook fishHook) {
        return this.getRandomReward(fishHook, LootTableRegistry.aj);
    }

    private net.minecraft.world.item.ItemStack catchRandomTreasure(EntityFishingHook fishHook) {
        return this.getRandomReward(fishHook, LootTableRegistry.ak);
    }

    private net.minecraft.world.item.ItemStack catchRandomFish(EntityFishingHook fishHook) {
        return this.getRandomReward(fishHook, LootTableRegistry.al);
    }

    @Override
    public FishHook getHookFrom(Player player) {
        EntityFishingHook hook = ((CraftPlayer)player).getHandle().cn;
        if (hook == null) {
            return null;
        }
        return (FishHook)hook.getBukkitEntity();
    }

    @Override
    public void setNibble(FishHook hook, int ticks) {
        EntityFishingHook nmsEntity = ((CraftFishHook)hook).getHandle();
        try {
            FISHING_HOOK_NIBBLE_SETTER.setInt(nmsEntity, ticks);
        }
        catch (Throwable ex) {
            Debug.echoError(ex);
        }
    }

    @Override
    public void setHookTime(FishHook hook, int ticks) {
        EntityFishingHook nmsEntity = ((CraftFishHook)hook).getHandle();
        try {
            FISHING_HOOK_HOOK_TIME_SETTER.setInt(nmsEntity, ticks);
        }
        catch (Throwable ex) {
            Debug.echoError(ex);
        }
    }

    @Override
    public int getLureTime(FishHook hook) {
        EntityFishingHook nmsEntity = ((CraftFishHook)hook).getHandle();
        try {
            return FISHING_HOOK_LURE_TIME_SETTER.getInt(nmsEntity);
        }
        catch (Throwable ex) {
            Debug.echoError(ex);
            return -1;
        }
    }

    @Override
    public void setLureTime(FishHook hook, int ticks) {
        EntityFishingHook nmsEntity = ((CraftFishHook)hook).getHandle();
        try {
            FISHING_HOOK_LURE_TIME_SETTER.setInt(nmsEntity, ticks);
        }
        catch (Throwable ex) {
            Debug.echoError(ex);
        }
    }
}

