/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.player;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.utilities.FormattedTextHelper;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizen.utilities.packets.NetworkInterceptHelper;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.chat.ComponentSerializer;

public class PlayerReceivesMessageScriptEvent
extends BukkitScriptEvent {
    public static PlayerReceivesMessageScriptEvent instance;
    public ElementTag message;
    public ElementTag rawJson;
    public ElementTag system;
    public boolean modified;
    public PlayerTag player;
    public boolean loaded;

    public PlayerReceivesMessageScriptEvent() {
        instance = this;
    }

    public void reset() {
        this.player = null;
        this.message = null;
        this.rawJson = null;
        this.system = null;
        this.cancelled = false;
        this.modified = false;
    }

    @Override
    public boolean couldMatch(ScriptEvent.ScriptPath path) {
        return path.eventLower.startsWith("player receives message");
    }

    @Override
    public String getName() {
        return "PlayerReceivesMessage";
    }

    @Override
    public void init() {
        NetworkInterceptHelper.enable();
        this.loaded = true;
    }

    @Override
    public void destroy() {
        this.loaded = false;
    }

    @Override
    public boolean applyDetermination(ScriptEvent.ScriptPath path, ObjectTag determinationObj) {
        if (determinationObj instanceof ElementTag) {
            String determination = determinationObj.toString();
            String lower = CoreUtilities.toLowerCase(determination);
            if (lower.startsWith("message:")) {
                this.message = new ElementTag(determination.substring("message:".length()), true);
                this.rawJson = new ElementTag(ComponentSerializer.toString((BaseComponent[])FormattedTextHelper.parse(this.message.asString(), ChatColor.WHITE)), true);
                this.modified = true;
                return true;
            }
            if (lower.startsWith("raw_json:")) {
                this.rawJson = new ElementTag(determination.substring("raw_json:".length()));
                this.message = new ElementTag(FormattedTextHelper.stringify(ComponentSerializer.parse((String)this.rawJson.asString()), ChatColor.WHITE), true);
                this.modified = true;
                return true;
            }
        }
        return super.applyDetermination(path, determinationObj);
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(this.player, null);
    }

    @Override
    public ObjectTag getContext(String name) {
        if (name.equals("message")) {
            return this.message;
        }
        if (name.equals("raw_json")) {
            return this.rawJson;
        }
        if (name.equals("system_message")) {
            return this.system;
        }
        return super.getContext(name);
    }
}

