/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.paper.events;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import com.destroystokyo.paper.event.entity.EntityPathfindEvent;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;

public class EntityPathfindScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static EntityPathfindScriptEvent instance;
    public EntityTag entity;
    public EntityTag target;
    public EntityPathfindEvent event;

    public EntityPathfindScriptEvent() {
        instance = this;
        this.registerCouldMatcher("<entity> pathfinds");
        this.registerSwitches(new String[]{"to", "at"});
    }

    public boolean matches(ScriptEvent.ScriptPath path) {
        if (!this.entity.tryAdvancedMatcher(path.eventArgLowerAt(0))) {
            return false;
        }
        if (!this.runInCheck(path, (Location)this.entity.getLocation())) {
            return false;
        }
        if (!this.runInCheck(path, this.event.getLoc(), "to")) {
            return false;
        }
        if (!path.tryObjectSwitch("at", (ObjectTag)this.target)) {
            return false;
        }
        return super.matches(path);
    }

    public String getName() {
        return "EntityPathfinds";
    }

    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(this.target);
    }

    public ObjectTag getContext(String name) {
        if (name.equals("entity")) {
            return this.entity.getDenizenObject();
        }
        if (name.equals("target") && this.target != null) {
            return this.target.getDenizenObject();
        }
        if (name.equals("location")) {
            return new LocationTag(this.event.getLoc());
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onEntityPathfind(EntityPathfindEvent event) {
        this.event = event;
        this.entity = new EntityTag(event.getEntity());
        Entity target = event.getTargetEntity();
        this.target = target != null ? new EntityTag(target) : null;
        this.fire((Event)event);
    }
}

