/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.scripts.containers.core.EnchantmentScriptContainer;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.DenizenCore;
import com.denizenscript.denizencore.flags.AbstractFlagTracker;
import com.denizenscript.denizencore.flags.FlaggableObject;
import com.denizenscript.denizencore.flags.RedirectionFlagTracker;
import com.denizenscript.denizencore.objects.Fetchable;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.MapTag;
import com.denizenscript.denizencore.objects.core.ScriptTag;
import com.denizenscript.denizencore.scripts.ScriptRegistry;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.tags.ObjectTagProcessor;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.utilities.CoreConfiguration;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import org.bukkit.NamespacedKey;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.event.entity.EntityDamageEvent;

public class EnchantmentTag
implements ObjectTag,
FlaggableObject {
    public Enchantment enchantment;
    private String prefix = "Enchantment";
    public static ObjectTagProcessor<EnchantmentTag> tagProcessor = new ObjectTagProcessor();

    @Deprecated
    public static EnchantmentTag valueOf(String string) {
        return EnchantmentTag.valueOf(string, null);
    }

    @Fetchable(value="enchantment")
    public static EnchantmentTag valueOf(String string, TagContext context) {
        NamespacedKey key;
        Enchantment ench;
        if (string == null) {
            return null;
        }
        if ((string = CoreUtilities.toLowerCase(string)).startsWith("enchantment@")) {
            string = string.substring("enchantment@".length());
        }
        if ((ench = Enchantment.getByKey((NamespacedKey)(key = Utilities.parseNamespacedKey(string)))) == null) {
            ench = Enchantment.getByName((String)string.toUpperCase());
        }
        if (ench == null) {
            ench = Enchantment.getByKey((NamespacedKey)new NamespacedKey("denizen", Utilities.cleanseNamespaceID(string)));
        }
        if (ench == null && ScriptRegistry.containsScript(string, EnchantmentScriptContainer.class)) {
            ench = ScriptRegistry.getScriptContainerAs((String)string, EnchantmentScriptContainer.class).enchantment;
        }
        if (ench == null) {
            if (context == null || context.debug || CoreConfiguration.debugOverride) {
                Debug.echoError("Unknown enchantment '" + string + "'");
            }
            return null;
        }
        return new EnchantmentTag(ench);
    }

    public static boolean matches(String arg) {
        if (CoreUtilities.toLowerCase(arg).startsWith("enchantment@")) {
            return true;
        }
        return EnchantmentTag.valueOf(arg, CoreUtilities.noDebugContext) != null;
    }

    public EnchantmentTag(Enchantment enchantment) {
        this.enchantment = enchantment;
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public boolean isUnique() {
        return true;
    }

    @Override
    public String identify() {
        return "enchantment@" + this.getCleanName();
    }

    @Override
    public String identifySimple() {
        return this.identify();
    }

    public String toString() {
        return this.identify();
    }

    @Override
    public Object getJavaObject() {
        return this.enchantment;
    }

    @Override
    public EnchantmentTag setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    public String getCleanName() {
        NamespacedKey key = this.enchantment.getKey();
        if (key.getNamespace().equals("minecraft") || key.getNamespace().equals("denizen")) {
            return key.getKey();
        }
        return key.toString();
    }

    @Override
    public AbstractFlagTracker getFlagTracker() {
        return new RedirectionFlagTracker(DenizenCore.serverFlagMap, "__enchantments." + this.getCleanName().replace(".", "&dot"));
    }

    @Override
    public void reapplyTracker(AbstractFlagTracker tracker) {
    }

    public static void registerTags() {
        AbstractFlagTracker.registerFlagHandlers(tagProcessor);
        tagProcessor.registerTag(ElementTag.class, "name", (attribute, object) -> new ElementTag(object.getCleanName()), new String[0]);
        tagProcessor.registerTag(ElementTag.class, "key", (attribute, object) -> new ElementTag(object.enchantment.getKey().toString()), new String[0]);
        tagProcessor.registerTag(ElementTag.class, "full_name", (attribute, object) -> {
            if (!attribute.hasParam()) {
                return null;
            }
            return new ElementTag(NMSHandler.enchantmentHelper.getFullName(object.enchantment, attribute.getIntParam()));
        }, new String[0]);
        tagProcessor.registerTag(ScriptTag.class, "script", (attribute, object) -> {
            if (!object.enchantment.getKey().getNamespace().equals("denizen")) {
                return null;
            }
            EnchantmentScriptContainer.EnchantmentReference ref = EnchantmentScriptContainer.registeredEnchantmentContainers.get(object.enchantment.getKey().getKey());
            if (ref == null) {
                return null;
            }
            return new ScriptTag(ref.script);
        }, new String[0]);
        tagProcessor.registerTag(ElementTag.class, "min_level", (attribute, object) -> new ElementTag(object.enchantment.getStartLevel()), new String[0]);
        tagProcessor.registerTag(ElementTag.class, "max_level", (attribute, object) -> new ElementTag(object.enchantment.getMaxLevel()), new String[0]);
        tagProcessor.registerTag(ElementTag.class, "treasure_only", (attribute, object) -> new ElementTag(object.enchantment.isTreasure()), new String[0]);
        tagProcessor.registerTag(ElementTag.class, "is_tradable", (attribute, object) -> new ElementTag(NMSHandler.enchantmentHelper.isTradable(object.enchantment)), new String[0]);
        tagProcessor.registerTag(ElementTag.class, "is_discoverable", (attribute, object) -> new ElementTag(NMSHandler.enchantmentHelper.isDiscoverable(object.enchantment)), new String[0]);
        tagProcessor.registerTag(ElementTag.class, "is_curse", (attribute, object) -> new ElementTag(NMSHandler.enchantmentHelper.isCurse(object.enchantment)), new String[0]);
        tagProcessor.registerTag(ElementTag.class, "category", (attribute, object) -> new ElementTag(object.enchantment.getItemTarget().name()), new String[0]);
        tagProcessor.registerTag(ElementTag.class, "rarity", (attribute, object) -> new ElementTag(NMSHandler.enchantmentHelper.getRarity(object.enchantment)), new String[0]);
        tagProcessor.registerTag(ElementTag.class, "can_enchant", (attribute, object) -> {
            if (!attribute.hasParam()) {
                return null;
            }
            return new ElementTag(object.enchantment.canEnchantItem(attribute.paramAsType(ItemTag.class).getItemStack()));
        }, new String[0]);
        tagProcessor.registerTag(ElementTag.class, "is_compatible", (attribute, object) -> {
            if (!attribute.hasParam()) {
                return null;
            }
            return new ElementTag(!object.enchantment.conflictsWith(attribute.paramAsType(EnchantmentTag.class).enchantment));
        }, new String[0]);
        tagProcessor.registerTag(ElementTag.class, "min_cost", (attribute, object) -> {
            if (!attribute.hasParam()) {
                return null;
            }
            return new ElementTag(NMSHandler.enchantmentHelper.getMinCost(object.enchantment, attribute.getIntParam()));
        }, new String[0]);
        tagProcessor.registerTag(ElementTag.class, "max_cost", (attribute, object) -> {
            if (!attribute.hasParam()) {
                return null;
            }
            return new ElementTag(NMSHandler.enchantmentHelper.getMaxCost(object.enchantment, attribute.getIntParam()));
        }, new String[0]);
        tagProcessor.registerTag(ElementTag.class, MapTag.class, "damage_bonus", (attribute, object, map) -> {
            ElementTag level = map.getElement("level");
            ElementTag type = map.getElement("type");
            if (level == null || type == null) {
                attribute.echoError("Invalid MapTag input to damage_bonus - missing 'level' or 'type'");
                return null;
            }
            return new ElementTag(NMSHandler.enchantmentHelper.getDamageBonus(object.enchantment, level.asInt(), CoreUtilities.toLowerCase(type.toString())));
        }, new String[0]);
        tagProcessor.registerTag(ElementTag.class, MapTag.class, "damage_protection", (attribute, object, map) -> {
            EntityDamageEvent.DamageCause cause;
            ElementTag level = map.getRequiredObjectAs("level", ElementTag.class, attribute);
            ElementTag type = map.getRequiredObjectAs("type", ElementTag.class, attribute);
            if (level == null || type == null) {
                return null;
            }
            try {
                cause = EntityDamageEvent.DamageCause.valueOf((String)type.toString().toUpperCase());
            }
            catch (IllegalArgumentException ex) {
                attribute.echoError("Invalid MapTag input to damage_protection - cause '" + type + "' is not a valid DamageCause.");
                return null;
            }
            EntityTag attacker = map.getObjectAs("attacker", EntityTag.class, attribute.context);
            return new ElementTag(NMSHandler.enchantmentHelper.getDamageProtection(object.enchantment, level.asInt(), cause, attacker == null ? null : attacker.getBukkitEntity()));
        }, new String[0]);
    }

    @Override
    public ObjectTag getObjectAttribute(Attribute attribute) {
        return tagProcessor.getObjectAttribute(this, attribute);
    }
}

