/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.abstracts.BiomeNMS;
import com.denizenscript.denizen.objects.BiomeTag;
import com.denizenscript.denizen.objects.ChunkTag;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.NPCTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.utilities.BukkitImplDeprecations;
import com.denizenscript.denizen.utilities.Settings;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizen.utilities.flags.WorldFlagHandler;
import com.denizenscript.denizencore.flags.AbstractFlagTracker;
import com.denizenscript.denizencore.flags.FlaggableObject;
import com.denizenscript.denizencore.objects.Adjustable;
import com.denizenscript.denizencore.objects.Fetchable;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.DurationTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.core.MapTag;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.tags.ObjectTagProcessor;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.tags.TagRunnable;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.npc.NPC;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Difficulty;
import org.bukkit.GameRule;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.boss.DragonBattle;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.util.BoundingBox;

public class WorldTag
implements ObjectTag,
Adjustable,
FlaggableObject {
    private String prefix;
    String world_name;
    public static ObjectTagProcessor<WorldTag> tagProcessor = new ObjectTagProcessor();

    public static WorldTag mirrorBukkitWorld(World world) {
        if (world == null) {
            return null;
        }
        return new WorldTag(world);
    }

    @Deprecated
    public static WorldTag valueOf(String string) {
        return WorldTag.valueOf(string, null);
    }

    @Fetchable(value="w")
    public static WorldTag valueOf(String string, TagContext context) {
        return WorldTag.valueOf(string, context == null || context.showErrors());
    }

    public static WorldTag valueOf(String string, boolean announce) {
        if (string == null) {
            return null;
        }
        string = string.replace("w@", "");
        World returnable = null;
        for (World world : Bukkit.getWorlds()) {
            if (!world.getName().equalsIgnoreCase(string)) continue;
            returnable = world;
        }
        if (returnable != null) {
            return new WorldTag(returnable);
        }
        if (announce) {
            Debug.echoError("Invalid World! '" + string + "' could not be found.");
        }
        return null;
    }

    public static boolean matches(String arg) {
        arg = arg.replace("w@", "");
        World returnable = null;
        for (World world : Bukkit.getWorlds()) {
            if (!world.getName().equalsIgnoreCase(arg)) continue;
            returnable = world;
        }
        return returnable != null;
    }

    @Override
    public AbstractFlagTracker getFlagTracker() {
        return WorldFlagHandler.worldFlagTrackers.get(this.getName());
    }

    @Override
    public void reapplyTracker(AbstractFlagTracker tracker) {
    }

    @Override
    public String getReasonNotFlaggable() {
        return "is the world loaded?";
    }

    public World getWorld() {
        return Bukkit.getWorld((String)this.world_name);
    }

    public String getName() {
        return this.world_name;
    }

    public List<Entity> getEntities() {
        return this.getWorld().getEntities();
    }

    public List<Entity> getEntitiesForTag() {
        NMSHandler.chunkHelper.changeChunkServerThread(this.getWorld());
        try {
            List list = this.getWorld().getEntities();
            return list;
        }
        finally {
            NMSHandler.chunkHelper.restoreServerThread(this.getWorld());
        }
    }

    public final Collection<Entity> getPossibleEntitiesForBoundary(BoundingBox box) {
        if (box.getWidthX() > 512.0 || box.getWidthZ() > 512.0) {
            return this.getWorld().getEntities();
        }
        return this.getWorld().getNearbyEntities(box);
    }

    public Collection<Entity> getPossibleEntitiesForBoundaryForTag(BoundingBox box) {
        NMSHandler.chunkHelper.changeChunkServerThread(this.getWorld());
        try {
            Collection<Entity> collection = this.getPossibleEntitiesForBoundary(box);
            return collection;
        }
        finally {
            NMSHandler.chunkHelper.restoreServerThread(this.getWorld());
        }
    }

    public List<LivingEntity> getLivingEntitiesForTag() {
        NMSHandler.chunkHelper.changeChunkServerThread(this.getWorld());
        try {
            List list = this.getWorld().getLivingEntities();
            return list;
        }
        finally {
            NMSHandler.chunkHelper.restoreServerThread(this.getWorld());
        }
    }

    public WorldTag(World world) {
        this(null, world);
    }

    public WorldTag(String worldName) {
        this.prefix = "World";
        this.world_name = worldName;
    }

    public WorldTag(String prefix, World world) {
        this.prefix = prefix == null ? "World" : prefix;
        this.world_name = world.getName();
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public boolean isUnique() {
        return true;
    }

    @Override
    public String identify() {
        return "w@" + this.world_name;
    }

    @Override
    public String identifySimple() {
        return this.identify();
    }

    public String toString() {
        return this.identify();
    }

    @Override
    public Object getJavaObject() {
        return this.getWorld();
    }

    @Override
    public ObjectTag setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    public static void registerTags() {
        AbstractFlagTracker.registerFlagHandlers(tagProcessor);
        WorldTag.registerTag(ListTag.class, "entities", (attribute, object) -> {
            ListTag entities = new ListTag();
            String matcher = attribute.hasParam() ? attribute.getParam() : null;
            for (Entity entity : object.getEntitiesForTag()) {
                EntityTag current = new EntityTag(entity);
                if (matcher != null && !current.tryAdvancedMatcher(matcher)) continue;
                entities.addObject(current.getDenizenObject());
            }
            return entities;
        }, new String[0]);
        WorldTag.registerTag(ListTag.class, "living_entities", (attribute, object) -> {
            ListTag entities = new ListTag();
            for (Entity entity : object.getLivingEntitiesForTag()) {
                entities.addObject(new EntityTag(entity).getDenizenObject());
            }
            return entities;
        }, new String[0]);
        WorldTag.registerTag(ListTag.class, "players", (attribute, object) -> {
            ListTag players = new ListTag();
            for (Player player : object.getWorld().getPlayers()) {
                if (EntityTag.isNPC((Entity)player)) continue;
                players.addObject(new PlayerTag(player));
            }
            return players;
        }, new String[0]);
        WorldTag.registerTag(ListTag.class, "spawned_npcs", (attribute, object) -> {
            ListTag npcs = new ListTag();
            World thisWorld = object.getWorld();
            for (NPC npc : CitizensAPI.getNPCRegistry()) {
                if (!npc.isSpawned() || !npc.getStoredLocation().getWorld().equals(thisWorld)) continue;
                npcs.addObject(new NPCTag(npc));
            }
            return npcs;
        }, new String[0]);
        WorldTag.registerTag(ListTag.class, "npcs", (attribute, object) -> {
            ListTag npcs = new ListTag();
            World thisWorld = object.getWorld();
            for (NPC npc : CitizensAPI.getNPCRegistry()) {
                World world;
                Location location = npc.getStoredLocation();
                if (location == null || (world = location.getWorld()) == null || !world.equals(thisWorld)) continue;
                npcs.addObject(new NPCTag(npc));
            }
            return npcs;
        }, new String[0]);
        WorldTag.registerTag(ElementTag.class, "can_generate_structures", (attribute, object) -> new ElementTag(object.getWorld().canGenerateStructures()), new String[0]);
        WorldTag.registerTag(ListTag.class, "loaded_chunks", (attribute, object) -> {
            ListTag chunks = new ListTag();
            for (Chunk ent : object.getWorld().getLoadedChunks()) {
                chunks.addObject(new ChunkTag(ent));
            }
            return chunks;
        }, new String[0]);
        WorldTag.registerTag(ChunkTag.class, "random_loaded_chunk", (attribute, object) -> {
            BukkitImplDeprecations.worldRandomLoadedChunkTag.warn(attribute.context);
            int random = CoreUtilities.getRandom().nextInt(object.getWorld().getLoadedChunks().length);
            return new ChunkTag(object.getWorld().getLoadedChunks()[random]);
        }, new String[0]);
        WorldTag.registerTag(ElementTag.class, "sea_level", (attribute, object) -> new ElementTag(object.getWorld().getSeaLevel()), new String[0]);
        WorldTag.registerTag(ElementTag.class, "max_height", (attribute, object) -> new ElementTag(object.getWorld().getMaxHeight()), new String[0]);
        WorldTag.registerTag(ElementTag.class, "min_height", (attribute, object) -> new ElementTag(object.getWorld().getMinHeight()), new String[0]);
        WorldTag.registerTag(LocationTag.class, "spawn_location", (attribute, object) -> new LocationTag(object.getWorld().getSpawnLocation()), new String[0]);
        WorldTag.registerTag(ElementTag.class, "world_type", (attribute, object) -> new ElementTag(object.getWorld().getWorldType().getName()), new String[0]);
        tagProcessor.registerTag(ElementTag.class, "name", (attribute, object) -> new ElementTag(object.world_name), new String[0]);
        WorldTag.registerTag(ElementTag.class, "seed", (attribute, object) -> new ElementTag(object.getWorld().getSeed()), new String[0]);
        WorldTag.registerTag(ElementTag.class, "allows_animals", (attribute, object) -> new ElementTag(object.getWorld().getAllowAnimals()), new String[0]);
        WorldTag.registerTag(ElementTag.class, "allows_monsters", (attribute, object) -> new ElementTag(object.getWorld().getAllowMonsters()), new String[0]);
        WorldTag.registerTag(ElementTag.class, "allows_pvp", (attribute, object) -> new ElementTag(object.getWorld().getPVP()), new String[0]);
        WorldTag.registerTag(ElementTag.class, "auto_save", (attribute, object) -> new ElementTag(object.getWorld().isAutoSave()), new String[0]);
        WorldTag.registerTag(ElementTag.class, "ambient_spawn_limit", (attribute, object) -> new ElementTag(object.getWorld().getAmbientSpawnLimit()), new String[0]);
        WorldTag.registerTag(ElementTag.class, "animal_spawn_limit", (attribute, object) -> new ElementTag(object.getWorld().getAnimalSpawnLimit()), new String[0]);
        WorldTag.registerTag(ElementTag.class, "monster_spawn_limit", (attribute, object) -> new ElementTag(object.getWorld().getMonsterSpawnLimit()), new String[0]);
        WorldTag.registerTag(ElementTag.class, "water_animal_spawn_limit", (attribute, object) -> new ElementTag(object.getWorld().getWaterAnimalSpawnLimit()), new String[0]);
        WorldTag.registerTag(ElementTag.class, "difficulty", (attribute, object) -> new ElementTag(object.getWorld().getDifficulty().name()), new String[0]);
        WorldTag.registerTag(ElementTag.class, "hardcore", (attribute, object) -> new ElementTag(object.getWorld().isHardcore()), new String[0]);
        WorldTag.registerTag(ElementTag.class, "keep_spawn", (attribute, object) -> new ElementTag(object.getWorld().getKeepSpawnInMemory()), new String[0]);
        WorldTag.registerTag(DurationTag.class, "ticks_per_animal_spawn", (attribute, object) -> new DurationTag(object.getWorld().getTicksPerAnimalSpawns()), new String[0]);
        WorldTag.registerTag(DurationTag.class, "ticks_per_monster_spawn", (attribute, object) -> new DurationTag(object.getWorld().getTicksPerMonsterSpawns()), new String[0]);
        WorldTag.registerTag(DurationTag.class, "duration_since_created", (attribute, object) -> new DurationTag(object.getWorld().getGameTime()), new String[0]);
        WorldTag.registerTag(ObjectTag.class, "time", (attribute, object) -> {
            if (attribute.startsWith("duration", 2)) {
                attribute.fulfill(1);
                return new DurationTag(object.getWorld().getTime());
            }
            if (attribute.startsWith("full", 2)) {
                attribute.fulfill(1);
                return new DurationTag(object.getWorld().getFullTime());
            }
            if (attribute.startsWith("period", 2)) {
                attribute.fulfill(1);
                long time = object.getWorld().getTime();
                String period = time >= 23000L ? "dawn" : (time >= 13500L ? "night" : (time >= 12500L ? "dusk" : "day"));
                return new ElementTag(period);
            }
            return new ElementTag(object.getWorld().getTime());
        }, new String[0]);
        WorldTag.registerTag(ElementTag.class, "moon_phase", (attribute, object) -> new ElementTag((int)(object.getWorld().getFullTime() / 24000L % 8L) + 1), "moonphase");
        WorldTag.registerTag(ElementTag.class, "has_storm", (attribute, object) -> new ElementTag(object.getWorld().hasStorm()), new String[0]);
        WorldTag.registerTag(DurationTag.class, "thunder_duration", (attribute, object) -> new DurationTag((long)object.getWorld().getThunderDuration()), new String[0]);
        WorldTag.registerTag(ElementTag.class, "thundering", (attribute, object) -> new ElementTag(object.getWorld().isThundering()), new String[0]);
        WorldTag.registerTag(DurationTag.class, "weather_duration", (attribute, object) -> new DurationTag((long)object.getWorld().getWeatherDuration()), new String[0]);
        WorldTag.registerTag(ElementTag.class, "environment", (attribute, object) -> new ElementTag(object.getWorld().getEnvironment().name()), new String[0]);
        WorldTag.registerTag(ElementTag.class, "border_size", (attribute, object) -> new ElementTag(object.getWorld().getWorldBorder().getSize()), new String[0]);
        WorldTag.registerTag(LocationTag.class, "border_center", (attribute, object) -> new LocationTag(object.getWorld().getWorldBorder().getCenter()), new String[0]);
        WorldTag.registerTag(ElementTag.class, "border_damage", (attribute, object) -> new ElementTag(object.getWorld().getWorldBorder().getDamageAmount()), new String[0]);
        WorldTag.registerTag(ElementTag.class, "border_damage_buffer", (attribute, object) -> new ElementTag(object.getWorld().getWorldBorder().getDamageBuffer()), new String[0]);
        WorldTag.registerTag(ElementTag.class, "border_warning_distance", (attribute, object) -> new ElementTag(object.getWorld().getWorldBorder().getWarningDistance()), new String[0]);
        WorldTag.registerTag(DurationTag.class, "border_warning_time", (attribute, object) -> new DurationTag(object.getWorld().getWorldBorder().getWarningTime()), new String[0]);
        WorldTag.registerTag(ElementTag.class, "gamerule", (attribute, object) -> {
            if (!attribute.hasParam()) {
                attribute.echoError("The tag 'worldtag.gamerule[...]' must have an input value.");
                return null;
            }
            GameRule rule = GameRule.getByName((String)attribute.getParam());
            Object result = object.getWorld().getGameRuleValue(rule);
            return new ElementTag(result == null ? "null" : result.toString());
        }, new String[0]);
        WorldTag.registerTag(MapTag.class, "gamerule_map", (attribute, object) -> {
            MapTag map = new MapTag();
            for (GameRule rule : GameRule.values()) {
                Object result = object.getWorld().getGameRuleValue(rule);
                if (result == null) continue;
                map.putObject(rule.getName(), new ElementTag(result.toString()));
            }
            return map;
        }, new String[0]);
        WorldTag.registerTag(LocationTag.class, "dragon_portal_location", (attribute, object) -> {
            DragonBattle battle = object.getWorld().getEnderDragonBattle();
            if (battle == null) {
                return null;
            }
            if (battle.getEndPortalLocation() == null) {
                return null;
            }
            return new LocationTag(battle.getEndPortalLocation());
        }, new String[0]);
        WorldTag.registerTag(EntityTag.class, "ender_dragon", (attribute, object) -> {
            DragonBattle battle = object.getWorld().getEnderDragonBattle();
            if (battle == null) {
                return null;
            }
            if (battle.getEnderDragon() == null) {
                return null;
            }
            return new EntityTag((Entity)battle.getEnderDragon());
        }, new String[0]);
        WorldTag.registerTag(ListTag.class, "gateway_locations", (attribute, object) -> {
            DragonBattle battle = object.getWorld().getEnderDragonBattle();
            if (battle == null) {
                return null;
            }
            ListTag list = new ListTag();
            for (int i = 0; i < 20; ++i) {
                int x = (int)Math.floor(96.0 * Math.cos(2.0 * (-Math.PI + 0.15707963267948966 * (double)i)));
                int z = (int)Math.floor(96.0 * Math.sin(2.0 * (-Math.PI + 0.15707963267948966 * (double)i)));
                list.addObject(new LocationTag(object.getWorld(), (double)x, 75.0, z));
            }
            return list;
        }, new String[0]);
        WorldTag.registerTag(ListTag.class, "biomes", (attribute, object) -> {
            ListTag output = new ListTag();
            for (BiomeNMS biome : NMSHandler.instance.getBiomes(object.getWorld())) {
                output.addObject(new BiomeTag(biome));
            }
            return output;
        }, new String[0]);
        WorldTag.registerTag(ElementTag.class, "view_distance", (attribute, world) -> new ElementTag(world.getWorld().getViewDistance()), new String[0]);
        WorldTag.registerTag(ElementTag.class, "simulation_distance", (attribute, world) -> new ElementTag(world.getWorld().getSimulationDistance()), new String[0]);
    }

    public static <R extends ObjectTag> void registerTag(Class<R> returnType, String name, TagRunnable.ObjectInterface<WorldTag, R> runnable, String ... variants) {
        tagProcessor.registerTag(returnType, name, (attribute, object) -> {
            if (object.getWorld() == null) {
                attribute.echoError("World '" + object.world_name + "' is unloaded, cannot process tag.");
                return null;
            }
            return runnable.run(attribute, (WorldTag)object);
        }, variants);
    }

    @Override
    public ObjectTag getObjectAttribute(Attribute attribute) {
        return tagProcessor.getObjectAttribute(this, attribute);
    }

    @Override
    public void applyProperty(Mechanism mechanism) {
        mechanism.echoError("Cannot apply properties to a world!");
    }

    @Override
    public void adjust(Mechanism mechanism) {
        Difficulty diff;
        AbstractFlagTracker.tryFlagAdjusts(this, mechanism);
        if (mechanism.matches("ambient_spawn_limit") && mechanism.requireInteger()) {
            this.getWorld().setAmbientSpawnLimit(mechanism.getValue().asInt());
        }
        if (mechanism.matches("animal_spawn_limit") && mechanism.requireInteger()) {
            this.getWorld().setAnimalSpawnLimit(mechanism.getValue().asInt());
        }
        if (mechanism.matches("auto_save") && mechanism.requireBoolean()) {
            this.getWorld().setAutoSave(mechanism.getValue().asBoolean());
        }
        if (mechanism.matches("difficulty") && mechanism.requireEnum(Difficulty.class) && (diff = mechanism.getValue().asEnum(Difficulty.class)) != null) {
            this.getWorld().setDifficulty(diff);
        }
        if (mechanism.matches("hardcore") && mechanism.requireBoolean()) {
            this.getWorld().setHardcore(mechanism.getValue().asBoolean());
        }
        if (mechanism.matches("save")) {
            this.getWorld().save();
        }
        if (mechanism.matches("destroy")) {
            File folder = this.getWorld().getWorldFolder();
            this.unloadWorldClean(mechanism, false);
            if (this.getWorld() != null) {
                return;
            }
            if (!Settings.allowDelete()) {
                mechanism.echoError("Unable to destroy world due to config setting, refer to 'WorldTag.destroy' meta documentation.");
                return;
            }
            try {
                CoreUtilities.deleteDirectory(folder);
            }
            catch (Exception ex) {
                Debug.echoError(ex);
            }
            return;
        }
        if (mechanism.matches("force_unload")) {
            this.unloadWorldClean(mechanism, false);
            return;
        }
        if (mechanism.matches("full_time") && mechanism.requireInteger()) {
            this.getWorld().setFullTime((long)mechanism.getValue().asInt());
        }
        if (mechanism.matches("keep_spawn") && mechanism.requireBoolean()) {
            this.getWorld().setKeepSpawnInMemory(mechanism.getValue().asBoolean());
        }
        if (mechanism.matches("monster_spawn_limit") && mechanism.requireInteger()) {
            this.getWorld().setMonsterSpawnLimit(mechanism.getValue().asInt());
        }
        if (mechanism.matches("allow_pvp") && mechanism.requireBoolean()) {
            this.getWorld().setPVP(mechanism.getValue().asBoolean());
        }
        if (mechanism.matches("spawn_location") && mechanism.requireObject(LocationTag.class)) {
            LocationTag loc = mechanism.valueAsType(LocationTag.class);
            this.getWorld().setSpawnLocation(loc.getBlockX(), loc.getBlockY(), loc.getBlockZ(), loc.getYaw());
        }
        if (mechanism.matches("storming") && mechanism.requireBoolean()) {
            this.getWorld().setStorm(mechanism.getValue().asBoolean());
        }
        if (mechanism.matches("thunder_duration") && mechanism.requireObject(DurationTag.class)) {
            this.getWorld().setThunderDuration(mechanism.valueAsType(DurationTag.class).getTicksAsInt());
        }
        if (mechanism.matches("thundering") && mechanism.requireBoolean()) {
            this.getWorld().setThundering(mechanism.getValue().asBoolean());
        }
        if (mechanism.matches("ticks_per_animal_spawns") && mechanism.requireObject(DurationTag.class)) {
            this.getWorld().setTicksPerAnimalSpawns(mechanism.valueAsType(DurationTag.class).getTicksAsInt());
        }
        if (mechanism.matches("ticks_per_monster_spawns") && mechanism.requireObject(DurationTag.class)) {
            this.getWorld().setTicksPerMonsterSpawns(mechanism.valueAsType(DurationTag.class).getTicksAsInt());
        }
        if (mechanism.matches("time") && mechanism.requireInteger()) {
            this.getWorld().setTime((long)mechanism.getValue().asInt());
        }
        if (mechanism.matches("unload")) {
            this.unloadWorldClean(mechanism, true);
            return;
        }
        if (mechanism.matches("water_animal_spawn_limit") && mechanism.requireInteger()) {
            this.getWorld().setWaterAnimalSpawnLimit(mechanism.getValue().asInt());
        }
        if (mechanism.matches("weather_duration") && mechanism.requireObject(DurationTag.class)) {
            this.getWorld().setWeatherDuration(mechanism.valueAsType(DurationTag.class).getTicksAsInt());
        }
        CoreUtilities.autoPropertyMechanism(this, mechanism);
    }

    public void unloadWorldClean(Mechanism mechanism, boolean doSave) {
        for (Player pl : new ArrayList(this.getWorld().getPlayers())) {
            if (!pl.isOnline()) continue;
            mechanism.echoError("For WorldTag." + mechanism.getName() + " mechanism, Player " + pl.getUniqueId() + "/" + pl.getName() + " is inside world and will be kicked.");
            pl.kickPlayer("World being destroyed.");
        }
        if (!Bukkit.getServer().unloadWorld(this.getWorld(), doSave)) {
            mechanism.echoError("WorldTag." + mechanism.getName() + " for world " + this.world_name + " was refused by the System. Are you sure (A) this world is even loaded, (B) all players have been removed, and (C) this is not the default world?");
        }
    }

    @Override
    public boolean advancedMatches(String matcher) {
        String matcherLow = CoreUtilities.toLowerCase(matcher);
        if (matcherLow.equals("world")) {
            return true;
        }
        if (matcherLow.startsWith("world_flagged:")) {
            return BukkitScriptEvent.coreFlaggedCheck(matcher.substring("world_flagged:".length()), this.getFlagTracker());
        }
        return BukkitScriptEvent.runGenericCheck(matcher, this.getName());
    }
}

