/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.scripts.commands.core;

import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsRuntimeException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.ObjectFetcher;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.notable.Notable;
import com.denizenscript.denizencore.objects.notable.NoteManager;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;

public class NoteCommand
extends AbstractCommand {
    public NoteCommand() {
        this.setName("note");
        this.setSyntax("note [<object>/remove] [as:<name>]");
        this.setRequiredArguments(2, 2);
        this.isProcedural = false;
        this.addRemappedPrefixes("id", "as", "i");
        this.setBooleansHandled("remove");
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry) {
            if (ObjectFetcher.canFetch(arg.getValue().split("@")[0]) && !scriptEntry.hasObject("object") && !scriptEntry.hasObject("remove")) {
                scriptEntry.addObject("object", arg.object);
                continue;
            }
            arg.reportUnhandled();
        }
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        String stringified;
        ObjectTag object = (ObjectTag)scriptEntry.getObjectTag("object");
        ElementTag id = scriptEntry.requiredArgForPrefixAsElement("id");
        boolean remove = scriptEntry.argAsBoolean("remove");
        if (object == null && !remove) {
            throw new InvalidArgumentsRuntimeException("Must specify an object to note.");
        }
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report((Debuggable)scriptEntry, this.getName(), object, id, NoteCommand.db("remove", remove));
        }
        if (remove) {
            Notable note = NoteManager.getSavedObject(id.asString());
            if (note != null) {
                note.forget();
                Debug.echoDebug((Debuggable)scriptEntry, "Note '" + id.asString() + "' removed");
            } else {
                Debug.echoDebug((Debuggable)scriptEntry, id.asString() + " is not saved");
            }
            return;
        }
        if (object instanceof ElementTag && (object = ObjectFetcher.pickObjectFor(stringified = object.toString(), scriptEntry.context)) == null) {
            Debug.echoError("Failed to read the object '" + stringified + "' into a real object value.");
            return;
        }
        if (!(object instanceof Notable)) {
            Debug.echoError("Object '" + object + "' has type '" + object.getDenizenObjectType() + "' which is not a notable object type.");
            return;
        }
        try {
            ((Notable)((Object)object)).makeUnique(id.asString());
        }
        catch (Throwable ex) {
            Debug.echoError("Something went wrong converting that object!");
            Debug.echoError(ex);
        }
    }
}

