/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.player;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.objects.ColorTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.utilities.BukkitImplDeprecations;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.core.DurationTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import java.util.Collections;
import java.util.List;

public class DebugBlockCommand
extends AbstractCommand {
    public DebugBlockCommand() {
        this.setName("debugblock");
        this.setSyntax("debugblock [<location>|.../clear] (color:<color>) (name:<name>) (players:<player>|...) (d:<duration>{10s})");
        this.setRequiredArguments(1, 6);
        this.isProcedural = false;
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry) {
            if (!scriptEntry.hasObject("players") && arg.matchesPrefix("to", "players")) {
                scriptEntry.addObject("players", arg.asType(ListTag.class).filter(PlayerTag.class, scriptEntry));
                continue;
            }
            if (arg.matchesPrefix("d", "duration") && arg.matchesArgumentType(DurationTag.class)) {
                scriptEntry.addObject("duration", arg.asType(DurationTag.class));
                continue;
            }
            if (arg.matchesPrefix("color") && arg.matchesArgumentType(ColorTag.class)) {
                scriptEntry.addObject("color", arg.asType(ColorTag.class));
                continue;
            }
            if (arg.matchesPrefix("alpha") && arg.matchesFloat()) {
                BukkitImplDeprecations.debugBlockAlpha.warn(scriptEntry);
                scriptEntry.addObject("alpha", arg.asElement());
                continue;
            }
            if (arg.matchesPrefix("name")) {
                scriptEntry.addObject("name", arg.asElement());
                continue;
            }
            if (arg.matches("clear")) {
                scriptEntry.addObject("clear", new ElementTag(true));
                continue;
            }
            if (!scriptEntry.hasObject("locations") && arg.matchesArgumentList(LocationTag.class)) {
                scriptEntry.addObject("locations", arg.asType(ListTag.class).filter(LocationTag.class, scriptEntry));
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("players") && Utilities.entryHasPlayer(scriptEntry)) {
            scriptEntry.defaultObject("players", Collections.singletonList(Utilities.getEntryPlayer(scriptEntry)));
        }
        if (!scriptEntry.hasObject("locations") && !scriptEntry.hasObject("clear")) {
            throw new InvalidArgumentsException("Must specify at least one valid location!");
        }
        if (!scriptEntry.hasObject("players")) {
            throw new InvalidArgumentsException("Must have a valid, online player attached!");
        }
        scriptEntry.defaultObject("duration", new DurationTag(10));
        scriptEntry.defaultObject("color", new ColorTag(255, 255, 255));
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        DurationTag duration = (DurationTag)scriptEntry.getObjectTag("duration");
        ElementTag clear = scriptEntry.getElement("clear");
        List locations = (List)scriptEntry.getObject("locations");
        List players = (List)scriptEntry.getObject("players");
        ColorTag color = (ColorTag)scriptEntry.getObjectTag("color");
        ElementTag alpha = scriptEntry.getElement("alpha");
        ElementTag name = scriptEntry.getElement("name");
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report((Debuggable)scriptEntry, this.getName(), clear == null ? DebugBlockCommand.db("locations", locations) : clear, duration, DebugBlockCommand.db("players", players), color, alpha, name);
        }
        if (clear != null && clear.asBoolean()) {
            for (PlayerTag player : players) {
                NMSHandler.packetHelper.clearDebugTestMarker(player.getPlayerEntity());
            }
        } else {
            if (alpha != null) {
                color = new ColorTag(color);
                color.alpha = (int)(alpha.asFloat() * 255.0f);
            }
            for (LocationTag location : locations) {
                for (PlayerTag player : players) {
                    NMSHandler.packetHelper.showDebugTestMarker(player.getPlayerEntity(), location, color, name == null ? "" : name.asString(), (int)duration.getMillis());
                }
            }
        }
    }
}

