/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.player;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.NMSVersion;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Hanging;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.hanging.HangingPlaceEvent;

public class PlayerPlacesHangingScriptEvent
extends BukkitScriptEvent
implements Listener {
    public EntityTag hanging;
    public ItemTag item;
    public LocationTag location;
    public HangingPlaceEvent event;

    public PlayerPlacesHangingScriptEvent() {
        this.registerCouldMatcher("player places <hanging>");
        this.registerSwitches("item");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        String hangCheck = path.eventArgLowerAt(2);
        if (!this.hanging.tryAdvancedMatcher(hangCheck)) {
            return false;
        }
        if (!this.runInCheck(path, this.location)) {
            return false;
        }
        if (path.tryObjectSwitch("item", this.item)) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData((Entity)this.event.getPlayer());
    }

    @Override
    public ObjectTag getContext(String name) {
        switch (name) {
            case "hanging": {
                return this.hanging;
            }
            case "location": {
                return this.location;
            }
            case "item": {
                return this.item;
            }
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onPlayerPlacesHanging(HangingPlaceEvent event) {
        if (EntityTag.isNPC((Entity)event.getPlayer())) {
            return;
        }
        Hanging hangingEntity = event.getEntity();
        EntityTag.rememberEntity((Entity)hangingEntity);
        this.hanging = new EntityTag((Entity)hangingEntity);
        this.location = new LocationTag(event.getBlock().getLocation());
        this.item = NMSHandler.getVersion().isAtLeast(NMSVersion.v1_17) ? new ItemTag(event.getItemStack()) : new ItemTag(Material.AIR);
        this.event = event;
        this.fire((Event)event);
        EntityTag.forgetEntity((Entity)hangingEntity);
    }
}

