/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis;

import java.net.URI;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocketFactory;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.exceptions.InvalidURIException;
import redis.clients.jedis.util.JedisURIHelper;
import redis.clients.jedis.util.ShardInfo;

public class JedisShardInfo
extends ShardInfo<Jedis> {
    private int connectionTimeout;
    private int soTimeout;
    private String host;
    private int port;
    private String user = null;
    private String password = null;
    private String name = null;
    private int db = 0;
    private boolean ssl;
    private SSLSocketFactory sslSocketFactory;
    private SSLParameters sslParameters;
    private HostnameVerifier hostnameVerifier;

    public JedisShardInfo(String host) {
        super(1);
        URI uri = URI.create(host);
        if (JedisURIHelper.isValid(uri)) {
            this.host = uri.getHost();
            this.port = uri.getPort();
            this.user = JedisURIHelper.getUser(uri);
            this.password = JedisURIHelper.getPassword(uri);
            this.db = JedisURIHelper.getDBIndex(uri);
            this.ssl = JedisURIHelper.isRedisSSLScheme(uri);
        } else {
            this.host = host;
            this.port = 6379;
        }
    }

    public JedisShardInfo(String host, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier) {
        this(host);
        this.sslSocketFactory = sslSocketFactory;
        this.sslParameters = sslParameters;
        this.hostnameVerifier = hostnameVerifier;
    }

    public JedisShardInfo(String host, String name) {
        this(host, 6379, name);
    }

    public JedisShardInfo(HostAndPort hp) {
        this(hp.getHost(), hp.getPort());
    }

    public JedisShardInfo(String host, int port) {
        this(host, port, 2000);
    }

    public JedisShardInfo(String host, int port, boolean ssl) {
        this(host, port, 2000, ssl);
    }

    public JedisShardInfo(String host, int port, boolean ssl, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier) {
        this(host, port, 2000, ssl, sslSocketFactory, sslParameters, hostnameVerifier);
    }

    public JedisShardInfo(String host, int port, String name) {
        this(host, port, 2000, name);
    }

    public JedisShardInfo(String host, int port, String name, boolean ssl) {
        this(host, port, 2000, name, ssl);
    }

    public JedisShardInfo(String host, int port, String name, boolean ssl, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier) {
        this(host, port, 2000, name, ssl, sslSocketFactory, sslParameters, hostnameVerifier);
    }

    public JedisShardInfo(String host, int port, int timeout) {
        this(host, port, timeout, timeout, 1);
    }

    public JedisShardInfo(String host, int port, int timeout, boolean ssl) {
        this(host, port, timeout, timeout, 1, ssl);
    }

    public JedisShardInfo(String host, int port, int timeout, boolean ssl, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier) {
        this(host, port, timeout, timeout, 1, ssl, sslSocketFactory, sslParameters, hostnameVerifier);
    }

    public JedisShardInfo(String host, int port, int timeout, String name) {
        this(host, port, timeout, timeout, 1);
        this.name = name;
    }

    public JedisShardInfo(String host, int port, int timeout, String name, boolean ssl) {
        this(host, port, timeout, timeout, 1, ssl);
        this.name = name;
    }

    public JedisShardInfo(String host, int port, int timeout, String name, boolean ssl, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier) {
        this(host, port, timeout, ssl, sslSocketFactory, sslParameters, hostnameVerifier);
        this.name = name;
    }

    public JedisShardInfo(String host, int port, int connectionTimeout, int soTimeout, int weight) {
        super(weight);
        this.host = host;
        this.port = port;
        this.connectionTimeout = connectionTimeout;
        this.soTimeout = soTimeout;
    }

    public JedisShardInfo(String host, int port, int connectionTimeout, int soTimeout, int weight, boolean ssl) {
        super(weight);
        this.host = host;
        this.port = port;
        this.connectionTimeout = connectionTimeout;
        this.soTimeout = soTimeout;
        this.ssl = ssl;
    }

    public JedisShardInfo(String host, int port, int connectionTimeout, int soTimeout, int weight, boolean ssl, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier) {
        this(host, port, connectionTimeout, soTimeout, weight, ssl);
        this.sslSocketFactory = sslSocketFactory;
        this.sslParameters = sslParameters;
        this.hostnameVerifier = hostnameVerifier;
    }

    public JedisShardInfo(String host, String name, int port, int timeout, int weight) {
        this(host, port, timeout, timeout, weight);
        this.name = name;
    }

    public JedisShardInfo(String host, String name, int port, int timeout, int weight, boolean ssl) {
        this(host, port, timeout, timeout, weight, ssl);
        this.name = name;
    }

    public JedisShardInfo(String host, String name, int port, int timeout, int weight, boolean ssl, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier) {
        this(host, port, timeout, timeout, weight, ssl, sslSocketFactory, sslParameters, hostnameVerifier);
        this.name = name;
    }

    public JedisShardInfo(URI uri) {
        super(1);
        if (!JedisURIHelper.isValid(uri)) {
            throw new InvalidURIException(String.format("Cannot open Redis connection due invalid URI. %s", uri.toString()));
        }
        this.host = uri.getHost();
        this.port = uri.getPort();
        this.user = JedisURIHelper.getUser(uri);
        this.password = JedisURIHelper.getPassword(uri);
        this.db = JedisURIHelper.getDBIndex(uri);
        this.ssl = JedisURIHelper.isRedisSSLScheme(uri);
    }

    public JedisShardInfo(URI uri, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier) {
        this(uri);
        this.sslSocketFactory = sslSocketFactory;
        this.sslParameters = sslParameters;
        this.hostnameVerifier = hostnameVerifier;
    }

    public String toString() {
        return this.host + ":" + this.port + "*" + this.getWeight();
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String auth) {
        this.password = auth;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public int getSoTimeout() {
        return this.soTimeout;
    }

    public void setSoTimeout(int soTimeout) {
        this.soTimeout = soTimeout;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public int getDb() {
        return this.db;
    }

    public boolean getSsl() {
        return this.ssl;
    }

    public SSLSocketFactory getSslSocketFactory() {
        return this.sslSocketFactory;
    }

    public SSLParameters getSslParameters() {
        return this.sslParameters;
    }

    public HostnameVerifier getHostnameVerifier() {
        return this.hostnameVerifier;
    }

    @Override
    public Jedis createResource() {
        return new Jedis(this);
    }
}

