/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.entity;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.ProjectileHitEvent;

public class ProjectileHitsEntityScriptEvent
extends BukkitScriptEvent
implements Listener {
    public EntityTag projectile;
    public EntityTag shooter;
    public EntityTag hitEntity;
    public LocationTag location;
    public ProjectileHitEvent event;

    @Override
    public boolean couldMatch(ScriptEvent.ScriptPath path) {
        String cmd = path.eventArgLowerAt(1);
        if (!cmd.equals("hits")) {
            return false;
        }
        if (!ProjectileHitsEntityScriptEvent.couldMatchEntity(path.eventArgLowerAt(0))) {
            return false;
        }
        return ProjectileHitsEntityScriptEvent.couldMatchEntity(path.eventArgLowerAt(2));
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        if (!this.projectile.tryAdvancedMatcher(path.eventArgLowerAt(0))) {
            return false;
        }
        if (!this.hitEntity.tryAdvancedMatcher(path.eventArgLowerAt(2))) {
            return false;
        }
        if (!path.tryObjectSwitch("shooter", this.shooter)) {
            return false;
        }
        if (!this.runInCheck(path, this.location)) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(this.hitEntity);
    }

    @Override
    public ObjectTag getContext(String name) {
        if (name.equals("projectile")) {
            return this.projectile.getDenizenObject();
        }
        if (name.equals("hit_entity")) {
            return this.hitEntity.getDenizenObject();
        }
        if (name.equals("shooter") && this.shooter != null) {
            return this.shooter.getDenizenObject();
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onProjectileHits(ProjectileHitEvent event) {
        Entity entity = event.getHitEntity();
        if (entity == null) {
            return;
        }
        this.projectile = new EntityTag((Entity)event.getEntity());
        this.shooter = this.projectile.getShooter();
        this.hitEntity = new EntityTag(entity);
        this.location = this.hitEntity.getLocation();
        this.event = event;
        this.fire((Event)event);
    }
}

