/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.bukkit;

import com.denizenscript.denizen.objects.EntityFormObject;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.MaterialTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.objects.PolygonTag;
import com.denizenscript.denizen.objects.WorldTag;
import com.denizenscript.denizen.utilities.Settings;
import com.denizenscript.denizencore.DenizenCore;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import java.util.List;
import org.bukkit.ChatColor;

public class BukkitListExtensions {
    public static void register() {
        ListTag.tagProcessor.registerTag(ElementTag.class, "formatted", (attribute, list) -> {
            if (list.isEmpty()) {
                return new ElementTag("");
            }
            StringBuilder output = new StringBuilder();
            for (int i = 0; i < list.size(); ++i) {
                MaterialTag material;
                ItemTag item;
                EntityFormObject gotten;
                ObjectTag object = list.getObject(i);
                String val = object.toString();
                boolean handled = false;
                if (val.startsWith("p@") && (gotten = object.asType(PlayerTag.class, attribute.context)) != null) {
                    output.append(((PlayerTag)gotten).getName());
                    handled = true;
                }
                if ((val.startsWith("e@") || val.startsWith("n@")) && (gotten = object.asType(EntityTag.class, attribute.context)) != null) {
                    if (((EntityTag)gotten).isValid()) {
                        output.append(((EntityTag)gotten).getName());
                    } else {
                        output.append(((EntityTag)gotten).getEntityType().getName());
                    }
                    handled = true;
                }
                if (val.startsWith("i@") && (item = object.asType(ItemTag.class, attribute.context)) != null) {
                    output.append(item.formattedName());
                    handled = true;
                }
                if (val.startsWith("m@") && (material = object.asType(MaterialTag.class, attribute.context)) != null) {
                    output.append(material.name());
                    handled = true;
                }
                if (!handled) {
                    if (object instanceof ElementTag) {
                        output.append(val.replaceAll("\\w+@", ""));
                    } else {
                        output.append(ChatColor.stripColor((String)DenizenCore.implementation.applyDebugColors(object.debuggable())));
                    }
                }
                if (i == list.size() - 2) {
                    output.append(i == 0 ? " and " : ", and ");
                    continue;
                }
                output.append(", ");
            }
            return new ElementTag(output.substring(0, output.length() - 2));
        }, new String[0]);
        ListTag.tagProcessor.registerTag(PolygonTag.class, "to_polygon", (attribute, list) -> {
            List<LocationTag> locations = list.filter(LocationTag.class, attribute.context);
            if (locations == null || locations.isEmpty()) {
                return null;
            }
            if (locations.size() > Settings.blockTagsMaxBlocks()) {
                return null;
            }
            PolygonTag polygon = new PolygonTag(new WorldTag(locations.get(0).getWorldName()));
            polygon.yMax = polygon.yMin = locations.get(0).getY();
            for (LocationTag location : locations) {
                polygon.yMin = Math.min(polygon.yMin, location.getY());
                polygon.yMax = Math.max(polygon.yMax, location.getY());
                polygon.corners.add(new PolygonTag.Corner(location.getX(), location.getZ()));
            }
            polygon.recalculateBox();
            return polygon;
        }, new String[0]);
    }
}

