/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.utilities.debugging;

import com.denizenscript.denizencore.DenizenCore;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.containers.ScriptContainer;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.utilities.CoreConfiguration;
import com.denizenscript.denizencore.utilities.debugging.DebugInternals;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import java.util.Stack;

public class Debug {
    public static StringBuilder debugRecording = new StringBuilder();
    public static TagContext currentContext = null;
    public static Stack<Object> errorContextStack = new Stack();

    public static void pushErrorContext(Object context) {
        if (DenizenCore.isMainThread()) {
            errorContextStack.push(context);
        }
    }

    public static void push2ErrorContexts(Object context1, Object context2) {
        if (DenizenCore.isMainThread()) {
            errorContextStack.push(context1);
            errorContextStack.push(context2);
        }
    }

    public static void push3ErrorContexts(Object context1, Object context2, Object context3) {
        if (DenizenCore.isMainThread()) {
            errorContextStack.push(context1);
            errorContextStack.push(context2);
            errorContextStack.push(context3);
        }
    }

    public static void popErrorContext() {
        Debug.popErrorContext(1);
    }

    public static void popErrorContext(int count) {
        if (DenizenCore.isMainThread()) {
            for (int i = 0; i < count; ++i) {
                errorContextStack.pop();
            }
        }
    }

    public static void startRecording() {
        if (!CoreConfiguration.debugRecordingAllowed) {
            Debug.echoError("Cannot start debug recording: forbidden by config.");
            return;
        }
        CoreConfiguration.shouldRecordDebug = true;
        debugRecording = new StringBuilder();
    }

    public static void stopRecording() {
        CoreConfiguration.shouldRecordDebug = false;
        debugRecording = new StringBuilder();
    }

    public static void echoError(String error) {
        Debug.echoError(currentContext, error);
    }

    public static void echoError(TagContext context, String error) {
        Debug.echoError(context, null, error);
    }

    public static void echoError(TagContext context, String addedContext, String error) {
        if (context == null) {
            context = currentContext;
        }
        if (context != null && context.entry != null) {
            Debug.echoError(context.entry, addedContext, error);
        } else if (context != null && context.script != null) {
            Debug.echoError(context.script.getContainer(), addedContext, error);
        } else {
            DenizenCore.runOnMainThread(() -> DebugInternals.echoErrorInternal(null, addedContext, error, true));
        }
    }

    public static void echoError(ScriptContainer script, String error) {
        Debug.echoError(script, null, error);
    }

    public static void echoError(ScriptContainer script, String addedContext, String error) {
        Debug.pushErrorContext(script);
        try {
            DenizenCore.runOnMainThread(() -> DebugInternals.echoErrorInternal(null, addedContext, error, true));
        }
        finally {
            Debug.popErrorContext();
        }
    }

    public static void echoError(ScriptEntry entry, String error) {
        Debug.echoError(entry, null, error);
    }

    public static void echoError(ScriptEntry entry, String addedContext, String error) {
        DenizenCore.runOnMainThread(() -> DebugInternals.echoErrorInternal(entry, addedContext, error, true));
    }

    public static void echoError(Throwable ex) {
        DenizenCore.runOnMainThread(() -> DebugInternals.echoExceptionInternal(currentContext == null ? null : Debug.currentContext.entry, ex));
    }

    public static void echoError(ScriptEntry entry, Throwable error) {
        DenizenCore.runOnMainThread(() -> DebugInternals.echoExceptionInternal(entry, error));
    }

    public static void verboseLog(String message) {
        if (CoreConfiguration.debugVerbose) {
            String caller = DebugInternals.getCaller();
            DenizenCore.runOnMainThread(() -> DebugInternals.logInternal(caller, message));
        }
    }

    public static void log(String message) {
        String caller = DebugInternals.getCaller();
        DenizenCore.runOnMainThread(() -> DebugInternals.logInternal(caller, message));
    }

    public static void log(String caller, String message) {
        DenizenCore.runOnMainThread(() -> DebugInternals.logInternal(caller, message));
    }

    public static void log(DebugElement element, String message) {
        if (!CoreConfiguration.shouldShowDebug) {
            return;
        }
        switch (element) {
            case Footer: {
                message = "<LP>+---------------------+";
                break;
            }
            case Header: {
                message = "<LP>+- " + message + "<LP> ---------+";
            }
        }
        String finalMessage = message;
        DenizenCore.runOnMainThread(() -> DebugInternals.finalOutputDebugText(finalMessage, null, true));
    }

    public static void echoApproval(String message) {
        DenizenCore.runOnMainThread(() -> {
            if (!CoreConfiguration.shouldShowDebug) {
                return;
            }
            DebugInternals.finalOutputDebugText("<GR>OKAY! <W>" + message, null, true);
        });
    }

    public static void echoDebug(Debuggable entry, DebugElement element) {
        if (!CoreConfiguration.shouldShowDebug || !Debug.shouldDebug(entry)) {
            return;
        }
        Debug.echoDebug(entry, element, null);
    }

    public static void echoDebug(Debuggable entry, String message) {
        if (!CoreConfiguration.shouldShowDebug || !Debug.shouldDebug(entry)) {
            return;
        }
        DenizenCore.runOnMainThread(() -> {
            DebugInternals.echo("<W>" + DebugInternals.trimMessage(message), entry);
            if (CoreConfiguration.debugVerbose && entry != null) {
                DebugInternals.echo("<LG>(Verbose) Caller = " + entry, entry);
            }
        });
    }

    public static void echoDebug(Debuggable entry, DebugElement element, String message) {
        if (!CoreConfiguration.shouldShowDebug || !Debug.shouldDebug(entry)) {
            return;
        }
        switch (element) {
            case Footer: {
                message = "<LP>+---------------------+";
                break;
            }
            case Header: {
                message = "<LP>+- " + message + "<LP> ---------+";
            }
        }
        String finalMessage = message;
        DenizenCore.runOnMainThread(() -> DebugInternals.echo(finalMessage, entry));
    }

    public static void report(Debuggable caller, String name, String message) {
        if (!CoreConfiguration.shouldShowDebug || !Debug.shouldDebug(caller)) {
            return;
        }
        DenizenCore.runOnMainThread(() -> DebugInternals.echo("<Y>+> <G>Executing '<Y>" + name + "<G>': " + DebugInternals.trimMessage(message), caller));
    }

    public static void report(Debuggable caller, String name, Object ... values) {
        if (!CoreConfiguration.shouldShowDebug || !Debug.shouldDebug(caller)) {
            return;
        }
        StringBuilder output = new StringBuilder();
        for (Object obj : values) {
            if (obj == null) continue;
            if (obj instanceof ObjectTag) {
                ObjectTag objTag = (ObjectTag)obj;
                output.append("<G>").append(objTag.getPrefix()).append("='<Y>").append(objTag.debuggable()).append("<G>'  ");
                continue;
            }
            output.append(obj);
        }
        DenizenCore.runOnMainThread(() -> DebugInternals.echo("<Y>+> <G>Executing '<Y>" + name + "<G>': " + DebugInternals.trimMessage(output.toString()), caller));
    }

    public static boolean shouldDebug(Debuggable caller) {
        if (CoreConfiguration.debugOverride) {
            return true;
        }
        if (!CoreConfiguration.shouldShowDebug) {
            return false;
        }
        if (caller != null) {
            return caller.shouldDebug();
        }
        return true;
    }

    public static enum DebugElement {
        Header,
        Footer,
        Spacer;

    }
}

