/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.player;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.utilities.FormattedTextHelper;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizen.utilities.packets.NetworkInterceptHelper;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.chat.ComponentSerializer;

public class PlayerReceivesMessageScriptEvent
extends BukkitScriptEvent {
    public static PlayerReceivesMessageScriptEvent instance;
    public ElementTag message;
    public ElementTag rawJson;
    public boolean didModify;
    public BaseComponent[] altMessageDetermination;
    public ElementTag system;
    public boolean modified;
    public PlayerTag player;
    public boolean loaded;

    public PlayerReceivesMessageScriptEvent() {
        instance = this;
    }

    public void reset() {
        this.player = null;
        this.message = null;
        this.rawJson = null;
        this.system = null;
        this.cancelled = false;
        this.modified = false;
        this.altMessageDetermination = null;
        this.didModify = false;
    }

    @Override
    public boolean couldMatch(ScriptEvent.ScriptPath path) {
        return path.eventLower.startsWith("player receives message");
    }

    @Override
    public void init() {
        NetworkInterceptHelper.enable();
        this.loaded = true;
    }

    @Override
    public void destroy() {
        this.loaded = false;
    }

    @Override
    public boolean applyDetermination(ScriptEvent.ScriptPath path, ObjectTag determinationObj) {
        if (determinationObj instanceof ElementTag) {
            String determination = determinationObj.toString();
            String lower = CoreUtilities.toLowerCase(determination);
            if (lower.startsWith("message:")) {
                this.message = new ElementTag(determination.substring("message:".length()), true);
                this.altMessageDetermination = FormattedTextHelper.parse(this.message.asString(), ChatColor.WHITE);
                this.modified = true;
                return true;
            }
            if (lower.startsWith("raw_json:")) {
                this.rawJson = new ElementTag(determination.substring("raw_json:".length()));
                this.altMessageDetermination = null;
                this.message = new ElementTag(FormattedTextHelper.stringify(ComponentSerializer.parse((String)this.rawJson.asString()), ChatColor.WHITE), true);
                this.modified = true;
                return true;
            }
        }
        return super.applyDetermination(path, determinationObj);
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(this.player, null);
    }

    @Override
    public ObjectTag getContext(String name) {
        switch (name) {
            case "message": {
                return this.message;
            }
            case "system_message": {
                return this.system;
            }
            case "raw_json": {
                if (this.altMessageDetermination != null) {
                    return new ElementTag(ComponentSerializer.toString((BaseComponent[])this.altMessageDetermination), true);
                }
                return this.rawJson;
            }
        }
        return super.getContext(name);
    }

    public PlayerReceivesMessageScriptEvent triggerNow() {
        PlayerReceivesMessageScriptEvent event = (PlayerReceivesMessageScriptEvent)this.fire();
        if (event.modified && event.altMessageDetermination == null) {
            event.altMessageDetermination = ComponentSerializer.parse((String)event.rawJson.asString());
        }
        return event;
    }
}

