/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.entity;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.SlimeSplitEvent;

public class SlimeSplitsScriptEvent
extends BukkitScriptEvent
implements Listener {
    public EntityTag entity;
    public SlimeSplitEvent event;

    public SlimeSplitsScriptEvent() {
        this.registerCouldMatcher("slime splits (into <'#'>)");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        String counts = path.eventArgLowerAt(3);
        if (path.eventArgLowerAt(2).equals("into") && !counts.isEmpty()) {
            try {
                if (Integer.parseInt(counts) != this.event.getCount()) {
                    return false;
                }
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        if (!this.runInCheck(path, this.entity.getLocation())) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public boolean applyDetermination(ScriptEvent.ScriptPath path, ObjectTag determinationObj) {
        if (determinationObj instanceof ElementTag && ((ElementTag)determinationObj).isInt()) {
            this.event.setCount(((ElementTag)determinationObj).asInt());
            return true;
        }
        return super.applyDetermination(path, determinationObj);
    }

    @Override
    public ObjectTag getContext(String name) {
        if (name.equals("entity")) {
            return this.entity;
        }
        if (name.equals("count")) {
            return new ElementTag(this.event.getCount());
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onSlimeSplits(SlimeSplitEvent event) {
        this.entity = new EntityTag((Entity)event.getEntity());
        this.event = event;
        this.fire((Event)event);
    }
}

