/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.paper.events;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.utilities.entity.FakeEntity;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import com.destroystokyo.paper.event.player.PlayerUseUnknownEntityEvent;
import java.util.UUID;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;

public class PlayerClicksFakeEntityScriptEvent
extends BukkitScriptEvent
implements Listener {
    public PlayerUseUnknownEntityEvent event;

    public PlayerClicksFakeEntityScriptEvent() {
        this.registerCouldMatcher("player (right|left) clicks fake entity");
    }

    public boolean matches(ScriptEvent.ScriptPath path) {
        if (path.eventArgLowerAt(1).equals("left") && !this.event.isAttack()) {
            return false;
        }
        if (path.eventArgLowerAt(1).equals("right") && this.event.isAttack()) {
            return false;
        }
        if (!this.runInCheck(path, this.event.getPlayer().getLocation())) {
            return false;
        }
        return super.matches(path);
    }

    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData((Entity)this.event.getPlayer());
    }

    public ObjectTag getContext(String name) {
        switch (name) {
            case "entity": {
                FakeEntity fakeEntity = FakeEntity.getFakeEntityFor((UUID)this.event.getPlayer().getUniqueId(), (int)this.event.getEntityId());
                if (fakeEntity == null) break;
                return fakeEntity.entity;
            }
            case "hand": {
                return new ElementTag(this.event.getHand().name());
            }
            case "click_type": {
                return new ElementTag(this.event.isAttack() ? "left" : "right");
            }
        }
        return super.getContext(name);
    }

    @EventHandler
    public void clickFakeEntity(PlayerUseUnknownEntityEvent event) {
        this.event = event;
        this.fire((Event)event);
    }
}

