/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.block;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.MaterialTag;
import com.denizenscript.denizen.objects.properties.material.MaterialAge;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockGrowEvent;

public class BlockGrowsScriptEvent
extends BukkitScriptEvent
implements Listener {
    public LocationTag location;
    public MaterialTag material;
    public BlockGrowEvent event;

    public BlockGrowsScriptEvent() {
        this.registerCouldMatcher("<block> grows");
        this.registerSwitches("from", "to");
    }

    @Override
    public boolean couldMatch(ScriptEvent.ScriptPath path) {
        if (!super.couldMatch(path)) {
            return false;
        }
        MaterialTag mat = MaterialTag.valueOf(path.eventArgLowerAt(0), CoreUtilities.noDebugContext);
        return mat == null || !mat.isStructure();
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        if (!this.runInCheck(path, this.location)) {
            return false;
        }
        if (!this.material.tryAdvancedMatcher(path.eventArgLowerAt(0))) {
            return false;
        }
        if (path.switches.containsKey("from")) {
            if (!MaterialAge.describes(new MaterialTag(this.location.getBlockState()))) {
                return false;
            }
            int oldState = MaterialAge.getFrom(new MaterialTag(this.location.getBlockState())).getCurrent();
            if (!path.checkSwitch("from", String.valueOf(oldState))) {
                return false;
            }
        }
        if (path.switches.containsKey("to")) {
            if (!MaterialAge.describes(this.material)) {
                return false;
            }
            int newState = MaterialAge.getFrom(this.material).getCurrent();
            if (!path.checkSwitch("to", String.valueOf(newState))) {
                return false;
            }
        }
        return super.matches(path);
    }

    @Override
    public ObjectTag getContext(String name) {
        switch (name) {
            case "location": {
                return this.location;
            }
            case "material": {
                return this.material;
            }
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onBlockGrows(BlockGrowEvent event) {
        this.location = new LocationTag(event.getBlock().getLocation());
        this.material = new MaterialTag(event.getNewState());
        if (this.material.isStructure()) {
            return;
        }
        this.event = event;
        this.fire((Event)event);
    }
}

