/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.flags;

import com.denizenscript.denizencore.flags.FlaggableObject;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.DurationTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.core.MapTag;
import com.denizenscript.denizencore.objects.core.TimeTag;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.tags.ObjectTagProcessor;
import com.denizenscript.denizencore.utilities.CoreConfiguration;
import com.denizenscript.denizencore.utilities.Deprecations;
import com.denizenscript.denizencore.utilities.debugging.SlowWarning;
import com.denizenscript.denizencore.utilities.debugging.Warning;
import java.util.Collection;

public abstract class AbstractFlagTracker {
    public static Warning listFlagsTagWarning = new SlowWarning("listFlagsTagWarning", "The list_flags and flag_map tags are meant for testing/debugging only. Do not use it in scripts (ignore this warning if using for testing reasons).");

    public abstract MapTag getRootMap(String var1);

    public abstract void setRootMap(String var1, MapTag var2);

    public abstract ObjectTag getFlagValue(String var1);

    public abstract TimeTag getFlagExpirationTime(String var1);

    public abstract Collection<String> listAllFlags();

    public void setFlag(String key, ObjectTag value, TimeTag expiration) {
        this.setFlag(key, value, expiration, true);
    }

    public abstract void setFlag(String var1, ObjectTag var2, TimeTag var3, boolean var4);

    public boolean hasFlag(String key) {
        return this.getFlagValue(key) != null;
    }

    public static <T extends FlaggableObject> void registerFlagHandlers(ObjectTagProcessor<T> processor) {
        processor.registerTag(ObjectTag.class, "flag", (attribute, object) -> {
            AbstractFlagTracker tracker = object.getFlagTrackerForTag();
            if (tracker == null) {
                attribute.echoError("Cannot read flag tag for '" + object + "': " + object.getReasonNotFlaggable());
                return null;
            }
            return tracker.doFlagTag(attribute);
        }, new String[0]);
        processor.registerTag(ElementTag.class, "has_flag", (attribute, object) -> {
            AbstractFlagTracker tracker = object.getFlagTrackerForTag();
            if (tracker == null) {
                attribute.echoError("Cannot read has_flag tag for '" + object + "': " + object.getReasonNotFlaggable());
                return null;
            }
            return tracker.doHasFlagTag(attribute);
        }, new String[0]);
        processor.registerTag(TimeTag.class, "flag_expiration", (attribute, object) -> {
            AbstractFlagTracker tracker = object.getFlagTrackerForTag();
            if (tracker == null) {
                attribute.echoError("Cannot read flag_expiration tag for '" + object + "': " + object.getReasonNotFlaggable());
                return null;
            }
            return tracker.doFlagExpirationTag(attribute);
        }, new String[0]);
        processor.registerTag(ListTag.class, "list_flags", (attribute, object) -> {
            AbstractFlagTracker tracker = object.getFlagTrackerForTag();
            if (tracker == null) {
                attribute.echoError("Cannot read list_flags tag for '" + object + "': " + object.getReasonNotFlaggable());
                return null;
            }
            return tracker.doListFlagsTag(attribute);
        }, new String[0]);
        processor.registerTag(MapTag.class, "flag_map", (attribute, object) -> {
            AbstractFlagTracker tracker = object.getFlagTrackerForTag();
            if (tracker == null) {
                attribute.echoError("Cannot read flag_map tag for '" + object + "': " + object.getReasonNotFlaggable());
                return null;
            }
            return tracker.doFlagMapTag(attribute);
        }, new String[0]);
        processor.registerMechanism("clean_flags", false, (object, mechanism) -> object.getFlagTracker().doTotalClean());
    }

    public ElementTag doHasFlagTag(Attribute attribute) {
        if (!attribute.hasParam()) {
            attribute.echoError("The has_flag[...] tag must have an input!");
            return null;
        }
        return new ElementTag(this.hasFlag(attribute.getParam()));
    }

    public ObjectTag doFlagTag(Attribute attribute) {
        if (!attribute.hasParam()) {
            attribute.echoError("The flag[...] tag must have an input!");
            return null;
        }
        if (attribute.getAttributeWithoutParam(2).equals("is_expired")) {
            Deprecations.flagIsExpiredTag.warn(attribute.context);
            boolean result = !this.hasFlag(attribute.getParam());
            attribute.fulfill(1);
            return new ElementTag(result);
        }
        if (attribute.getAttributeWithoutParam(2).equals("expiration")) {
            Deprecations.flagExpirationTag.warn(attribute.context);
            TimeTag time = this.getFlagExpirationTime(attribute.getParam());
            if (time == null) {
                return null;
            }
            attribute.fulfill(1);
            return new DurationTag((double)(time.millis() - TimeTag.now().millis()) / 1000.0);
        }
        String flagName = attribute.getParam();
        ObjectTag retVal = this.getFlagValue(flagName);
        if (retVal == null) {
            attribute.echoError("No flag named '" + flagName + "' (did you forget to set it, or has it already expired? Or did you forget a 'has_flag' check?)");
            return null;
        }
        return retVal.refreshState();
    }

    public TimeTag doFlagExpirationTag(Attribute attribute) {
        if (!attribute.hasParam()) {
            attribute.echoError("The flag_expiration[...] tag must have an input!");
            return null;
        }
        String flagName = attribute.getParam();
        TimeTag result = this.getFlagExpirationTime(flagName);
        if (result == null) {
            if (this.hasFlag(flagName)) {
                attribute.echoError("Flag '" + flagName + "' exists but has no expiration set (did you forget to specify the 'expire:' time when setting the flag?)");
            } else {
                attribute.echoError("No flag named '" + flagName + "' (did you forget to set it, or has it already expired?)");
            }
        }
        return result;
    }

    public ListTag doListFlagsTag(Attribute attribute) {
        if (attribute.getScriptEntry() != null && attribute.getScriptEntry().getScript() != null && !CoreConfiguration.listFlagsAllowed) {
            listFlagsTagWarning.warn(attribute.context);
        }
        ListTag list = new ListTag();
        list.addAll((Collection<? extends String>)this.listAllFlags());
        return list;
    }

    public MapTag getFlagMap() {
        MapTag result = new MapTag();
        for (String key : this.listAllFlags()) {
            result.putObject(key, this.getRootMap(key));
        }
        return result;
    }

    public MapTag doFlagMapTag(Attribute attribute) {
        if (!attribute.hasParam()) {
            if (attribute.getScriptEntry() != null && attribute.getScriptEntry().getScript() != null && !CoreConfiguration.listFlagsAllowed) {
                listFlagsTagWarning.warn(attribute.context);
            }
            return this.getFlagMap();
        }
        MapTag result = new MapTag();
        ListTag clear = new ListTag();
        for (String key : attribute.paramAsType(ListTag.class)) {
            MapTag map = this.getRootMap(key);
            if (map != null) {
                result.putObject(key, map);
                continue;
            }
            clear.addObject(new ElementTag(key, true));
        }
        if (!clear.isEmpty()) {
            result.putObject("__clear", clear);
        }
        return result;
    }

    public void doTotalClean() {
    }
}

