/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.player;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.objects.BiomeTag;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import org.bukkit.block.Biome;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerMoveEvent;

public class BiomeEnterExitScriptEvent
extends BukkitScriptEvent
implements Listener {
    public LocationTag from;
    public LocationTag to;
    public BiomeTag old_biome;
    public BiomeTag new_biome;
    public PlayerMoveEvent event;

    public BiomeEnterExitScriptEvent() {
        this.registerCouldMatcher("player enters|exits <biome>");
        this.registerSwitches("biome");
    }

    @Override
    public boolean couldMatch(ScriptEvent.ScriptPath path) {
        if (!super.couldMatch(path)) {
            return false;
        }
        return path.eventArgLowerAt(2).equals("biome") || BiomeEnterExitScriptEvent.couldMatchEnum(path.eventArgLowerAt(2), Biome.values());
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        BiomeTag biome;
        String biome_test = path.eventArgAt(2);
        String direction = path.eventArgAt(1);
        if (!this.runInCheck(path, this.from) && !this.runInCheck(path, this.to)) {
            return false;
        }
        BiomeTag biomeTag = direction.equals("enters") ? this.new_biome : (biome = direction.equals("exits") ? this.old_biome : null);
        if (biome == null) {
            return false;
        }
        if (!biome_test.equals("biome") && !biome_test.equals(CoreUtilities.toLowerCase(biome.getBiome().getName()))) {
            return false;
        }
        if (!BiomeEnterExitScriptEvent.runGenericSwitchCheck(path, "biome", biome.getBiome().getName())) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(EntityTag.getPlayerFrom((Entity)this.event.getPlayer()), null);
    }

    @Override
    public ObjectTag getContext(String name) {
        switch (name) {
            case "to": {
                return this.to;
            }
            case "from": {
                return this.from;
            }
            case "old_biome": {
                return this.old_biome;
            }
            case "new_biome": {
                return this.new_biome;
            }
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onPlayerEntersExitsBiome(PlayerMoveEvent event) {
        if (LocationTag.isSameBlock(event.getFrom(), event.getTo())) {
            return;
        }
        if (!Utilities.isLocationYSafe(event.getFrom()) || !Utilities.isLocationYSafe(event.getTo())) {
            return;
        }
        this.from = new LocationTag(event.getFrom());
        this.to = new LocationTag(event.getTo());
        this.old_biome = new BiomeTag(NMSHandler.instance.getBiomeAt(this.from.getBlock()));
        this.new_biome = new BiomeTag(NMSHandler.instance.getBiomeAt(this.to.getBlock()));
        if (this.old_biome.identify().equals(this.new_biome.identify())) {
            return;
        }
        this.event = event;
        this.fire((Event)event);
    }
}

