/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.containers.core;

import com.denizenscript.denizen.Denizen;
import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.abstracts.ImprovedOfflinePlayer;
import com.denizenscript.denizen.objects.InventoryTag;
import com.denizenscript.denizen.scripts.containers.core.InventoryScriptContainer;
import com.denizenscript.denizencore.objects.core.ScriptTag;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerLoginEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.plugin.Plugin;

public class InventoryScriptHelper
implements Listener {
    public static Map<Inventory, InventoryTag> notedInventories = new HashMap<Inventory, InventoryTag>();
    public static HashMap<String, InventoryScriptContainer> inventoryScripts = new HashMap();
    public static HashSet<ClickType> allowedClicks = new HashSet<ClickType>(Arrays.asList(ClickType.CONTROL_DROP, ClickType.CREATIVE, ClickType.DROP, ClickType.LEFT, ClickType.MIDDLE, ClickType.NUMBER_KEY, ClickType.RIGHT, ClickType.WINDOW_BORDER_LEFT, ClickType.WINDOW_BORDER_RIGHT));

    public static boolean isPersonalSpecialInv(InventoryType type) {
        return type == InventoryType.ANVIL || type == InventoryType.WORKBENCH;
    }

    public static boolean isPersonalSpecialInv(Inventory inv) {
        return InventoryScriptHelper.isPersonalSpecialInv(inv.getType());
    }

    public InventoryScriptHelper() {
        Denizen.getInstance().getServer().getPluginManager().registerEvents((Listener)this, (Plugin)Denizen.getInstance());
    }

    public static void _savePlayerInventories() {
        for (Map.Entry<UUID, PlayerInventory> entry : ImprovedOfflinePlayer.offlineInventories.entrySet()) {
            NMSHandler.playerHelper.getOfflineData(entry.getKey()).setInventory(entry.getValue());
        }
        for (Map.Entry<UUID, PlayerInventory> entry : ImprovedOfflinePlayer.offlineEnderChests.entrySet()) {
            NMSHandler.playerHelper.getOfflineData(entry.getKey()).setEnderChest((Inventory)entry.getValue());
        }
    }

    @EventHandler
    public void onPlayerLogin(PlayerLoginEvent event) {
        UUID uuid = event.getPlayer().getUniqueId();
        if (ImprovedOfflinePlayer.offlineInventories.containsKey(uuid)) {
            NMSHandler.playerHelper.getOfflineData(uuid).setInventory(ImprovedOfflinePlayer.offlineInventories.get(uuid));
            ImprovedOfflinePlayer.offlineInventories.remove(uuid);
        }
        if (ImprovedOfflinePlayer.offlineEnderChests.containsKey(uuid)) {
            NMSHandler.playerHelper.getOfflineData(uuid).setEnderChest(ImprovedOfflinePlayer.offlineEnderChests.get(uuid));
            ImprovedOfflinePlayer.offlineEnderChests.remove(uuid);
        }
    }

    public static boolean isGUI(Inventory inv) {
        InventoryTag inventory = InventoryTag.mirrorBukkitInventory(inv);
        return inventory.getIdHolder() instanceof ScriptTag && ((InventoryScriptContainer)((ScriptTag)inventory.getIdHolder()).getContainer()).gui;
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onPlayerClicks(InventoryClickEvent event) {
        if ((event.getRawSlot() >= event.getInventory().getSize() || event.getRawSlot() < 0) && allowedClicks.contains(event.getClick())) {
            return;
        }
        if (InventoryScriptHelper.isGUI(event.getInventory())) {
            event.setCancelled(true);
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)Denizen.getInstance(), () -> ((Player)event.getWhoClicked()).updateInventory(), 1L);
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onPlayerDrags(InventoryDragEvent event) {
        if (InventoryScriptHelper.isGUI(event.getInventory())) {
            boolean anyInTop = false;
            Iterator iterator = event.getRawSlots().iterator();
            while (iterator.hasNext()) {
                int slot = (Integer)iterator.next();
                if (slot >= event.getInventory().getSize()) continue;
                anyInTop = true;
                break;
            }
            if (anyInTop) {
                event.setCancelled(true);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onPlayerCloses(InventoryCloseEvent event) {
        if (InventoryScriptHelper.isPersonalSpecialInv(event.getInventory()) && InventoryScriptHelper.isGUI(event.getInventory())) {
            event.getInventory().clear();
        }
    }
}

