/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.objects.core;

import com.denizenscript.denizencore.objects.Fetchable;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.tags.ObjectTagProcessor;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.utilities.AsciiMatcher;
import com.denizenscript.denizencore.utilities.CoreConfiguration;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.ReflectionHelper;
import com.denizenscript.denizencore.utilities.ReflectionRefuse;
import com.denizenscript.denizencore.utilities.debugging.DebugInternals;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import java.util.function.Consumer;

public class JavaReflectedObjectTag
implements ObjectTag {
    public static AsciiMatcher VALID_UUID_SYMBOLS = new AsciiMatcher("0123456789abcdefABCDEF-");
    public static HashMap<UUID, JavaReflectedObjectTag> persistedReferences = new HashMap();
    private static ArrayList<UUID> toRemoveHelper = new ArrayList();
    public static long lastCleared;
    public static long clearRateSeconds;
    public Object object;
    public UUID id;
    public long lastIdentified;
    private String prefix = "Reflected";
    public static ObjectTagProcessor<JavaReflectedObjectTag> tagProcessor;

    @Fetchable(value="reflected")
    public static JavaReflectedObjectTag valueOf(String string, TagContext context) {
        if (string == null) {
            return null;
        }
        if (!string.startsWith("reflected@")) {
            return null;
        }
        String id = string.substring("reflected@".length());
        if (!id.contains("-") || id.length() != 36 || !VALID_UUID_SYMBOLS.isOnlyMatches(id)) {
            return null;
        }
        JavaReflectedObjectTag.clearOldRefs();
        try {
            UUID uuid = UUID.fromString(id);
            return persistedReferences.get(uuid);
        }
        catch (IllegalArgumentException ex) {
            return null;
        }
    }

    public static boolean matches(String string) {
        return string.startsWith("reflected@");
    }

    public static void clearOldRefs() {
        long time = CoreUtilities.monotonicMillis();
        if (lastCleared + clearRateSeconds * 500L > time) {
            return;
        }
        lastCleared = time;
        for (JavaReflectedObjectTag ref : persistedReferences.values()) {
            if (ref.lastIdentified + clearRateSeconds * 1000L >= time) continue;
            toRemoveHelper.add(ref.id);
        }
        for (UUID toRemove : toRemoveHelper) {
            persistedReferences.remove(toRemove);
        }
    }

    public JavaReflectedObjectTag(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        if (object.getClass().isAnnotationPresent(ReflectionRefuse.class)) {
            throw new RuntimeException("Cannot reflect into object of class " + object.getClass().getName() + " as it has a reflection refusal marked.");
        }
        this.object = object;
        this.id = UUID.randomUUID();
    }

    public void persist() {
        JavaReflectedObjectTag.clearOldRefs();
        this.lastIdentified = CoreUtilities.monotonicMillis();
        persistedReferences.put(this.id, this);
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public ObjectTag setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    @Override
    public boolean isUnique() {
        return true;
    }

    @Override
    public String debuggable() {
        return "<LG>reflected@<GR>" + this.id + " <LG>(<GR>" + this.object + "<LG>)";
    }

    @Override
    public String identify() {
        this.persist();
        return "reflected@" + this.id;
    }

    @Override
    public String identifySimple() {
        return this.identify();
    }

    public String toString() {
        return this.identify();
    }

    @Override
    public Object getJavaObject() {
        return this.object;
    }

    public static void registerTags() {
        tagProcessor.registerStaticTag(ElementTag.class, "simple_class_name", (attribute, object) -> new ElementTag(DebugInternals.getClassNameOpti(object.object.getClass())), new String[0]);
        tagProcessor.registerStaticTag(ListTag.class, "super_classes", (attribute, object) -> {
            ListTag classes = new ListTag();
            for (Class<?> clazz = object.object.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
                classes.add(clazz.getName());
            }
            return classes;
        }, new String[0]);
        tagProcessor.registerStaticTag(ElementTag.class, "full_class_name", (attribute, object) -> new ElementTag(object.object.getClass().getName()), new String[0]);
        tagProcessor.registerTag(ObjectTag.class, "interpret", (attribute, object) -> {
            if (!CoreConfiguration.allowReflectedCoreMethods) {
                attribute.echoError("Core-reflected-method-calling tags are forbidden by current Denizen config.");
                return null;
            }
            return CoreUtilities.objectToTagForm(object.object, attribute.context);
        }, new String[0]);
        tagProcessor.registerTag(ObjectTag.class, "to_string", (attribute, object) -> {
            if (!CoreConfiguration.allowReflectedCoreMethods) {
                attribute.echoError("Core-reflected-method-calling tags are forbidden by current Denizen config.");
                return null;
            }
            return new ElementTag(object.object.toString());
        }, new String[0]);
        tagProcessor.registerTag(ObjectTag.class, "hash_code", (attribute, object) -> {
            if (!CoreConfiguration.allowReflectedCoreMethods) {
                attribute.echoError("Core-reflected-method-calling tags are forbidden by current Denizen config.");
                return null;
            }
            return new ElementTag(object.object.hashCode());
        }, new String[0]);
        tagProcessor.registerTag(ObjectTag.class, JavaReflectedObjectTag.class, "java_equals", (attribute, object, compareTo) -> {
            if (!CoreConfiguration.allowReflectedCoreMethods) {
                attribute.echoError("Core-reflected-method-calling tags are forbidden by current Denizen config.");
                return null;
            }
            return new ElementTag(object.object.equals(compareTo.object));
        }, new String[0]);
        tagProcessor.registerStaticTag(ObjectTag.class, JavaReflectedObjectTag.class, "memory_equals", (attribute, object, compareTo) -> {
            if (!CoreConfiguration.allowReflectedCoreMethods) {
                attribute.echoError("Core-reflected-method-calling tags are forbidden by current Denizen config.");
                return null;
            }
            return new ElementTag(object.object == compareTo.object);
        }, new String[0]);
        tagProcessor.registerStaticTag(ListTag.class, "field_names", (attribute, object) -> {
            if (!CoreConfiguration.allowReflectionFieldReads) {
                attribute.echoError("Field-reading tags are forbidden by current Denizen config.");
                return null;
            }
            ListTag fields = new ListTag();
            for (Class<?> clazz = object.object.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
                fields.addAll(ReflectionHelper.getFields(clazz).keySet());
            }
            return fields;
        }, new String[0]);
        tagProcessor.registerStaticTag(ElementTag.class, ElementTag.class, "field_is_public", (attribute, object, fieldName) -> {
            if (JavaReflectedObjectTag.denyFieldTag(attribute)) {
                return null;
            }
            Field f = object.getFieldForTag(attribute::echoError, fieldName.asString());
            if (f == null) {
                return null;
            }
            return new ElementTag(Modifier.isPublic(f.getModifiers()));
        }, new String[0]);
        tagProcessor.registerStaticTag(ElementTag.class, ElementTag.class, "field_is_private", (attribute, object, fieldName) -> {
            if (JavaReflectedObjectTag.denyFieldTag(attribute)) {
                return null;
            }
            Field f = object.getFieldForTag(attribute::echoError, fieldName.asString());
            if (f == null) {
                return null;
            }
            return new ElementTag(Modifier.isPrivate(f.getModifiers()));
        }, new String[0]);
        tagProcessor.registerStaticTag(ElementTag.class, ElementTag.class, "field_is_protected", (attribute, object, fieldName) -> {
            if (JavaReflectedObjectTag.denyFieldTag(attribute)) {
                return null;
            }
            Field f = object.getFieldForTag(attribute::echoError, fieldName.asString());
            if (f == null) {
                return null;
            }
            return new ElementTag(Modifier.isProtected(f.getModifiers()));
        }, new String[0]);
        tagProcessor.registerStaticTag(ElementTag.class, ElementTag.class, "field_is_static", (attribute, object, fieldName) -> {
            if (JavaReflectedObjectTag.denyFieldTag(attribute)) {
                return null;
            }
            Field f = object.getFieldForTag(attribute::echoError, fieldName.asString());
            if (f == null) {
                return null;
            }
            return new ElementTag(Modifier.isStatic(f.getModifiers()));
        }, new String[0]);
        tagProcessor.registerStaticTag(ElementTag.class, ElementTag.class, "field_is_final", (attribute, object, fieldName) -> {
            if (JavaReflectedObjectTag.denyFieldTag(attribute)) {
                return null;
            }
            Field f = object.getFieldForTag(attribute::echoError, fieldName.asString());
            if (f == null) {
                return null;
            }
            return new ElementTag(Modifier.isFinal(f.getModifiers()));
        }, new String[0]);
        tagProcessor.registerStaticTag(ElementTag.class, ElementTag.class, "field_class_type", (attribute, object, fieldName) -> {
            if (JavaReflectedObjectTag.denyFieldTag(attribute)) {
                return null;
            }
            Field f = object.getFieldForTag(attribute::echoError, fieldName.asString());
            if (f == null) {
                return null;
            }
            return new ElementTag(f.getType().getName());
        }, new String[0]);
        tagProcessor.registerTag(ObjectTag.class, ElementTag.class, "read_field", (attribute, object, fieldName) -> {
            if (JavaReflectedObjectTag.denyFieldTag(attribute)) {
                return null;
            }
            Object val = object.readFieldForTag(attribute, fieldName.asString());
            if (val == null) {
                return null;
            }
            return CoreUtilities.objectToTagForm(val, attribute.context, false, false, false);
        }, new String[0]);
        tagProcessor.registerTag(JavaReflectedObjectTag.class, ElementTag.class, "reflect_field", (attribute, object, fieldName) -> {
            if (JavaReflectedObjectTag.denyFieldTag(attribute)) {
                return null;
            }
            Object val = object.readFieldForTag(attribute, fieldName.asString());
            if (val == null) {
                return null;
            }
            return new JavaReflectedObjectTag(val);
        }, new String[0]);
    }

    public Field getFieldForTag(Consumer<String> error, String fieldName) {
        Field field = null;
        if (this.object instanceof Class) {
            field = ReflectionHelper.getFields((Class)this.object).getNoCheck(fieldName);
            if (field == null) {
                error.accept("Field '" + fieldName + "' does not exist in class: " + ((Class)this.object).getName());
            }
        } else {
            Class<?> clazz = this.object.getClass();
            while (field == null && clazz != Object.class) {
                field = ReflectionHelper.getFields(clazz).getNoCheck(fieldName);
                if (field != null) continue;
                clazz = clazz.getSuperclass();
            }
            if (field == null) {
                error.accept("Field '" + fieldName + "' does not exist in class: " + this.object.getClass().getName());
            }
        }
        return field;
    }

    public static boolean denyFieldTag(Attribute attribute) {
        if (!CoreConfiguration.allowReflectionFieldReads) {
            attribute.echoError("Field-reading tags are forbidden by current Denizen config.");
            return true;
        }
        return !attribute.hasParam();
    }

    public Object readFieldForTag(Attribute attribute, String fieldName) {
        Field field = this.getFieldForTag(attribute::echoError, fieldName);
        if (field == null) {
            return null;
        }
        if (field.isAnnotationPresent(ReflectionRefuse.class) || field.getType().isAnnotationPresent(ReflectionRefuse.class)) {
            attribute.echoError("Cannot read field '" + field.getName() + "' in class '" + field.getDeclaringClass().getName() + "' because it is marked for reflection refusal.");
            return null;
        }
        if (this.object instanceof Class && !Modifier.isStatic(field.getModifiers())) {
            attribute.echoError("Cannot read field '" + field.getName() + "' in class '" + field.getDeclaringClass().getName() + "' because the field is not static.");
            return null;
        }
        return ReflectionHelper.getFieldValue(field.getDeclaringClass(), fieldName, Modifier.isStatic(field.getModifiers()) || this.object instanceof Class ? null : this.object);
    }

    @Override
    public ObjectTag getObjectAttribute(Attribute attribute) {
        return tagProcessor.getObjectAttribute(this, attribute);
    }

    static {
        clearRateSeconds = 60L;
        tagProcessor = new ObjectTagProcessor();
    }
}

