/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.scripts.commands.file;

import com.denizenscript.denizencore.DenizenCore;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.scripts.commands.Holdable;
import com.denizenscript.denizencore.scripts.commands.generator.ArgName;
import com.denizenscript.denizencore.scripts.commands.generator.ArgPrefixed;
import com.denizenscript.denizencore.utilities.CoreConfiguration;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import java.io.File;
import java.nio.file.CopyOption;
import java.nio.file.Files;

public class FileCopyCommand
extends AbstractCommand
implements Holdable {
    public FileCopyCommand() {
        this.setName("filecopy");
        this.setSyntax("filecopy [origin:<origin>] [destination:<destination>] (overwrite)");
        this.setRequiredArguments(2, 3);
        this.isProcedural = false;
        this.autoCompile();
        this.addRemappedPrefixes("destination", "d");
        this.addRemappedPrefixes("origin", "o");
    }

    public static void autoExecute(ScriptEntry scriptEntry, @ArgPrefixed @ArgName(value="origin") String origin, @ArgPrefixed @ArgName(value="destination") String destination, @ArgName(value="overwrite") boolean overwrite) {
        boolean disdir;
        if (!CoreConfiguration.allowFileCopy) {
            Debug.echoError(scriptEntry, "File copy disabled by server administrator (refer to command documentation).");
            scriptEntry.addObject("success", new ElementTag("false"));
            scriptEntry.setFinished(true);
            return;
        }
        File o = new File(DenizenCore.implementation.getDataFolder(), origin);
        File d = new File(DenizenCore.implementation.getDataFolder(), destination);
        boolean dexists = d.exists();
        boolean bl = disdir = d.isDirectory() || destination.endsWith("/");
        if (!DenizenCore.implementation.canReadFile(o)) {
            Debug.echoError("Cannot read from that file path due to security settings in Denizen/config.yml.");
            scriptEntry.addObject("success", new ElementTag("false"));
            scriptEntry.setFinished(true);
            return;
        }
        if (!o.exists()) {
            Debug.echoError(scriptEntry, "File copy failed, origin does not exist!");
            scriptEntry.addObject("success", new ElementTag("false"));
            scriptEntry.setFinished(true);
            return;
        }
        if (!DenizenCore.implementation.canWriteToFile(d)) {
            Debug.echoError("Cannot write to that file path due to security settings in Denizen/config.yml.");
            scriptEntry.addObject("success", new ElementTag("false"));
            scriptEntry.setFinished(true);
            return;
        }
        if (dexists && !disdir && !overwrite) {
            Debug.echoDebug((Debuggable)scriptEntry, "File copy ignored, destination file already exists!");
            scriptEntry.addObject("success", new ElementTag("false"));
            scriptEntry.setFinished(true);
            return;
        }
        Runnable runme = () -> {
            try {
                if (dexists && !disdir) {
                    d.delete();
                }
                if (disdir && !dexists) {
                    d.mkdirs();
                } else if (!dexists && !d.getParentFile().exists()) {
                    d.getParentFile().mkdirs();
                }
                if (o.isDirectory()) {
                    CoreUtilities.copyDirectory(o, d, null);
                } else {
                    Files.copy(o.toPath(), disdir ? d.toPath().resolve(o.toPath().getFileName()) : d.toPath(), new CopyOption[0]);
                }
                scriptEntry.addObject("success", new ElementTag("true"));
                scriptEntry.setFinished(true);
            }
            catch (Exception e) {
                Debug.echoError(scriptEntry, e);
                scriptEntry.addObject("success", new ElementTag("false"));
                scriptEntry.setFinished(true);
            }
        };
        if (scriptEntry.shouldWaitFor()) {
            DenizenCore.runAsync(runme);
        } else {
            runme.run();
        }
    }
}

