/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.material;

import com.denizenscript.denizen.objects.MaterialTag;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.objects.properties.PropertyParser;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.Directional;
import org.bukkit.block.data.FaceAttachable;

public class MaterialSwitchFace
implements Property {
    public static final String[] handledMechs = new String[]{"switch_face"};
    MaterialTag material;

    public static boolean describes(ObjectTag material) {
        return material instanceof MaterialTag && ((MaterialTag)material).hasModernData() && ((MaterialTag)material).getModernData() instanceof FaceAttachable;
    }

    public static MaterialSwitchFace getFrom(ObjectTag _material) {
        if (!MaterialSwitchFace.describes(_material)) {
            return null;
        }
        return new MaterialSwitchFace((MaterialTag)_material);
    }

    private MaterialSwitchFace(MaterialTag _material) {
        this.material = _material;
    }

    public static void registerTags() {
        PropertyParser.registerStaticTag(MaterialSwitchFace.class, ElementTag.class, "switch_face", (attribute, material) -> new ElementTag((Enum<?>)material.getFaceAttachable().getAttachedFace()), new String[0]);
    }

    public FaceAttachable getFaceAttachable() {
        return (FaceAttachable)this.material.getModernData();
    }

    @Override
    public String getPropertyString() {
        return this.getFaceAttachable().getAttachedFace().name();
    }

    public BlockFace getAttachedTo() {
        switch (this.getFaceAttachable().getAttachedFace()) {
            case WALL: {
                if (this.material.getModernData() instanceof Directional) {
                    return ((Directional)this.material.getModernData()).getFacing().getOppositeFace();
                }
            }
            case FLOOR: {
                return BlockFace.DOWN;
            }
            case CEILING: {
                return BlockFace.UP;
            }
        }
        return BlockFace.SELF;
    }

    @Override
    public String getPropertyId() {
        return "switch_face";
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("switch_face") && mechanism.requireEnum(FaceAttachable.AttachedFace.class)) {
            this.getFaceAttachable().setAttachedFace(FaceAttachable.AttachedFace.valueOf((String)mechanism.getValue().asString().toUpperCase()));
        }
    }
}

