/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.dns;

import com.mongodb.MongoClientException;
import com.mongodb.spi.dns.DnsClient;
import com.mongodb.spi.dns.DnsException;
import com.mongodb.spi.dns.DnsWithResponseCodeException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.InitialDirContext;

final class JndiDnsClient
implements DnsClient {
    JndiDnsClient() {
    }

    @Override
    public List<String> getResourceRecordData(String name, String type) throws DnsException {
        ArrayList<String> arrayList;
        InitialDirContext dirContext = JndiDnsClient.createDnsDirContext();
        try {
            Attribute attribute = dirContext.getAttributes(name, new String[]{type}).get(type);
            if (attribute == null) {
                List<String> list = Collections.emptyList();
                return list;
            }
            ArrayList<String> attributeValues = new ArrayList<String>();
            NamingEnumeration<?> namingEnumeration = attribute.getAll();
            while (namingEnumeration.hasMore()) {
                attributeValues.add((String)namingEnumeration.next());
            }
            arrayList = attributeValues;
        }
        catch (NameNotFoundException e) {
            throw new DnsWithResponseCodeException(e.getMessage(), 3, e);
        }
        catch (NamingException e) {
            throw new DnsException(e.getMessage(), e);
        }
        finally {
            try {
                dirContext.close();
            }
            catch (NamingException namingException) {}
        }
        return arrayList;
    }

    private static InitialDirContext createDnsDirContext() {
        Hashtable<String, String> envProps = new Hashtable<String, String>();
        envProps.put("java.naming.factory.initial", "com.sun.jndi.dns.DnsContextFactory");
        try {
            return new InitialDirContext(envProps);
        }
        catch (NamingException e) {
            envProps.put("java.naming.provider.url", "dns:");
            try {
                return new InitialDirContext(envProps);
            }
            catch (NamingException ex) {
                throw new MongoClientException("Unable to support mongodb+srv// style connections as the 'com.sun.jndi.dns.DnsContextFactory' class is not available in this JRE. A JNDI context is required for resolving SRV records.", e);
            }
        }
    }
}

